/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi.support;

import org.hibernate.cache.cfg.spi.NaturalIdDataCachingConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.support.AbstractCachedDomainDataAccess;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;

public abstract class AbstractNaturalIdDataAccess
extends AbstractCachedDomainDataAccess
implements NaturalIdDataAccess {
    private final CacheKeysFactory keysFactory;

    public AbstractNaturalIdDataAccess(DomainDataRegion region, CacheKeysFactory keysFactory, DomainDataStorageAccess storageAccess, NaturalIdDataCachingConfig config) {
        super(region, storageAccess);
        this.keysFactory = keysFactory;
    }

    @Override
    public Object generateCacheKey(Object naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return this.keysFactory.createNaturalIdKey(naturalIdValues, persister, session);
    }

    @Override
    public Object getNaturalIdValues(Object cacheKey) {
        return this.keysFactory.getNaturalIdValues(cacheKey);
    }

    @Override
    public boolean insert(SharedSessionContractImplementor session, Object key, Object value) {
        this.getStorageAccess().putIntoCache(key, value, session);
        return true;
    }

    @Override
    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value) {
        return false;
    }

    @Override
    public boolean update(SharedSessionContractImplementor session, Object key, Object value) {
        this.getStorageAccess().putIntoCache(key, value, session);
        return true;
    }

    @Override
    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, SoftLock lock) {
        return false;
    }

    @Override
    public SoftLock lockRegion() {
        return null;
    }

    @Override
    public void unlockRegion(SoftLock lock) {
        this.clearCache();
    }

    @Override
    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) {
        return null;
    }

    @Override
    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) {
    }
}

