/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;

public class ManagementResponseHeader
extends ManagementProtocolHeader {
    private int responseId;
    private boolean failed = false;
    private String error;

    public ManagementResponseHeader(int version, int responseId, String error) {
        super(version);
        this.responseId = responseId;
        this.error = error;
        this.failed = error != null;
    }

    ManagementResponseHeader(int version, DataInput input) throws IOException {
        super(version);
        this.read(input);
    }

    public void read(DataInput input) throws IOException {
        ProtocolUtils.expectHeader(input, 32);
        this.responseId = input.readInt();
        ProtocolUtils.expectHeader(input, 33);
        byte type = input.readByte();
        if (type == 35) {
            this.failed = true;
            this.error = input.readUTF();
        } else if (type != 34) {
            throw ProtocolLogger.ROOT_LOGGER.invalidType("RESPONSE_ERROR", "RESPONSE_BODY", type);
        }
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.write(32);
        output.writeInt(this.responseId);
        output.write(33);
        if (this.error != null) {
            output.write(35);
            output.writeUTF(this.error);
        } else {
            output.write(34);
        }
    }

    public boolean isFailed() {
        return this.failed;
    }

    public int getResponseId() {
        return this.responseId;
    }

    public String getError() {
        return this.error;
    }

    @Override
    public byte getType() {
        return 3;
    }

    public static ManagementResponseHeader create(ManagementProtocolHeader header) {
        return ManagementResponseHeader.create((ManagementRequestHeader)ManagementRequestHeader.class.cast(header));
    }

    public static ManagementResponseHeader create(ManagementRequestHeader header) {
        return ManagementResponseHeader.create((ManagementProtocolHeader)header, header.getRequestId());
    }

    public static ManagementResponseHeader create(ManagementRequestHeader header, Throwable error) {
        int workingVersion = Math.min(2, header.getVersion());
        return new ManagementResponseHeader(workingVersion, header.getRequestId(), error != null ? error.getClass().getName() + ":" + error.getMessage() : null);
    }

    public static ManagementResponseHeader create(ManagementProtocolHeader header, int responseId) {
        int workingVersion = Math.min(2, header.getVersion());
        return new ManagementResponseHeader(workingVersion, responseId, null);
    }
}

