/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.util.graal;

import org.aesh.command.Command;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.terminal.utils.Config;

public class GraalReflectionFileGenerator {
    private boolean booleanOption = false;
    private boolean fileOption = false;
    private boolean hasOptions = false;

    public String generateReflection(CommandLineParser<CommandInvocation> parser) {
        StringBuilder builder = new StringBuilder("[").append(Config.getLineSeparator());
        this.parseCommand(parser.getProcessedCommand(), builder);
        if (parser.isGroupCommand()) {
            for (CommandLineParser<CommandInvocation> child : parser.getAllChildParsers()) {
                builder.append("  },").append(Config.getLineSeparator());
                this.parseCommand(child.getProcessedCommand(), builder);
            }
        }
        if (this.hasOptions) {
            this.appendOptions(parser.getProcessedCommand(), builder);
        } else {
            builder.append(Config.getLineSeparator()).append("  }");
        }
        return builder.append(Config.getLineSeparator()).append("]").toString();
    }

    private void parseCommand(ProcessedCommand<Command<CommandInvocation>, CommandInvocation> command, StringBuilder builder) {
        builder.append("  {").append(Config.getLineSeparator());
        this.appendCommand(command, builder);
    }

    private void appendOptions(ProcessedCommand<Command<CommandInvocation>, CommandInvocation> command, StringBuilder builder) {
        builder.append("  },").append(Config.getLineSeparator());
        builder.append("  {").append(Config.getLineSeparator()).append("    \"name\" : \"org.aesh.command.impl.parser.AeshOptionParser\", ").append(Config.getLineSeparator());
        this.appendDefaults(builder);
        builder.append(Config.getLineSeparator()).append("  }");
        if (this.booleanOption) {
            builder.append(',').append(Config.getLineSeparator());
            builder.append("  {").append(Config.getLineSeparator()).append("    \"name\" : \"org.aesh.command.impl.completer.BooleanOptionCompleter\", ").append(Config.getLineSeparator());
            this.appendDefaults(builder);
            builder.append(Config.getLineSeparator()).append("  }");
        }
        if (this.fileOption) {
            builder.append(',').append(Config.getLineSeparator());
            builder.append("  {").append(Config.getLineSeparator()).append("    \"name\" : \"org.aesh.command.impl.completer.FileOptionCompleter\", ").append(Config.getLineSeparator());
            this.appendDefaults(builder);
            builder.append(Config.getLineSeparator()).append("  }");
        }
    }

    private void appendDefaults(StringBuilder builder) {
        builder.append("    \"allDeclaredConstructors\" : true,").append(Config.getLineSeparator()).append("    \"allPublicConstructors\" : true,").append(Config.getLineSeparator()).append("    \"allDeclaredMethods\" : true,").append(Config.getLineSeparator()).append("    \"allPublicMethods\" : true");
    }

    private void appendCommand(ProcessedCommand<Command<CommandInvocation>, CommandInvocation> command, StringBuilder builder) {
        builder.append("    \"name\" : \"").append(command.getCommand().getClass().getName()).append("\",").append(Config.getLineSeparator());
        this.appendDefaults(builder);
        if (command.getOptions().size() > 0) {
            this.hasOptions = true;
            builder.append(",").append(Config.getLineSeparator()).append("    \"fields\" : [").append(Config.getLineSeparator());
            for (int i = 0; i < command.getOptions().size(); ++i) {
                builder.append("      { \"name\" : \"").append(command.getOptions().get(i).getFieldName()).append("\" }");
                if (i + 1 < command.getOptions().size()) {
                    builder.append(",").append(Config.getLineSeparator());
                } else {
                    builder.append(Config.getLineSeparator());
                }
                if (command.getOptions().get(i).type().getName().equalsIgnoreCase("boolean")) {
                    this.booleanOption = true;
                }
                if (!command.getOptions().get(i).type().getName().equalsIgnoreCase("java.io.file") && !command.getOptions().get(i).type().getName().equalsIgnoreCase("org.aesh.io.resource")) continue;
                this.fileOption = true;
            }
            builder.append("    ]").append(Config.getLineSeparator());
        }
    }
}

