/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.workmanager.transport;

import jakarta.resource.spi.work.DistributableWork;
import jakarta.resource.spi.work.WorkException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.workmanager.transport.AddWorkManagerCommand;
import org.jboss.as.connector.services.workmanager.transport.ClearDistributedStatisticsCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaDoWorkAcceptedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaDoWorkRejectedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaScheduleWorkAcceptedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaScheduleWorkRejectedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaStartWorkAcceptedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaStartWorkRejectedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaWorkFailedCommand;
import org.jboss.as.connector.services.workmanager.transport.DeltaWorkSuccessfulCommand;
import org.jboss.as.connector.services.workmanager.transport.DistributedStatisticsCommand;
import org.jboss.as.connector.services.workmanager.transport.DoWorkCommand;
import org.jboss.as.connector.services.workmanager.transport.GetWorkManagersCommand;
import org.jboss.as.connector.services.workmanager.transport.JoinCommand;
import org.jboss.as.connector.services.workmanager.transport.LeaveCommand;
import org.jboss.as.connector.services.workmanager.transport.LongRunningFreeCommand;
import org.jboss.as.connector.services.workmanager.transport.PingCommand;
import org.jboss.as.connector.services.workmanager.transport.RemoveWorkManagerCommand;
import org.jboss.as.connector.services.workmanager.transport.ScheduleWorkCommand;
import org.jboss.as.connector.services.workmanager.transport.ShortRunningFreeCommand;
import org.jboss.as.connector.services.workmanager.transport.StartWorkCommand;
import org.jboss.as.connector.services.workmanager.transport.TransportCommand;
import org.jboss.as.connector.services.workmanager.transport.UpdateLongRunningFreeCommand;
import org.jboss.as.connector.services.workmanager.transport.UpdateShortRunningFreeCommand;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.jca.core.workmanager.transport.remote.AbstractRemoteTransport;
import org.jboss.jca.core.workmanager.transport.remote.ProtocolMessages;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.GroupMembership;
import org.wildfly.clustering.server.GroupMembershipEvent;
import org.wildfly.clustering.server.GroupMembershipListener;
import org.wildfly.clustering.server.GroupMembershipMergeEvent;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.dispatcher.Command;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.util.BlockingExecutor;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.manager.WildFlySecurityManager;

public class CommandDispatcherTransport
extends AbstractRemoteTransport<GroupMember>
implements GroupMembershipListener<GroupMember> {
    private final BlockingExecutor executor;
    private final CommandDispatcherFactory<GroupMember> dispatcherFactory;
    private final String name;
    private volatile CommandDispatcher<GroupMember, CommandDispatcherTransport> dispatcher;
    private volatile Registration groupListenerRegistration;
    private volatile boolean initialized = false;

    public CommandDispatcherTransport(CommandDispatcherFactory<GroupMember> dispatcherFactory, String name) {
        this.dispatcherFactory = dispatcherFactory;
        this.name = name;
        this.executor = BlockingExecutor.newInstance(() -> {
            try {
                this.broadcast(new LeaveCommand(this.getOwnAddress()));
            }
            catch (WorkException e) {
                ConnectorLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
            }
            finally {
                this.groupListenerRegistration.close();
                this.dispatcher.close();
            }
        });
    }

    public String getId() {
        return this.getOwnAddress().getName();
    }

    public void startup() throws Exception {
        this.dispatcher = this.dispatcherFactory.createCommandDispatcher((Object)this.name, (Object)this, WildFlySecurityManager.getClassLoaderPrivileged(((Object)((Object)this)).getClass()));
        this.groupListenerRegistration = this.dispatcherFactory.getGroup().register((Object)this);
        this.broadcast(new JoinCommand());
    }

    public void shutdown() {
        this.executor.close();
    }

    public void initialize() throws Exception {
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected GroupMember getOwnAddress() {
        return this.dispatcherFactory.getGroup().getLocalMember();
    }

    public void register(Address address) {
        this.nodes.put(address, null);
        if (address.getTransportId() == null || address.getTransportId().equals(this.getId())) {
            HashSet<GroupMember> sent = new HashSet<GroupMember>();
            for (GroupMember member : this.nodes.values()) {
                if (member == null || sent.contains(member)) continue;
                sent.add(member);
                try {
                    this.sendMessage(member, ProtocolMessages.Request.WORKMANAGER_ADD, address, this.getOwnAddress());
                }
                catch (WorkException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    protected Serializable sendMessage(GroupMember physicalAddress, ProtocolMessages.Request request, Serializable ... parameters) throws WorkException {
        return (Serializable)this.sendMessage(physicalAddress, request, (Object[])parameters);
    }

    private Object sendMessage(final GroupMember physicalAddress, ProtocolMessages.Request request, Object ... parameters) throws WorkException {
        final CommandDispatcher<GroupMember, CommandDispatcherTransport> dispatcher = this.dispatcher;
        final TransportCommand<?> command = CommandDispatcherTransport.createCommand(request, parameters);
        ExceptionSupplier<Optional<Object>, WorkException> task = new ExceptionSupplier<Optional<Object>, WorkException>(){

            public Optional<Object> get() throws WorkException {
                try {
                    CompletionStage response = dispatcher.dispatchToMember((Command)command, physicalAddress);
                    return Optional.ofNullable(response.toCompletableFuture().join());
                }
                catch (CancellationException e) {
                    return Optional.empty();
                }
                catch (IOException | CompletionException e) {
                    throw new WorkException((Throwable)e);
                }
            }
        };
        Optional value = this.executor.execute((ExceptionSupplier)task).orElse(null);
        return value != null ? value.orElse(null) : null;
    }

    private void broadcast(final TransportCommand<Void> command) throws WorkException {
        final CommandDispatcher<GroupMember, CommandDispatcherTransport> dispatcher = this.dispatcher;
        ExceptionRunnable<WorkException> task = new ExceptionRunnable<WorkException>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() throws WorkException {
                try {
                    for (Map.Entry entry : dispatcher.dispatchToGroup((Command)command).entrySet()) {
                        try {
                            ((CompletionStage)entry.getValue()).toCompletableFuture().join();
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (CompletionException e) {
                            throw new WorkException((Throwable)e);
                            return;
                        }
                    }
                }
                catch (IOException e) {
                    throw new WorkException((Throwable)e);
                }
            }
        };
        this.executor.execute((ExceptionRunnable)task);
    }

    private static TransportCommand<?> createCommand(ProtocolMessages.Request request, Object ... parameters) {
        Address address = parameters.length > 0 ? (Address)parameters[0] : null;
        switch (request) {
            case CLEAR_DISTRIBUTED_STATISTICS: {
                return new ClearDistributedStatisticsCommand(address);
            }
            case DELTA_DOWORK_ACCEPTED: {
                return new DeltaDoWorkAcceptedCommand(address);
            }
            case DELTA_DOWORK_REJECTED: {
                return new DeltaDoWorkRejectedCommand(address);
            }
            case DELTA_SCHEDULEWORK_ACCEPTED: {
                return new DeltaScheduleWorkAcceptedCommand(address);
            }
            case DELTA_SCHEDULEWORK_REJECTED: {
                return new DeltaScheduleWorkRejectedCommand(address);
            }
            case DELTA_STARTWORK_ACCEPTED: {
                return new DeltaStartWorkAcceptedCommand(address);
            }
            case DELTA_STARTWORK_REJECTED: {
                return new DeltaStartWorkRejectedCommand(address);
            }
            case DELTA_WORK_FAILED: {
                return new DeltaWorkFailedCommand(address);
            }
            case DELTA_WORK_SUCCESSFUL: {
                return new DeltaWorkSuccessfulCommand(address);
            }
            case DO_WORK: {
                return new DoWorkCommand(address, (DistributableWork)parameters[2]);
            }
            case GET_DISTRIBUTED_STATISTICS: {
                return new DistributedStatisticsCommand(address);
            }
            case GET_LONGRUNNING_FREE: {
                return new LongRunningFreeCommand(address);
            }
            case GET_SHORTRUNNING_FREE: {
                return new ShortRunningFreeCommand(address);
            }
            case PING: {
                return new PingCommand();
            }
            case SCHEDULE_WORK: {
                return new ScheduleWorkCommand(address, (DistributableWork)parameters[2]);
            }
            case START_WORK: {
                return new StartWorkCommand(address, (DistributableWork)parameters[2]);
            }
            case UPDATE_LONGRUNNING_FREE: {
                return new UpdateLongRunningFreeCommand(address, (Long)parameters[1]);
            }
            case UPDATE_SHORTRUNNING_FREE: {
                return new UpdateShortRunningFreeCommand(address, (Long)parameters[1]);
            }
            case WORKMANAGER_ADD: {
                return new AddWorkManagerCommand(address, (GroupMember)parameters[1]);
            }
            case WORKMANAGER_REMOVE: {
                return new RemoveWorkManagerCommand(address);
            }
        }
        throw new IllegalStateException(request.name());
    }

    public void updated(GroupMembershipEvent<GroupMember> event) {
        Runnable task = () -> {
            for (GroupMember leaver : event.getLeavers()) {
                this.leave(leaver);
            }
        };
        this.executor.execute(task);
    }

    public void merged(GroupMembershipMergeEvent<GroupMember> event) {
        Runnable task = () -> this.join((GroupMembership<GroupMember>)event.getCurrentMembership());
        this.executor.execute(task);
    }

    public void join() {
        this.join((GroupMembership<GroupMember>)this.dispatcherFactory.getGroup().getMembership());
    }

    private void join(GroupMembership<GroupMember> membership) {
        HashMap<GroupMember, CompletionStage> futures = new HashMap<GroupMember, CompletionStage>();
        for (GroupMember groupMember : membership.getMembers()) {
            if (this.getOwnAddress().equals(groupMember) || this.nodes.containsValue(groupMember)) continue;
            try {
                futures.put(groupMember, this.dispatcher.dispatchToMember((Command)new GetWorkManagersCommand(), groupMember));
            }
            catch (IOException e) {
                ConnectorLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
            }
        }
        for (Map.Entry entry : futures.entrySet()) {
            GroupMember member = (GroupMember)entry.getKey();
            try {
                Set addresses = (Set)((CompletionStage)entry.getValue()).toCompletableFuture().join();
                for (Address address : addresses) {
                    this.join(address, member);
                    this.localUpdateLongRunningFree(address, this.getShortRunningFree(address));
                    this.localUpdateShortRunningFree(address, this.getShortRunningFree(address));
                }
            }
            catch (CancellationException addresses) {
            }
            catch (CompletionException e) {
                ConnectorLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
            }
        }
    }
}

