/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.runtime.bytecode;

import java.util.Objects;
import java.util.Set;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedAnnotationUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedClassUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedFieldReference;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedMethodReference;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsageType;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ExtendsAnnotatedClass;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ImplementsAnnotatedInterface;

public abstract class AnnotationUsage {
    protected final Set<String> annotations;
    protected final AnnotationUsageType type;
    private int hash;

    AnnotationUsage(Set<String> annotations, AnnotationUsageType type) {
        this.annotations = annotations;
        this.type = type;
    }

    public AnnotationUsageType getType() {
        return this.type;
    }

    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public ExtendsAnnotatedClass asExtendsAnnotatedClass() {
        if (this.type != AnnotationUsageType.EXTENDS_CLASS) {
            throw new IllegalStateException();
        }
        return (ExtendsAnnotatedClass)this;
    }

    public ImplementsAnnotatedInterface asImplementsAnnotatedInterface() {
        if (this.type != AnnotationUsageType.IMPLEMENTS_INTERFACE) {
            throw new IllegalStateException();
        }
        return (ImplementsAnnotatedInterface)this;
    }

    public AnnotatedMethodReference asAnnotatedMethodReference() {
        if (this.type != AnnotationUsageType.METHOD_REFERENCE) {
            throw new IllegalStateException();
        }
        return (AnnotatedMethodReference)this;
    }

    public AnnotatedFieldReference asAnnotatedFieldReference() {
        if (this.type != AnnotationUsageType.FIELD_REFERENCE) {
            throw new IllegalStateException();
        }
        return (AnnotatedFieldReference)this;
    }

    public AnnotatedClassUsage asAnnotatedClassUsage() {
        if (this.type != AnnotationUsageType.CLASS_USAGE) {
            throw new IllegalStateException();
        }
        return (AnnotatedClassUsage)this;
    }

    public AnnotatedAnnotationUsage asAnnotatedAnnotationUsage() {
        if (this.type != AnnotationUsageType.ANNOTATED_ANNOTATION_USAGE) {
            throw new IllegalStateException();
        }
        return (AnnotatedAnnotationUsage)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationUsage usage = (AnnotationUsage)o;
        return Objects.equals(this.annotations, usage.annotations) && this.type == usage.type;
    }

    public final int hashCode() {
        int h = this.hash;
        if (this.hash == 0) {
            this.hash = h = this.calculateHash();
        }
        return h;
    }

    protected int calculateHash() {
        return Objects.hash(new Object[]{this.annotations, this.type});
    }

    protected abstract AnnotationUsage convertToDotFormat();
}

