/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.ArrayList;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BetweenExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.ExprVisitor;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PredicateOptimisations;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;

public final class BooleanFilterNormalizer {
    private final ExprVisitor simplifierVisitor = new ExprVisitor(){

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            return (BooleanExpr)notExpr.getChild().acceptVisitor(BooleanFilterNormalizer.this.deMorganVisitor);
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(orExpr.getChildren().size());
            for (BooleanExpr child : orExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (!((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.TRUE;
                }
                if (child instanceof OrExpr) {
                    children.addAll(((OrExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            PredicateOptimisations.optimizePredicates(children, false);
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new OrExpr(children);
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(andExpr.getChildren().size());
            for (BooleanExpr child : andExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.FALSE;
                }
                if (child instanceof AndExpr) {
                    children.addAll(((AndExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            PredicateOptimisations.optimizePredicates(children, true);
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new AndExpr(children);
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            ValueExpr leftChild = comparisonExpr.getLeftChild();
            leftChild = (ValueExpr)leftChild.acceptVisitor(this);
            ValueExpr rightChild = comparisonExpr.getRightChild();
            rightChild = (ValueExpr)rightChild.acceptVisitor(this);
            ComparisonExpr.Type comparisonType = comparisonExpr.getComparisonType();
            if (leftChild instanceof ConstantValueExpr) {
                if (rightChild instanceof ConstantValueExpr) {
                    ConstantValueExpr leftConstant = (ConstantValueExpr)leftChild;
                    ConstantValueExpr rightConstant = (ConstantValueExpr)rightChild;
                    Comparable leftValue = leftConstant.getConstantValue();
                    Comparable rightValue = rightConstant.getConstantValue();
                    int compRes = leftValue.compareTo(rightValue);
                    switch (comparisonType) {
                        case LESS: {
                            return ConstantBooleanExpr.forBoolean(compRes < 0);
                        }
                        case LESS_OR_EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes <= 0);
                        }
                        case EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes == 0);
                        }
                        case NOT_EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes != 0);
                        }
                        case GREATER_OR_EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes >= 0);
                        }
                        case GREATER: {
                            return ConstantBooleanExpr.forBoolean(compRes > 0);
                        }
                    }
                    throw new IllegalStateException("Unexpected comparison type: " + String.valueOf((Object)comparisonType));
                }
                ValueExpr temp = rightChild;
                rightChild = leftChild;
                leftChild = temp;
                comparisonType = comparisonType.reverse();
            }
            return new ComparisonExpr(leftChild, rightChild, comparisonType);
        }

        @Override
        public BooleanExpr visit(BetweenExpr betweenExpr) {
            return new AndExpr(new ComparisonExpr(betweenExpr.getLeftChild(), betweenExpr.getFromChild(), ComparisonExpr.Type.GREATER_OR_EQUAL), new ComparisonExpr(betweenExpr.getLeftChild(), betweenExpr.getToChild(), ComparisonExpr.Type.LESS_OR_EQUAL));
        }
    };
    private final ExprVisitor deMorganVisitor = new ExprVisitor(){

        @Override
        public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
            return constantBooleanExpr.negate();
        }

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            return (BooleanExpr)notExpr.getChild().acceptVisitor(BooleanFilterNormalizer.this.simplifierVisitor);
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(orExpr.getChildren().size());
            for (BooleanExpr child : orExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.FALSE;
                }
                if (child instanceof AndExpr) {
                    children.addAll(((AndExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new AndExpr(children);
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(andExpr.getChildren().size());
            for (BooleanExpr child : andExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (!((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.TRUE;
                }
                if (child instanceof OrExpr) {
                    children.addAll(((OrExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new OrExpr(children);
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            BooleanExpr booleanExpr = (BooleanExpr)comparisonExpr.acceptVisitor(BooleanFilterNormalizer.this.simplifierVisitor);
            if (booleanExpr instanceof ConstantBooleanExpr) {
                return ((ConstantBooleanExpr)booleanExpr).negate();
            }
            if (booleanExpr instanceof NotExpr) {
                return ((NotExpr)booleanExpr).getChild();
            }
            if (booleanExpr instanceof ComparisonExpr) {
                ComparisonExpr c = (ComparisonExpr)booleanExpr;
                return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), c.getComparisonType().negate());
            }
            return new NotExpr(booleanExpr);
        }

        @Override
        public BooleanExpr visit(BetweenExpr betweenExpr) {
            return new OrExpr(new ComparisonExpr(betweenExpr.getLeftChild(), betweenExpr.getFromChild(), ComparisonExpr.Type.LESS), new ComparisonExpr(betweenExpr.getLeftChild(), betweenExpr.getToChild(), ComparisonExpr.Type.GREATER));
        }

        @Override
        public BooleanExpr visit(IsNullExpr isNullExpr) {
            return new NotExpr(isNullExpr);
        }

        @Override
        public BooleanExpr visit(LikeExpr likeExpr) {
            return new NotExpr(likeExpr);
        }
    };

    public BooleanExpr normalize(BooleanExpr booleanExpr) {
        return booleanExpr == null ? null : (BooleanExpr)booleanExpr.acceptVisitor(this.simplifierVisitor);
    }
}

