/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.server.deployment.scanner.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class DeploymentScannerParser_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    DeploymentScannerParser_1_0() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode scanners = context.getModelNode();
        for (Property list : scanners.asPropertyList()) {
            ModelNode node = list.getValue();
            for (Property scanner : node.asPropertyList()) {
                writer.writeEmptyElement("deployment-scanner");
                writer.writeAttribute("name", scanner.getName());
                ModelNode configuration = scanner.getValue();
                if (configuration.hasDefined("path")) {
                    writer.writeAttribute("path", configuration.get("path").asString());
                }
                if (configuration.hasDefined("scan-enabled")) {
                    writer.writeAttribute("scan-enabled", configuration.get("scan-enabled").asString());
                }
                if (configuration.hasDefined("scan-interval")) {
                    writer.writeAttribute("scan-interval", configuration.get("scan-interval").asString());
                }
                if (configuration.hasDefined("relative-to")) {
                    writer.writeAttribute("relative-to", configuration.get("relative-to").asString());
                }
                if (configuration.hasDefined("auto-deploy-zipped") && !configuration.get("auto-deploy-zipped").asBoolean()) {
                    writer.writeAttribute("auto-deploy-zipped", Boolean.FALSE.toString());
                }
                if (configuration.hasDefined("auto-deploy-exploded") && configuration.get("auto-deploy-exploded").asBoolean()) {
                    writer.writeAttribute("auto-deploy-exploded", Boolean.TRUE.toString());
                }
                if (!configuration.hasDefined("deployment-timeout")) continue;
                writer.writeAttribute("deployment-timeout", configuration.get("deployment-timeout").asString());
            }
            writer.writeEndElement();
        }
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "deployment-scanner");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DEPLOYMENT_SCANNER_1_0: {
                    String element;
                    switch (element = reader.getLocalName()) {
                        case "deployment-scanner": {
                            this.parseScanner(reader, address, list);
                            continue block9;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseScanner(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        Boolean enabled = null;
        Integer interval = null;
        String path = null;
        String name = "default";
        String relativeTo = null;
        Boolean autoDeployZipped = null;
        Boolean autoDeployExploded = null;
        Long deploymentTimeout = null;
        int attrCount = reader.getAttributeCount();
        block20: for (int i = 0; i < attrCount; ++i) {
            String attribute;
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "path": {
                    path = value;
                    continue block20;
                }
                case "name": {
                    name = value;
                    continue block20;
                }
                case "relative-to": {
                    relativeTo = value;
                    continue block20;
                }
                case "scan-interval": {
                    interval = Integer.parseInt(value);
                    continue block20;
                }
                case "scan-enabled": {
                    enabled = Boolean.parseBoolean(value);
                    continue block20;
                }
                case "auto-deploy-zipped": {
                    autoDeployZipped = Boolean.parseBoolean(value);
                    continue block20;
                }
                case "auto-deploy-exploded": {
                    autoDeployExploded = Boolean.parseBoolean(value);
                    continue block20;
                }
                case "deployment-timeout": {
                    deploymentTimeout = Long.parseLong(value);
                    continue block20;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("path"));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address).add("scanner", name);
        operation.get("path").set(path);
        if (interval != null) {
            operation.get("scan-interval").set(interval.intValue());
        }
        if (autoDeployZipped != null) {
            operation.get("auto-deploy-zipped").set(autoDeployZipped.booleanValue());
        }
        if (autoDeployExploded != null) {
            operation.get("auto-deploy-exploded").set(autoDeployExploded.booleanValue());
        }
        if (enabled != null) {
            operation.get("scan-enabled").set(enabled.booleanValue());
        }
        if (relativeTo != null) {
            operation.get("relative-to").set(relativeTo);
        }
        if (deploymentTimeout != null) {
            operation.get("deployment-timeout").set(deploymentTimeout.longValue());
        }
        list.add(operation);
    }
}

