/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.SimpleResourceDescriptorConfigurator;
import org.jboss.as.clustering.jgroups.auth.BinaryAuthToken;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.common.function.Functions;

public class DigestAuthTokenResourceDefinition
extends AuthTokenResourceDefinition<BinaryAuthToken> {
    static final PathElement PATH = DigestAuthTokenResourceDefinition.pathElement("digest");

    DigestAuthTokenResourceDefinition() {
        super(PATH, (UnaryOperator<ResourceDescriptor>)new SimpleResourceDescriptorConfigurator(Attribute.class));
    }

    public Map.Entry<Function<String, BinaryAuthToken>, Consumer<RequirementServiceBuilder<?>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final String algorithm = Attribute.ALGORITHM.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return Map.entry(new Function<String, BinaryAuthToken>(){

            @Override
            public BinaryAuthToken apply(String sharedSecret) {
                try {
                    MessageDigest digest = MessageDigest.getInstance(algorithm);
                    return new BinaryAuthToken(digest.digest(sharedSecret.getBytes(StandardCharsets.UTF_8)));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }, Functions.discardingConsumer());
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        ALGORITHM("algorithm", ModelType.STRING, new ModelNode("SHA-256"));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setDefaultValue(defaultValue)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

