/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jboss.as.clustering.jgroups.ForkChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jgroups.JChannel;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ForkStackConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class ForkChannelFactoryServiceConfigurator
implements ResourceServiceConfigurator {
    private final RuntimeCapability<Void> capability;
    private final UnaryOperator<PathAddress> channelAddressFunction;

    public ForkChannelFactoryServiceConfigurator(RuntimeCapability<Void> capability, UnaryOperator<PathAddress> channelAddressFunction) {
        this.capability = capability;
        this.channelAddressFunction = channelAddressFunction;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String forkName = context.getCurrentAddressValue();
        PathAddress forkAddress = context.getCurrentAddress();
        PathAddress channelAddress = (PathAddress)this.channelAddressFunction.apply(forkAddress);
        String channelName = channelAddress.getLastElement().getValue();
        PlaceholderResource resource = forkAddress != channelAddress ? context.readResourceFromRoot(forkAddress, false) : PlaceholderResource.INSTANCE;
        Set entries = resource.getChildren(ProtocolResourceDefinition.WILDCARD_PATH.getKey());
        final ArrayList<ServiceDependency> protocols = new ArrayList<ServiceDependency>(entries.size());
        for (Resource.ResourceEntry entry : entries) {
            protocols.add(ServiceDependency.on((BinaryServiceDescriptor)ProtocolConfiguration.SERVICE_DESCRIPTOR, (String)forkName, (String)entry.getName()));
        }
        final ServiceDependency channel = ServiceDependency.on(ChannelResourceDefinition.CHANNEL, (String)channelName);
        final ServiceDependency module = ServiceDependency.on(ChannelResourceDefinition.CHANNEL_MODULE, (String)channelName);
        final ServiceDependency source = ServiceDependency.on(ChannelResourceDefinition.CHANNEL_SOURCE, (String)channelName);
        final ForkStackConfiguration configuration = new ForkStackConfiguration(){

            public JChannel getChannel() {
                return (JChannel)channel.get();
            }

            public ChannelFactory getChannelFactory() {
                return (ChannelFactory)source.get();
            }

            public Module getModule() {
                return (Module)module.get();
            }

            public List<ProtocolConfiguration<? extends Protocol>> getProtocols() {
                return !protocols.isEmpty() ? protocols.stream().map(Supplier::get).collect(Collectors.toList()) : List.of();
            }
        };
        Supplier<ChannelFactory> channelFactory = new Supplier<ChannelFactory>(){

            @Override
            public ChannelFactory get() {
                return new ForkChannelFactory(configuration);
            }
        };
        Consumer<ChannelFactory> stop = new Consumer<ChannelFactory>(){

            @Override
            public void accept(ChannelFactory factory) {
                ProtocolStack stack = ((JChannel)channel.get()).getProtocolStack();
                FORK fork = (FORK)stack.findProtocol(FORK.class);
                fork.remove(forkName);
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(this.capability, (Supplier)channelFactory).onStop((Consumer)stop)).requires(List.of(channel, source, module))).requires(protocols)).asPassive()).build();
    }
}

