/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public class SortedMechanismSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final Comparator<String> mechanismNameComparator;
    private final SaslMechanismSelector saslMechanismSelector;

    public SortedMechanismSaslServerFactory(SaslServerFactory delegate, Comparator<String> mechanismNameComparator) {
        super(delegate);
        this.mechanismNameComparator = Assert.checkNotNullParam("mechanismComparator", mechanismNameComparator);
        this.saslMechanismSelector = null;
    }

    public SortedMechanismSaslServerFactory(SaslServerFactory delegate, String ... mechanismNames) {
        super(delegate);
        Assert.checkNotNullParam("mechanismNames", mechanismNames);
        this.saslMechanismSelector = SaslMechanismSelector.NONE.addMechanisms(mechanismNames);
        this.mechanismNameComparator = null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        String[] mechanismNames = super.getMechanismNames(props);
        if (this.mechanismNameComparator != null) {
            Arrays.sort(mechanismNames, this.mechanismNameComparator);
        } else if (this.saslMechanismSelector != null) {
            List<String> mechanismNamesList = new ArrayList<String>(Arrays.asList(mechanismNames));
            mechanismNamesList = this.saslMechanismSelector.apply(mechanismNamesList, null);
            mechanismNames = mechanismNamesList.toArray(new String[mechanismNamesList.size()]);
        }
        return mechanismNames;
    }
}

