/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.infinispan.configuration.global.TransportConfiguration;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

public abstract class TransportResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator {
    static final PathElement WILDCARD_PATH = TransportResourceDefinition.pathElement("*");
    static final UnaryServiceDescriptor<TransportConfiguration> SERVICE_DESCRIPTOR = UnaryServiceDescriptor.of((String)(InfinispanServiceDescriptor.CACHE_CONTAINER_CONFIGURATION.getName() + "." + WILDCARD_PATH.getKey()), TransportConfiguration.class);
    static final RuntimeCapability<Void> CAPABILITY = TransportResourceDefinition.createRuntimeCapability(SERVICE_DESCRIPTOR);
    private final UnaryOperator<ResourceDescriptor> configurator;

    static PathElement pathElement(String value) {
        return PathElement.pathElement((String)"transport", (String)value);
    }

    private static RuntimeCapability<Void> createRuntimeCapability(UnaryServiceDescriptor<?> descriptor) {
        return RuntimeCapability.Builder.of(descriptor).setAllowMultipleRegistrations(true).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();
    }

    TransportResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator) {
        super(path, (ResourceDescriptionResolver)InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(path));
        this.configurator = configurator;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        RuntimeCapability commandDispatcherFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).setAllowMultipleRegistrations(true).build();
        RuntimeCapability group = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.GROUP).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).setAllowMultipleRegistrations(true).build();
        ResourceDescriptor descriptor = ((ResourceDescriptor)this.configurator.apply(new ResourceDescriptor(this.getResourceDescriptionResolver()))).addCapabilities(List.of(CAPABILITY, commandDispatcherFactory, group));
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register(registration);
        return registration;
    }
}

