/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.logging;

import jakarta.xml.ws.WebServiceException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.config.DisabledOperationException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

@MessageLogger(projectCode="WFLYWS", length=4)
public interface WSLogger
extends BasicLogger {
    public static final WSLogger ROOT_LOGGER = (WSLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), WSLogger.class, (String)"org.jboss.as.webservices");
    public static final String WS_SPEC_REF_5_3_2_4_2 = ". See section 5.3.2.4.2 of \"Jakarta Enterprise Web Services 2.0\".";

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Cannot load WS deployment aspects from %s")
    public void cannotLoadDeploymentAspectsDefinitionFile(String var1);

    public RuntimeException cannotLoadDeploymentAspectsDefinitionFile(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Activating WebServices Extension")
    public void activatingWebservicesExtension();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Starting %s")
    public void starting(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=4, value="Stopping %s")
    public void stopping(Object var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=5, value="Error while creating configuration service")
    public void configServiceCreationFailed();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Error while destroying configuration service")
    public void configServiceDestroyFailed();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Could not read WSDL from: %s")
    public void cannotReadWsdl(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8, value="[JAXWS 2.2 spec, section 7.7] The @WebService and @WebServiceProvider annotations are mutually exclusive - %s won't be considered as a webservice endpoint, since it doesn't meet that requirement")
    public void mutuallyExclusiveAnnotations(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=9, value="WebService endpoint class cannot be final - %s won't be considered as a webservice endpoint")
    public void finalEndpointClassDetected(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Ignoring <port-component-ref> without <service-endpoint-interface> and <port-qname>: %s")
    public void ignoringPortComponentRef(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11, value="Cannot register record processor in JMX server")
    public void cannotRegisterRecordProcessor();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12, value="Cannot unregister record processor from JMX server")
    public void cannotUnregisterRecordProcessor();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=13, value="MBeanServer not available, skipping registration/unregistration of %s")
    public void mBeanServerNotAvailable(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14, value="Multiple Enterprise Beans 3 endpoints in the same deployment with different declared security roles; be aware this might be a security risk if you're not controlling allowed roles (@RolesAllowed) on each ws endpoint method.")
    public void multipleEndpointsWithDifferentDeclaredSecurityRoles();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15, value="Cannot register endpoint: %s in JMX server")
    public void cannotRegisterEndpoint(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16, value="Cannot unregister endpoint: %s from JMX server")
    public void cannotUnregisterEndpoint(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17, value="Invalid handler chain file: %s")
    public void invalidHandlerChainFile(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18, value="Web service method %s must not be static or final. See section 5.3.2.4.2 of \"Jakarta Enterprise Web Services 2.0\".")
    public void webMethodMustNotBeStaticOrFinal(Method var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=19, value="Web service method %s must be public. See section 5.3.2.4.2 of \"Jakarta Enterprise Web Services 2.0\".")
    public void webMethodMustBePublic(Method var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=20, value="Web service implementation class %s does not contain method %s")
    public void webServiceMethodNotFound(Class<?> var1, Method var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=21, value="Web service implementation class %s does not contain an accessible method %s")
    public void accessibleWebServiceMethodNotFound(Class<?> var1, Method var2, @Cause SecurityException var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22, value="Web service implementation class %s may not declare a finalize() method. See section 5.3.2.4.2 of \"Jakarta Enterprise Web Services 2.0\".")
    public void finalizeMethodNotAllowed(Class<?> var1);

    @Message(id=23, value="Null endpoint name")
    public NullPointerException nullEndpointName();

    @Message(id=24, value="Null endpoint class")
    public NullPointerException nullEndpointClass();

    @Message(id=25, value="Cannot resolve module or classloader for deployment %s")
    public IllegalStateException classLoaderResolutionFailed(Object var1);

    @Message(id=26, value="Handler chain config file %s not found in %s")
    public WebServiceException missingHandlerChainConfigFile(String var1, ResourceRoot var2);

    @Message(id=27, value="Unexpected element: %s")
    public IllegalStateException unexpectedElement(String var1);

    @Message(id=28, value="Unexpected end tag: %s")
    public IllegalStateException unexpectedEndTag(String var1);

    @Message(id=29, value="Reached end of xml document unexpectedly")
    public IllegalStateException unexpectedEndOfDocument();

    @Message(id=30, value="Could not find class attribute for deployment aspect")
    public IllegalStateException missingDeploymentAspectClassAttribute();

    @Message(id=31, value="Could not create a deployment aspect of class: %s")
    public IllegalStateException cannotInstantiateDeploymentAspect(@Cause Throwable var1, String var2);

    @Message(id=32, value="Could not find property name attribute for deployment aspect: %s")
    public IllegalStateException missingPropertyNameAttribute(DeploymentAspect var1);

    @Message(id=33, value="Could not find property class attribute for deployment aspect: %s")
    public IllegalStateException missingPropertyClassAttribute(DeploymentAspect var1);

    @Message(id=34, value="Unsupported property class: %s")
    public IllegalArgumentException unsupportedPropertyClass(String var1);

    @Message(id=35, value="Could not create list of type: %s")
    public IllegalStateException cannotInstantiateList(@Cause Throwable var1, String var2);

    @Message(id=36, value="Could not create map of type: %s")
    public IllegalStateException cannotInstantiateMap(@Cause Throwable var1, String var2);

    @Message(id=37, value="No metrics available")
    public String noMetricsAvailable();

    @Message(id=38, value="Cannot find component view: %s")
    public IllegalStateException cannotFindComponentView(ServiceName var1);

    @Message(id=39, value="Child '%s' not found for VirtualFile: %s")
    public IOException missingChild(String var1, VirtualFile var2);

    @Message(id=40, value="Failed to create context")
    public Exception createContextPhaseFailed(@Cause Throwable var1);

    @Message(id=41, value="Failed to start context")
    public Exception startContextPhaseFailed(@Cause Throwable var1);

    @Message(id=42, value="Failed to stop context")
    public Exception stopContextPhaseFailed(@Cause Throwable var1);

    @Message(id=43, value="Failed to destroy context")
    public Exception destroyContextPhaseFailed(@Cause Throwable var1);

    @Message(id=44, value="Cannot create servlet delegate: %s")
    public IllegalStateException cannotInstantiateServletDelegate(@Cause Throwable var1, String var2);

    @Message(id=45, value="Cannot obtain deployment property: %s")
    public IllegalStateException missingDeploymentProperty(String var1);

    @Message(id=46, value="Multiple security domains not supported. First domain: '%s' second domain: '%s'")
    public IllegalStateException multipleSecurityDomainsDetected(String var1, String var2);

    @Message(id=47, value="Web Service endpoint %s with URL pattern %s is already registered. Web service endpoint %s is requesting the same URL pattern.")
    public IllegalArgumentException sameUrlPatternRequested(String var1, String var2, String var3);

    @Message(id=48, value="@WebServiceRef injection target is invalid.  Only setter methods are allowed: %s")
    public DeploymentUnitProcessingException invalidServiceRefSetterMethodName(Object var1);

    @Message(id=49, value="@WebServiceRef attribute 'name' is required for class level annotations.")
    public DeploymentUnitProcessingException requiredServiceRefName();

    @Message(id=50, value="@WebServiceRef attribute 'type' is required for class level annotations.")
    public DeploymentUnitProcessingException requiredServiceRefType();

    @Message(id=51, value="Config %s doesn't exist")
    public OperationFailedException missingConfig(String var1);

    @Message(id=52, value="Unsupported handler chain type: %s. Supported types are either %s or %s")
    public StartException wrongHandlerChainType(String var1, String var2, String var3);

    @Message(id=54, value="Config %s: %s handler chain with id %s doesn't exist")
    public OperationFailedException missingHandlerChain(String var1, String var2, String var3);

    @Message(id=57, value="Unable to get URL for: %s")
    public DeploymentUnitProcessingException cannotGetURLForDescriptor(@Cause Throwable var1, String var2);

    @Message(id=58, value="Jakarta XML RPC not supported")
    public DeploymentUnitProcessingException jaxRpcNotSupported();

    @Message(id=59, value="%s library (%s) detected in ws endpoint deployment; either provide a proper deployment replacing embedded libraries with container module dependencies or disable the webservices subsystem for the current deployment adding a proper jboss-deployment-structure.xml descriptor to it. The former approach is recommended, as the latter approach causes most of the webservices Jakarta EE and any JBossWS specific functionality to be disabled.")
    public DeploymentUnitProcessingException invalidLibraryInDeployment(String var1, String var2);

    @Message(id=60, value="Web service endpoint class %s not found")
    public DeploymentUnitProcessingException endpointClassNotFound(String var1);

    @Message(id=61, value="The endpointInterface %s declared in the @WebService annotation on web service implementation bean %s was not found.")
    public DeploymentUnitProcessingException declaredEndpointInterfaceClassNotFound(String var1, Class<?> var2);

    @Message(id=62, value="Class verification of Java Web Service implementation class %s failed.")
    public DeploymentUnitProcessingException jwsWebServiceClassVerificationFailed(Class<?> var1);

    @Message(id=63, value="Could not update WS server configuration because of pending former model update(s) requiring reload.")
    public DisabledOperationException couldNotUpdateServerConfigBecauseOfReloadRequired();

    @Message(id=64, value="Could not update WS server configuration because of existing WS deployment on the server.")
    public DisabledOperationException couldNotUpdateServerConfigBecauseOfExistingWSDeployment();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=65, value="Annotation '@%s' found on class '%s'. Perhaps you forgot to add a '%s' module dependency to your deployment?")
    public void missingModuleDependency(String var1, String var2, String var3);

    @Message(id=66, value="Servlet class %s declared in web.xml; either provide a proper deployment relying on JBossWS or disable the webservices subsystem for the current deployment adding a proper jboss-deployment-structure.xml descriptor to it. The former approach is recommended, as the latter approach causes most of the webservices Jakarta EE and any JBossWS specific functionality to be disabled.")
    public WSFException invalidWSServlet(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=67, value="Could not activate the webservices subsystem.")
    public void couldNotActivateSubsystem(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=70, value="Authorization failed for user: %s")
    public void failedAuthorization(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=71, value="Failed to authenticate username %s:, incorrect username/password")
    public void failedAuthentication(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=72, value="Error occured when authenticate username %s. Exception message: %s")
    public void failedAuthenticationWithException(@Cause Throwable var1, String var2, String var3);

    @Message(id=73, value="The target endpoint %s is undeploying or stopped")
    public IllegalStateException endpointAlreadyStopped(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=68, value="A potentially problematic %s library (%s) detected in ws endpoint deployment; Check if this library can be replaced with container module")
    public void warningLibraryInDeployment(String var1, String var2);

    @Message(id=74, value="The deployment is configured to use legacy security which is no longer supported.")
    public IllegalStateException legacySecurityUnsupported();

    @Message(id=75, value="only string password accepted")
    public IllegalArgumentException onlyStringPasswordAccepted();
}

