/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class DefaultBinaryServiceInstallerProvider<T>
implements BiFunction<CapabilityServiceSupport, BinaryServiceConfiguration, Iterable<ServiceInstaller>> {
    private final BinaryServiceDescriptor<T> descriptor;
    private final Function<BinaryServiceConfiguration, JndiName> jndiNameFactory;

    protected DefaultBinaryServiceInstallerProvider(BinaryServiceDescriptor<T> descriptor, Function<BinaryServiceConfiguration, JndiName> jndiNameFactory) {
        this.descriptor = descriptor;
        this.jndiNameFactory = jndiNameFactory;
    }

    @Override
    public Iterable<ServiceInstaller> apply(CapabilityServiceSupport support, BinaryServiceConfiguration configuration) {
        ServiceName name = configuration.withChildName(null).resolveServiceName(this.descriptor);
        ArrayList<ServiceInstaller> installers = new ArrayList<ServiceInstaller>(2);
        installers.add((ServiceInstaller)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)configuration.getServiceDependency(this.descriptor)).provides(name)).build());
        if (!configuration.getChildName().equals("default")) {
            ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)this.jndiNameFactory.apply(configuration.withChildName("default")).getAbsoluteName());
            installers.add((ServiceInstaller)new BinderServiceInstaller(binding, name));
        }
        return installers;
    }
}

