/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.parsing;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.domain.management.parsing.ManagementXmlDelegate;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.IntVersion;
import org.jboss.staxmapper.XMLExtendedStreamReader;

final class ManagementXml_Legacy
implements ManagementXml {
    private final IntVersion version;
    private final String namespace;
    private final ManagementXmlDelegate delegate;
    private final boolean domainConfiguration;

    ManagementXml_Legacy(IntVersion version, String namespace, ManagementXmlDelegate delegate, boolean domainConfiguration) {
        this.version = version;
        this.namespace = namespace;
        this.delegate = delegate;
        this.domainConfiguration = domainConfiguration;
    }

    @Override
    public void parseManagement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        IntVersion cutOff = new IntVersion(new int[]{1, 5});
        if (this.version.compareTo(cutOff) < 0) {
            this.parseManagement_1_0(reader, address, list, requireNativeInterface);
        } else {
            this.parseManagement_1_5(reader, address, list, requireNativeInterface);
        }
    }

    private void parseManagement_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (this.domainConfiguration) {
                if (element == Element.ACCESS_CONTROL) {
                    if (this.delegate.parseAccessControl(reader, managementAddress, list)) continue;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case SECURITY_REALMS: {
                    throw DomainManagementLogger.ROOT_LOGGER.securityRealmsUnsupported();
                }
                case OUTBOUND_CONNECTIONS: {
                    throw DomainManagementLogger.ROOT_LOGGER.outboundConnectionsUnsupported();
                }
                case MANAGEMENT_INTERFACES: {
                    if (++managementInterfacesCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseManagementInterfaces(reader, managementAddress, list)) continue block5;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireNativeInterface && managementInterfacesCount < 1) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT_INTERFACES));
        }
    }

    private void parseManagement_1_5(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALMS: {
                    throw DomainManagementLogger.ROOT_LOGGER.securityRealmsUnsupported();
                }
                case OUTBOUND_CONNECTIONS: {
                    throw DomainManagementLogger.ROOT_LOGGER.outboundConnectionsUnsupported();
                }
                case MANAGEMENT_INTERFACES: {
                    if (++managementInterfacesCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseManagementInterfaces(reader, managementAddress, list)) continue block7;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case AUDIT_LOG: {
                    if (this.delegate.parseAuditLog(reader, managementAddress, list)) continue block7;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case ACCESS_CONTROL: {
                    if (this.delegate.parseAccessControl(reader, managementAddress, list)) continue block7;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireNativeInterface && managementInterfacesCount < 1) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT_INTERFACES));
        }
    }
}

