/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import org.hibernate.engine.jdbc.cursor.spi.RefCursorSupport;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.exec.spi.JdbcCallRefCursorExtractor;

public class JdbcCallRefCursorExtractorImpl
implements JdbcCallRefCursorExtractor {
    private final int jdbcParameterPosition;

    public JdbcCallRefCursorExtractorImpl(int jdbcParameterPosition) {
        this.jdbcParameterPosition = jdbcParameterPosition;
    }

    @Override
    public ResultSet extractResultSet(CallableStatement callableStatement, SharedSessionContractImplementor session) {
        boolean supportsNamedParameters = session.getJdbcServices().getJdbcEnvironment().getExtractedDatabaseMetaData().supportsNamedParameters();
        return session.getFactory().getServiceRegistry().requireService(RefCursorSupport.class).getResultSet(callableStatement, this.jdbcParameterPosition);
    }
}

