/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AckManagerProvider;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SNFPagedMirrorTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ActiveMQServer server1;
    ActiveMQServer server2;
    private static final String SNF_NAME = "$ACTIVEMQ_ARTEMIS_MIRROR_other";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server1 = this.createServer(true, this.createDefaultConfig(0, true), 1024, -1L, -1, -1);
        this.server1.getConfiguration().addAddressSetting(SNF_NAME, new AddressSettings().setMaxSizeBytes(-1L).setMaxSizeMessages(-1L));
        this.server1.getConfiguration().getAcceptorConfigurations().clear();
        this.server1.getConfiguration().addAcceptorConfiguration("server", "tcp://localhost:61616");
        AMQPBrokerConnectConfiguration brokerConnectConfiguration = new AMQPBrokerConnectConfiguration("other", "tcp://localhost:61617").setReconnectAttempts(-1).setRetryInterval(1000);
        brokerConnectConfiguration.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server1.getConfiguration().addAMQPConnection(brokerConnectConfiguration);
        this.server1.getConfiguration().addAddressSetting(SNF_NAME, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL));
        this.server2 = this.createServer(true, this.createDefaultConfig(1, true), 1024, -1L, -1, -1);
        this.server2.getConfiguration().addAddressSetting(SNF_NAME, new AddressSettings().setMaxSizeBytes(-1L).setMaxSizeMessages(-1L));
        this.server2.getConfiguration().getAcceptorConfigurations().clear();
        this.server2.getConfiguration().addAcceptorConfiguration("server", "tcp://localhost:61617");
        brokerConnectConfiguration = new AMQPBrokerConnectConfiguration("other", "tcp://localhost:61616").setReconnectAttempts(-1).setRetryInterval(1000);
        brokerConnectConfiguration.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server2.getConfiguration().addAddressSetting(SNF_NAME, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL));
        this.server2.getConfiguration().addAMQPConnection(brokerConnectConfiguration);
        this.server1.start();
        this.server2.start();
    }

    @Test
    public void testPagedEverything() throws Throwable {
        this.testSNFPaged("CORE", true, true, false, 1024);
    }

    @Test
    public void testPageQueueOnly() throws Throwable {
        this.testSNFPaged("CORE", false, true, false, 1024);
    }

    @Test
    public void testPageSNF() throws Throwable {
        this.testSNFPaged("CORE", true, false, false, 1024);
    }

    @Test
    public void testNothingPaged() throws Throwable {
        this.testSNFPaged("CORE", false, true, false, 1024);
    }

    @Test
    public void testPageTargetQueue() throws Throwable {
        this.testSNFPaged("CORE", false, false, true, 1024);
    }

    @Test
    public void testPageTargetQueueAMQPLarge() throws Throwable {
        this.testSNFPaged("AMQP", false, false, true, 256000);
    }

    @Test
    public void testTargetPaged() throws Throwable {
        this.server1.setIdentity("server1");
        this.server2.setIdentity("server2");
        String QUEUE_NAME = "q" + RandomUtil.randomString();
        String server1URI = "tcp://localhost:61616";
        String server2URI = "tcp://localhost:61617";
        Wait.waitFor(() -> this.server1.locateQueue(SNF_NAME) != null);
        Wait.waitFor(() -> this.server2.locateQueue(SNF_NAME) != null);
        Queue snf1 = this.server1.locateQueue(SNF_NAME);
        Assertions.assertNotNull((Object)snf1);
        Assertions.assertEquals((int)2, (int)AckManagerProvider.getSize());
        this.server1.addAddressInfo(new AddressInfo(QUEUE_NAME).addRoutingType(RoutingType.ANYCAST));
        Queue queueOnServer1 = this.server1.createQueue(QueueConfiguration.of((String)QUEUE_NAME).setAddress(QUEUE_NAME).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
        Wait.assertTrue(() -> this.server2.locateQueue(QUEUE_NAME) != null);
        Queue queueServer2 = this.server2.locateQueue(QUEUE_NAME);
        snf1.getPagingStore().startPaging();
        Wait.assertEquals((long)0L, () -> ((Queue)snf1).getMessageCount());
        queueServer2.getPagingStore().stopPaging();
        int NUMBER_OF_MESSAGES = 5000;
        ConnectionFactory factory1 = CFUtil.createConnectionFactory("CORE", server2URI);
        logger.info("Starting producer");
        try (Connection connection = factory1.createConnection();){
            Session session = connection.createSession(true, 0);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(QUEUE_NAME));
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                producer.send((Message)session.createTextMessage("hello " + i));
            }
            session.commit();
        }
        logger.info("Consumed messages");
        Wait.assertEquals((long)0L, () -> ((Queue)snf1).getMessageCount(), (long)5000L);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueServer2).getMessageCount());
    }

    public void testSNFPaged(String protocol, boolean pageSNF, boolean pageQueue, boolean pageTarget, int messageSize) throws Throwable {
        this.server1.setIdentity("server1");
        this.server2.setIdentity("server2");
        String QUEUE_NAME = "q" + RandomUtil.randomString();
        String sendURI = "tcp://localhost:61616";
        String consumerURI = "tcp://localhost:61617";
        Wait.waitFor(() -> this.server1.locateQueue(SNF_NAME) != null);
        Wait.waitFor(() -> this.server2.locateQueue(SNF_NAME) != null);
        Queue snf1 = this.server1.locateQueue(SNF_NAME);
        Assertions.assertNotNull((Object)snf1);
        logger.info("I currently have {} ACk Managers", (Object)AckManagerProvider.getSize());
        this.server1.addAddressInfo(new AddressInfo(QUEUE_NAME).addRoutingType(RoutingType.ANYCAST));
        Queue queueOnServer1 = this.server1.createQueue(QueueConfiguration.of((String)QUEUE_NAME).setAddress(QUEUE_NAME).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
        Wait.assertTrue(() -> this.server2.locateQueue(QUEUE_NAME) != null);
        Wait.assertEquals((long)0L, () -> ((Queue)snf1).getMessageCount());
        JournalStorageManager journalStorageManager = (JournalStorageManager)this.server1.getStorageManager();
        this.server2.stop();
        logger.info("I currently have {} ACk Managers", (Object)AckManagerProvider.getSize());
        File countJournalLocation = this.server1.getConfiguration().getJournalLocation();
        Assertions.assertTrue((countJournalLocation.exists() && countJournalLocation.isDirectory() ? 1 : 0) != 0);
        ConnectionFactory server1CF = CFUtil.createConnectionFactory(protocol, sendURI);
        ConnectionFactory server2CF = CFUtil.createConnectionFactory(protocol, consumerURI);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < messageSize; ++i) {
            buffer.append("*");
        }
        String bodyBuffer = buffer.toString();
        int NUMBER_OF_MESSAGES = 200;
        if (pageQueue) {
            queueOnServer1.getPagingStore().startPaging();
        }
        if (pageSNF) {
            snf1.getPagingStore().startPaging();
            Wait.assertTrue(() -> snf1.getPagingStore().isPaging(), (long)5000L, (long)100L);
        }
        try (Connection sendConnecton = server1CF.createConnection();){
            Session sendSession = sendConnecton.createSession(true, 0);
            jakarta.jms.Queue jmsQueue = sendSession.createQueue(QUEUE_NAME);
            MessageProducer producer = sendSession.createProducer((Destination)jmsQueue);
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                TextMessage message = sendSession.createTextMessage(bodyBuffer);
                message.setIntProperty("i", i);
                message.setStringProperty("inPage", "this is paged");
                producer.send((Message)message);
            }
            sendSession.commit();
        }
        if (pageQueue) {
            Assertions.assertTrue((boolean)queueOnServer1.getPagingStore().isPaging());
        } else {
            Assertions.assertFalse((boolean)queueOnServer1.getPagingStore().isPaging());
        }
        if (pageSNF) {
            Assertions.assertTrue((boolean)snf1.getPagingStore().isPaging());
        } else {
            Assertions.assertFalse((boolean)snf1.getPagingStore().isPaging());
        }
        if (pageSNF && pageQueue) {
            journalStorageManager.getMessageJournal().scheduleCompactAndBlock(60000);
            HashMap<Integer, AtomicInteger> counters = this.countJournal(this.server1.getConfiguration());
            Assertions.assertEquals((int)0, (int)this.getCounter((byte)32, counters), (String)"There are routed messages on the journal");
            Assertions.assertEquals((int)0, (int)this.getCounter((byte)31, counters), (String)"There are routed messages on the journal");
            Assertions.assertEquals((int)0, (int)this.getCounter((byte)45, counters), (String)"There are routed messages on the journal");
        }
        this.server2.start();
        Assertions.assertEquals((int)2, (int)AckManagerProvider.getSize());
        if (pageTarget) {
            Queue queue2 = this.server2.locateQueue(QUEUE_NAME);
            Assertions.assertNotNull((Object)queue2);
            queue2.getPagingStore().startPaging();
        }
        Queue snf2 = this.server2.locateQueue(SNF_NAME);
        Assertions.assertNotNull((Object)snf2);
        Wait.assertEquals((long)0L, () -> ((Queue)snf1).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)snf2).getMessageCount());
        Queue queueOnServer2 = this.server2.locateQueue(QUEUE_NAME);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount(), (long)5000L);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer2).getMessageCount(), (long)5000L);
        Assertions.assertEquals((int)0, (int)queueOnServer1.getConsumerCount());
        Assertions.assertEquals((int)0, (int)queueOnServer1.getDeliveringCount());
        try (Connection connection = server2CF.createConnection();){
            connection.start();
            Session session = connection.createSession(true, 0);
            jakarta.jms.Queue jmsQueue = session.createQueue(QUEUE_NAME);
            MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                TextMessage message = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
                System.out.println("Message " + message.getIntProperty("i"));
            }
            session.commit();
        }
        Assertions.assertEquals((int)2, (int)AckManagerProvider.getSize());
        Wait.assertEquals((long)0L, () -> ((Queue)snf2).getMessageCount(), (long)15000L);
        Wait.assertEquals((long)0L, () -> ((Queue)queueOnServer2).getMessageCount(), (long)15000L);
        Wait.assertEquals((long)0L, () -> ((Queue)queueOnServer1).getMessageCount(), (long)15000L);
        Wait.assertEquals((long)0L, () -> ((Queue)queueOnServer1).getMessageCount(), (long)15000L);
        Wait.assertEquals((int)0, () -> this.server1.getConfiguration().getLargeMessagesLocation().listFiles().length);
        Wait.assertEquals((int)0, () -> this.server2.getConfiguration().getLargeMessagesLocation().listFiles().length);
    }

    private int getCounter(byte typeRecord, HashMap<Integer, AtomicInteger> values) {
        AtomicInteger value = values.get(typeRecord);
        if (value == null) {
            return 0;
        }
        return value.get();
    }
}

