/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.paging;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AmqpPagingTest
extends AmqpClientTestSupport {
    private final Boolean durable;

    @Parameters(name="durability={0}")
    public static Collection getParams() {
        return Arrays.asList({Boolean.TRUE}, {Boolean.FALSE});
    }

    public AmqpPagingTest(Boolean durable) {
        this.durable = durable;
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        super.addConfiguration(server);
        Map addressesSettings = server.getConfiguration().getAddressSettings();
        ((AddressSettings)addressesSettings.get("#")).setMaxSizeBytes(100000L).setPageSizeBytes(10000);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testPaging() throws Exception {
        int MSG_SIZE = 1000;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            builder.append('0');
        }
        String data = builder.toString();
        int MSG_COUNT = 1000;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName(), true);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.setPresettle(true);
        receiver.flow(10);
        Assertions.assertNull((Object)receiver.receiveNoWait(), (String)"somehow the queue had messages from a previous test");
        receiver.flow(0);
        for (int i = 0; i < 1000; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setText(data);
            if (this.durable != null) {
                message.setDurable(this.durable);
            }
            sender.send(message);
        }
        sender.close();
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)1000L, () -> ((Queue)queueView).getMessageCount());
        PagingStore pagingStore = this.server.getPagingManager().getPageStore(SimpleString.of((String)this.getQueueName()));
        Assertions.assertTrue((boolean)pagingStore.isPaging());
        long pageCacheMaxSize = ((AddressSettings)this.server.getConfiguration().getAddressSettings().get("#")).getPageCacheMaxSize();
        MatcherAssert.assertThat((String)"the size of the messages or the number of messages isn't enough", (Object)pagingStore.getNumberOfPages(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(pageCacheMaxSize)));
        receiver.flow(1000);
        for (int i = 0; i < 1000; ++i) {
            AmqpMessage receive = receiver.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)receive, (String)("Not received anything after " + i + " receive"));
            Assertions.assertEquals((Object)(this.durable == null ? false : this.durable), (Object)receive.isDurable());
            receive.accept();
        }
        receiver.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSizeCalculationsForApplicationProperties() throws Exception {
        int MSG_SIZE = 1000;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            builder.append('0');
        }
        String data = builder.toString();
        boolean MSG_COUNT = true;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName(), true);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), "myData IS NOT NULL");
        receiver.setPresettle(true);
        receiver.flow(10);
        Assertions.assertNull((Object)receiver.receiveNoWait(), (String)"somehow the queue had messages from a previous test");
        receiver.flow(0);
        AmqpMessage message = new AmqpMessage();
        message.setText(data);
        message.setApplicationProperty("myData", data);
        if (this.durable != null) {
            message.setDurable(this.durable);
        }
        sender.send(message);
        PagingStore pagingStore = this.server.getPagingManager().getPageStore(SimpleString.of((String)this.getQueueName()));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> pagingStore.getAddressSize() > 3000L));
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(10L, TimeUnit.MINUTES);
        Assertions.assertNotNull((Object)receive, (String)"Not received anything after receive");
        receive.accept();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> pagingStore.getAddressSize() == 0L));
        message = new AmqpMessage();
        message.setText(data);
        message.setApplicationProperty("_AMQ_DUPL_ID", "1");
        message.setApplicationProperty("myData", data);
        if (this.durable != null) {
            message.setDurable(this.durable);
        }
        sender.send(message);
        sender.close();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> pagingStore.getAddressSize() > 3000L));
        receiver.flow(1);
        receive = receiver.receive(10L, TimeUnit.MINUTES);
        Assertions.assertNotNull((Object)receive, (String)"Not received anything after receive");
        receive.accept();
        receiver.close();
        connection.close();
    }
}

