/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.bridge;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class BridgeRoutingTest
extends ActiveMQTestBase {
    private ActiveMQServer server0;
    private ActiveMQServer server1;
    private final boolean netty;

    @Parameters(name="isNetty={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    public BridgeRoutingTest(boolean isNetty) {
        this.netty = isNetty;
    }

    protected boolean isNetty() {
        return this.netty;
    }

    private String getServer0URL() {
        return this.isNetty() ? "tcp://localhost:61616" : "vm://0";
    }

    private String getServer1URL() {
        return this.isNetty() ? "tcp://localhost:61617" : "vm://1";
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server0 = this.createServer(false, (Configuration)this.createBasicConfig());
        this.server1 = this.createServer(false, (Configuration)this.createBasicConfig());
        this.server0.getConfiguration().addAcceptorConfiguration("acceptor", this.getServer0URL());
        this.server0.getConfiguration().addConnectorConfiguration("connector", this.getServer1URL());
        this.server1.getConfiguration().addAcceptorConfiguration("acceptor", this.getServer1URL());
        this.server0.start();
        this.server1.start();
    }

    @TestTemplate
    public void testAnycastBridge() throws Exception {
        this.testBridgeInternal(RoutingType.MULTICAST, RoutingType.ANYCAST, ComponentConfigurationRoutingType.ANYCAST, 0L, 1);
    }

    @TestTemplate
    public void testAnycastBridgeNegative() throws Exception {
        this.testBridgeInternal(RoutingType.MULTICAST, RoutingType.ANYCAST, ComponentConfigurationRoutingType.PASS, 500L, 0);
    }

    @TestTemplate
    public void testMulticastBridge() throws Exception {
        this.testBridgeInternal(RoutingType.ANYCAST, RoutingType.MULTICAST, ComponentConfigurationRoutingType.MULTICAST, 0L, 1);
    }

    @TestTemplate
    public void testMulticastBridgeNegative() throws Exception {
        this.testBridgeInternal(RoutingType.ANYCAST, RoutingType.MULTICAST, ComponentConfigurationRoutingType.PASS, 500L, 0);
    }

    @TestTemplate
    public void testPassBridge() throws Exception {
        this.testBridgeInternal(RoutingType.MULTICAST, RoutingType.MULTICAST, ComponentConfigurationRoutingType.PASS, 0L, 1);
    }

    @TestTemplate
    public void testPassBridge2() throws Exception {
        this.testBridgeInternal(RoutingType.ANYCAST, RoutingType.ANYCAST, ComponentConfigurationRoutingType.PASS, 0L, 1);
    }

    @TestTemplate
    public void testPassBridgeNegative() throws Exception {
        this.testBridgeInternal(RoutingType.ANYCAST, RoutingType.MULTICAST, ComponentConfigurationRoutingType.PASS, 500L, 0);
    }

    @TestTemplate
    public void testStripBridge() throws Exception {
        this.testBridgeInternal(RoutingType.MULTICAST, RoutingType.ANYCAST, ComponentConfigurationRoutingType.STRIP, 0L, 1);
    }

    @TestTemplate
    public void testStripBridge2() throws Exception {
        this.testBridgeInternal(RoutingType.ANYCAST, RoutingType.MULTICAST, ComponentConfigurationRoutingType.STRIP, 0L, 1);
    }

    private void testBridgeInternal(RoutingType sourceRoutingType, RoutingType destinationRoutingType, ComponentConfigurationRoutingType bridgeRoutingType, long sleepTime, int destinationMessageCount) throws Exception {
        SimpleString source = SimpleString.of((String)"source");
        SimpleString destination = SimpleString.of((String)"destination");
        int concurrency = 2;
        this.server0.createQueue(QueueConfiguration.of((SimpleString)source).setRoutingType(sourceRoutingType));
        this.server1.createQueue(QueueConfiguration.of((SimpleString)destination).setRoutingType(destinationRoutingType));
        this.server0.deployBridge(new BridgeConfiguration().setRoutingType(bridgeRoutingType).setName("bridge").setForwardingAddress(destination.toString()).setQueueName(source.toString()).setConfirmationWindowSize(10).setConcurrency(concurrency).setStaticConnectors(Arrays.asList("connector")));
        try (ServerLocator locator = ActiveMQClient.createServerLocator((String)this.getServer0URL());
             ClientSessionFactory sessionFactory = locator.createSessionFactory();
             ClientSession session = sessionFactory.createSession();
             ClientProducer producer = session.createProducer(source);){
            producer.send(session.createMessage(true).setRoutingType(sourceRoutingType));
        }
        Wait.waitFor(() -> this.server0.locateQueue(source).getMessageCount() == 0L, (long)2000L, (long)100L);
        Wait.waitFor(() -> ((Bridge)this.server0.getClusterManager().getBridges().get("bridge-0")).getMetrics().getMessagesAcknowledged() == 1L, (long)2000L, (long)100L);
        Thread.sleep(sleepTime);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server1.locateQueue(destination).getMessageCount() == (long)destinationMessageCount, (long)2000L, (long)100L));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server0.locateQueue(source).getConsumerCount() == concurrency, (long)2000L, (long)100L));
    }
}

