/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.stream.Stream;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class ConsumerTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final boolean durable;
    private final boolean netty;
    private ActiveMQServer server;
    private final SimpleString QUEUE = SimpleString.of((String)"ConsumerTestQueue");
    private ServerLocator locator;

    @Override
    protected boolean waitForBindings(ActiveMQServer server, String address, boolean local, int expectedBindingCount, int expectedConsumerCount, long timeout) throws Exception {
        return super.waitForBindings(server, address, local, expectedBindingCount, expectedConsumerCount, timeout);
    }

    @Parameters(name="isNetty={0}, persistent={1}")
    public static Collection getParameters() {
        return Arrays.asList({true, true}, {false, false}, {false, true}, {true, false});
    }

    public ConsumerTest(boolean netty, boolean durable) {
        this.netty = netty;
        this.durable = durable;
    }

    protected boolean isNetty() {
        return this.netty;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(this.durable, this.isNetty());
        this.server.getConfiguration().setAddressQueueScanPeriod(10L);
        this.server.start();
        this.locator = this.createFactory(this.isNetty());
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setRoutingType(RoutingType.ANYCAST));
    }

    @TestTemplate
    public void testStressConnection() throws Exception {
        for (int i = 0; i < 10; ++i) {
            ServerLocator locatorSendx = this.createFactory(this.isNetty()).setReconnectAttempts(15);
            ClientSessionFactory factoryx = locatorSendx.createSessionFactory();
            factoryx.close();
            locatorSendx.close();
        }
    }

    @TestTemplate
    public void testSimpleSend() throws Throwable {
        this.receive(false);
    }

    @TestTemplate
    public void testSimpleSendWithCloseConsumer() throws Throwable {
        this.receive(true);
    }

    private void receive(boolean cancelOnce) throws Throwable {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, false);
        ClientProducer producer = session.createProducer(this.QUEUE);
        ClientMessage message = session.createMessage((byte)3, true, 0L, System.currentTimeMillis(), (byte)4);
        message.getBodyBuffer().writeString("hi");
        message.putStringProperty("hello", "elo");
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.commit();
        session.close();
        if (this.durable) {
            this.server.stop();
            this.server.start();
        }
        sf = this.createSessionFactory(this.locator);
        session = sf.createSession(false, true, true, false);
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        if (cancelOnce) {
            ClientConsumerInternal consumerInternal = (ClientConsumerInternal)consumer;
            Wait.waitFor(() -> consumerInternal.getBufferSize() > 0);
            consumer.close();
            consumer = session.createConsumer(this.QUEUE);
        }
        ClientMessage message2 = consumer.receive(1000L);
        Assertions.assertNotNull((Object)message2);
        logger.debug("Id::{}", (Object)message2.getMessageID());
        logger.debug("Received {}", (Object)message2);
        logger.debug("Clie:{}", (Object)ByteUtil.bytesToHex((byte[])message2.getBuffer().array(), (int)4));
        logger.debug("String::{}", (Object)message2.getReadOnlyBodyBuffer().readString());
        Assertions.assertEquals((Object)"elo", (Object)message2.getStringProperty("hello"));
        Assertions.assertEquals((Object)"hi", (Object)message2.getReadOnlyBodyBuffer().readString());
        Assertions.assertNull((Object)consumer.receiveImmediate());
        session.close();
    }

    @TestTemplate
    public void testSendReceiveAMQP() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(2, 2);
    }

    @TestTemplate
    public void testSendReceiveCore() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(1, 1);
    }

    @TestTemplate
    public void testSendAMQPReceiveCore() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testAutoCreateMulticastAddress() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        Assertions.assertNull((Object)this.server.getAddressInfo(SimpleString.of((String)"topic")));
        ConnectionFactory factorySend = this.createFactory(2);
        try (Connection connection = factorySend.createConnection();){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic("topic");
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.setDeliveryMode(2);
            TextMessage msg = session.createTextMessage("hello");
            msg.setIntProperty("mycount", 0);
            producer.send((Message)msg);
        }
        Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)"topic")));
        Assertions.assertEquals((Object)RoutingType.MULTICAST, (Object)this.server.getAddressInfo(SimpleString.of((String)"topic")).getRoutingType());
        Assertions.assertEquals((long)0L, (long)this.server.getTotalMessageCount());
    }

    @TestTemplate
    public void testAutoCreateCOnConsumerAMQP() throws Throwable {
        this.testAutoCreate(2);
    }

    @TestTemplate
    public void testAutoCreateCOnConsumerCore() throws Throwable {
        this.testAutoCreate(1);
    }

    @TestTemplate
    public void testAutoCreateCOnConsumerOpenWire() throws Throwable {
        this.testAutoCreate(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAutoCreate(int protocol) throws Throwable {
        SimpleString thisQueue = SimpleString.of((String)"ThisQueue");
        if (!this.isNetty()) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            ConnectionFactory factorySend = this.createFactory(protocol);
            try (Connection connection = factorySend.createConnection();){
                Session session = connection.createSession(false, 1);
                jakarta.jms.Queue queue = session.createQueue(thisQueue.toString());
                MessageProducer producer = session.createProducer((Destination)queue);
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                connection.start();
                producer.send((Message)session.createTextMessage("hello"));
                Assertions.assertNotNull((Object)consumer.receive(5000L));
                consumer.close();
                session.close();
            }
            Wait.waitFor(() -> this.server.getAddressInfo(thisQueue) == null, (long)1000L, (long)10L);
            Assertions.assertNull((Object)this.server.getAddressInfo(thisQueue));
            Assertions.assertEquals((long)0L, (long)this.server.getTotalMessageCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testContextOnConsumerAMQP() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        Assertions.assertNull((Object)this.server.getAddressInfo(SimpleString.of((String)"queue")));
        ConnectionFactory factory = this.createFactory(2);
        JMSContext context = factory.createContext("admin", "admin", 1);
        try {
            jakarta.jms.Queue queue = context.createQueue("queue");
            JMSConsumer consumer = context.createConsumer((Destination)queue);
            ServerConsumer serverConsumer = null;
            for (ServerSession session : this.server.getSessions()) {
                Iterator iterator = session.getServerConsumers().iterator();
                while (iterator.hasNext()) {
                    ServerConsumer sessionConsumer;
                    serverConsumer = sessionConsumer = (ServerConsumer)iterator.next();
                }
            }
            Assertions.assertTrue((boolean)(serverConsumer.getProtocolContext() instanceof ProtonServerSenderContext));
            AMQPSessionContext sessionContext = ((ProtonServerSenderContext)serverConsumer.getProtocolContext()).getSessionContext();
            consumer.close();
            ServerConsumer lambdaServerConsumer = serverConsumer;
            Wait.assertTrue(() -> lambdaServerConsumer.getProtocolContext() == null);
            Wait.assertEquals((int)0, () -> sessionContext.getSenderCount(), (long)1000L, (long)10L);
        }
        finally {
            context.stop();
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testAutoDeleteAutoCreatedAddressAndQueue() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        Assertions.assertNull((Object)this.server.getAddressInfo(SimpleString.of((String)"queue")));
        ConnectionFactory factorySend = this.createFactory(2);
        try (Connection connection = factorySend.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue("queue");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(2);
            TextMessage msg = session.createTextMessage("hello");
            msg.setIntProperty("mycount", 0);
            producer.send((Message)msg);
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Assertions.assertNotNull((Object)consumer.receive(1000L));
        }
        Wait.assertTrue(() -> this.server.getAddressInfo(SimpleString.of((String)"queue")) == null);
        Wait.assertTrue(() -> this.server.locateQueue(SimpleString.of((String)"queue")) == null);
        Wait.assertEquals((long)0L, () -> ((ActiveMQServer)this.server).getTotalMessageCount());
    }

    @TestTemplate
    public void testSendCoreReceiveAMQP() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(1, 2);
    }

    @TestTemplate
    public void testSendOpenWireReceiveAMQP() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(3, 2);
    }

    @TestTemplate
    public void testSendAMQPReceiveOpenWire() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(2, 3);
    }

    @TestTemplate
    public void testOpenWireReceiveCore() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(3, 1);
    }

    @TestTemplate
    public void testCoreReceiveOpenwire() throws Throwable {
        if (!this.isNetty()) {
            return;
        }
        this.internalSend(1, 3);
    }

    private ConnectionFactory createFactory(int protocol) {
        switch (protocol) {
            case 1: {
                org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory coreCF = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory();
                coreCF.setCompressLargeMessage(true);
                coreCF.setMinLargeMessageSize(10240);
                return coreCF;
            }
            case 2: {
                return new JmsConnectionFactory("amqp://localhost:61616");
            }
            case 3: {
                return new ActiveMQConnectionFactory("tcp://localhost:61616");
            }
        }
        return null;
    }

    public void internalSimpleSend(int protocolSender, int protocolConsumer) throws Throwable {
        jakarta.jms.Queue queue;
        Session session;
        ConnectionFactory factorySend = this.createFactory(protocolSender);
        ConnectionFactory factoryConsume = protocolConsumer == protocolSender ? factorySend : this.createFactory(protocolConsumer);
        StringBuilder bufferLarge = new StringBuilder();
        while (bufferLarge.length() < 102400) {
            bufferLarge.append("          ");
        }
        String bufferLargeContent = bufferLarge.toString();
        try (Connection connection = factorySend.createConnection();){
            connection.start();
            session = connection.createSession(false, 1);
            try {
                queue = session.createQueue(this.QUEUE.toString());
                try (MessageProducer producer = session.createProducer((Destination)queue);){
                    producer.setDeliveryMode(2);
                    TextMessage msg = session.createTextMessage("hello");
                    msg.setIntProperty("mycount", 0);
                    producer.send((Message)msg);
                    msg = session.createTextMessage(bufferLargeContent);
                    msg.setIntProperty("mycount", 1);
                    producer.send((Message)msg);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        connection = factoryConsume.createConnection();
        try {
            connection.start();
            session = connection.createSession(false, 1);
            try {
                queue = session.createQueue(this.QUEUE.toString());
                try (MessageConsumer consumer = session.createConsumer((Destination)queue);){
                    TextMessage message = (TextMessage)consumer.receive(1000L);
                    Assertions.assertNotNull((Object)message);
                    Assertions.assertEquals((int)0, (int)message.getIntProperty("mycount"));
                    Assertions.assertEquals((Object)"hello", (Object)message.getText());
                    message = (TextMessage)consumer.receive(1000L);
                    Assertions.assertNotNull((Object)message);
                    Assertions.assertEquals((int)1, (int)message.getIntProperty("mycount"));
                    Assertions.assertEquals((Object)bufferLargeContent, (Object)message.getText());
                    Wait.waitFor(() -> this.server.getPagingManager().getGlobalSize() == 0L, (long)5000L, (long)100L);
                    Assertions.assertEquals((long)0L, (long)this.server.getPagingManager().getGlobalSize());
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalSend(int protocolSender, int protocolConsumer) throws Throwable {
        this.internalSimpleSend(protocolSender, protocolConsumer);
        ConnectionFactory factorySend = this.createFactory(protocolSender);
        ConnectionFactory factoryConsume = protocolConsumer == protocolSender ? factorySend : this.createFactory(protocolConsumer);
        try (Connection connection = factorySend.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(this.QUEUE.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            if (this.durable) {
                producer.setDeliveryMode(2);
            } else {
                producer.setDeliveryMode(1);
            }
            long time = System.currentTimeMillis();
            int NUMBER_OF_MESSAGES = this.durable ? 5 : 50;
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                TextMessage msg = session.createTextMessage("hello " + i);
                msg.setIntProperty("mycount", i);
                producer.send((Message)msg);
                ObjectMessage objectMessage = session.createObjectMessage((Serializable)new MyTest().setI(i));
                producer.send((Message)objectMessage);
                MapMessage mapMessage = session.createMapMessage();
                mapMessage.setInt("intOne", i);
                mapMessage.setString("stringOne", Integer.toString(i));
                producer.send((Message)mapMessage);
                StreamMessage stream = session.createStreamMessage();
                stream.writeBoolean(true);
                stream.writeInt(i);
                producer.send((Message)stream);
                BytesMessage bytes = session.createBytesMessage();
                bytes.writeUTF("string " + i);
                producer.send((Message)bytes);
            }
            long end = System.currentTimeMillis();
            logger.debug("Time = {}", (Object)(end - time));
            TextMessage dummyMessage = session.createTextMessage();
            dummyMessage.setJMSType("car");
            dummyMessage.setStringProperty("color", "red");
            dummyMessage.setLongProperty("weight", 3000L);
            dummyMessage.setText("testSelectorExampleFromSpecs:1");
            producer.send((Message)dummyMessage);
            dummyMessage = session.createTextMessage();
            dummyMessage.setJMSType("car");
            dummyMessage.setStringProperty("color", "blue");
            dummyMessage.setLongProperty("weight", 3000L);
            dummyMessage.setText("testSelectorExampleFromSpecs:2");
            producer.send((Message)dummyMessage);
            connection.close();
            if (this.durable) {
                this.server.stop();
                this.server.start();
            }
            connection = factoryConsume.createConnection();
            session = connection.createSession(false, 1);
            queue = session.createQueue(this.QUEUE.toString());
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                TextMessage message = (TextMessage)consumer.receive(1000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((int)i, (int)message.getIntProperty("mycount"));
                Assertions.assertEquals((Object)("hello " + i), (Object)message.getText());
                ObjectMessage objectMessage = (ObjectMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)objectMessage);
                Assertions.assertEquals((int)i, (int)((MyTest)objectMessage.getObject()).getI());
                MapMessage mapMessage = (MapMessage)consumer.receive(1000L);
                Assertions.assertNotNull((Object)mapMessage);
                Assertions.assertEquals((int)i, (int)mapMessage.getInt("intOne"));
                Assertions.assertEquals((Object)Integer.toString(i), (Object)mapMessage.getString("stringOne"));
                StreamMessage stream = (StreamMessage)consumer.receive(5000L);
                Assertions.assertTrue((boolean)stream.readBoolean());
                Assertions.assertEquals((int)i, (int)stream.readInt());
                BytesMessage bytes = (BytesMessage)consumer.receive(5000L);
                Assertions.assertEquals((Object)("string " + i), (Object)bytes.readUTF());
            }
            consumer.close();
            consumer = session.createConsumer((Destination)queue, "JMSType = 'car' AND color = 'blue' AND weight > 2500");
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            Assertions.assertEquals((Object)"testSelectorExampleFromSpecs:2", (Object)msg.getText());
            consumer.close();
            consumer = session.createConsumer((Destination)queue);
            msg = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertNull((Object)consumer.receiveNoWait());
            Wait.waitFor(() -> this.server.getPagingManager().getGlobalSize() == 0L, (long)5000L, (long)100L);
            Assertions.assertEquals((long)0L, (long)this.server.getPagingManager().getGlobalSize());
        }
    }

    @TestTemplate
    public void testConsumerAckImmediateAutoCommitTrue() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
    }

    @TestTemplate
    public void testConsumerAckImmediateAutoCommitFalse() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, false, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
    }

    @TestTemplate
    public void testConsumerAckImmediateAckIgnored() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
            if (i >= 50) continue;
            message2.acknowledge();
        }
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
    }

    @TestTemplate
    public void testConsumerAckImmediateCloseSession() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
            if (i >= 50) continue;
            message2.acknowledge();
        }
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)0, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
    }

    @TestTemplate
    public void testAcksWithSmallSendWindow() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
        }
        session.close();
        sf.close();
        CountDownLatch latch = new CountDownLatch(100);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)((Interceptor)(packet, connection) -> {
            if (packet.getType() == 41) {
                latch.countDown();
            }
            return true;
        }));
        ServerLocator locator = this.createInVMNonHALocator().setConfirmationWindowSize(100).setAckBatchSize(-1);
        ClientSessionFactory sfReceive = this.createSessionFactory(locator);
        ClientSession sessionRec = sfReceive.createSession(false, true, true);
        ClientConsumer consumer = sessionRec.createConsumer(this.QUEUE);
        consumer.setMessageHandler(message -> {
            try {
                message.acknowledge();
            }
            catch (ActiveMQException e) {
                e.printStackTrace();
            }
        });
        sessionRec.start();
        Assertions.assertTrue((boolean)latch.await(60L, TimeUnit.SECONDS));
        sessionRec.close();
        locator.close();
    }

    @TestTemplate
    public void testConsumeWithNoConsumerFlowControl() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setConsumerWindowSize(-1);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        session.start();
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = consumer.receive(10000L);
            Assertions.assertNotNull((Object)message);
            message.acknowledge();
        }
        session.close();
        sf.close();
        locator.close();
    }

    @TestTemplate
    public void testClearListener() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.start();
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        consumer.setMessageHandler(msg -> {});
        consumer.setMessageHandler(null);
        consumer.receiveImmediate();
        session.close();
    }

    @TestTemplate
    public void testNoReceiveWithListener() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        consumer.setMessageHandler(msg -> {});
        try {
            consumer.receiveImmediate();
            Assertions.fail((String)"Should throw exception");
        }
        catch (ActiveMQIllegalStateException activeMQIllegalStateException) {
        }
        catch (ActiveMQException me) {
            Assertions.fail((String)"Wrong exception code");
        }
        session.close();
    }

    @TestTemplate
    public void testReceiveAndResend() throws Exception {
        ConcurrentHashSet sessions = new ConcurrentHashSet();
        AtomicInteger errors = new AtomicInteger(0);
        SimpleString QUEUE_RESPONSE = SimpleString.of((String)"QUEUE_RESPONSE");
        int numberOfSessions = 50;
        int numberOfMessages = 10;
        CountDownLatch latchReceive = new CountDownLatch(500);
        ClientSessionFactory sf = this.locator.createSessionFactory();
        for (int i = 0; i < 50; ++i) {
            ClientSession session = sf.createSession(false, true, true);
            sessions.add(session);
            session.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE.concat("" + i)).setAddress(this.QUEUE).setDurable(Boolean.valueOf(true)));
            if (i == 0) {
                session.createQueue(QueueConfiguration.of((SimpleString)QUEUE_RESPONSE));
            }
            ClientConsumer consumer = session.createConsumer(this.QUEUE.concat("" + i));
            sessions.add(consumer);
            consumer.setMessageHandler(arg_0 -> this.lambda$testReceiveAndResend$12((Set)sessions, QUEUE_RESPONSE, errors, latchReceive, arg_0));
            session.start();
        }
        Thread tCons = new Thread(() -> {
            try {
                ClientMessage msg;
                ServerLocator locatorSend = this.createFactory(this.isNetty());
                ClientSessionFactory factory = locatorSend.createSessionFactory();
                ClientSession sessionSend = factory.createSession(true, true);
                ClientConsumer cons = sessionSend.createConsumer(QUEUE_RESPONSE);
                sessionSend.start();
                for (int i = 0; i < 500 && (msg = cons.receive(5000L)) != null; ++i) {
                    msg.acknowledge();
                }
                if (cons.receiveImmediate() != null) {
                    logger.debug("ERROR: Received an extra message");
                    errors.incrementAndGet();
                }
                sessionSend.close();
                factory.close();
                locatorSend.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                errors.incrementAndGet();
            }
        });
        tCons.start();
        ClientSession mainSessionSend = sf.createSession(true, true);
        ClientProducer mainProd = mainSessionSend.createProducer(this.QUEUE);
        for (int i = 0; i < 10; ++i) {
            mainProd.send((org.apache.activemq.artemis.api.core.Message)mainSessionSend.createMessage(true));
        }
        latchReceive.await(2L, TimeUnit.MINUTES);
        tCons.join();
        sf.close();
        Assertions.assertEquals((int)0, (int)errors.get(), (String)"Had errors along the execution");
    }

    @TestTemplate
    public void testConsumerCreditsOnRollback() throws Exception {
        this.locator.setConsumerWindowSize(10000);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createTransactedSession();
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        byte[] bytes = new byte[1000];
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(false);
            message.getBodyBuffer().writeBytes(bytes);
            message.putIntProperty("count", i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.commit();
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 110; ++i) {
            boolean redelivered;
            ClientMessage message = consumer.receive();
            int count = message.getIntProperty("count");
            boolean bl = redelivered = message.getDeliveryCount() > 1;
            if (count % 2 == 0 && !redelivered) {
                session.rollback();
                continue;
            }
            session.commit();
        }
        session.close();
    }

    @TestTemplate
    public void testInVMURI() throws Exception {
        this.locator.close();
        ServerLocator locator = this.addServerLocator(ServerLocatorImpl.newLocator((String)"vm:/1"));
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession();
        ClientProducer producer = session.createProducer(this.QUEUE);
        producer.send((org.apache.activemq.artemis.api.core.Message)session.createMessage(true));
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        Assertions.assertNotNull((Object)consumer.receiveImmediate());
        session.close();
        factory.close();
    }

    @TestTemplate
    public void testConsumerCreditsOnRollbackLargeMessages() throws Exception {
        this.locator.setConsumerWindowSize(10000).setMinLargeMessageSize(1000);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createTransactedSession();
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        byte[] bytes = new byte[10000];
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(false);
            message.getBodyBuffer().writeBytes(bytes);
            message.putIntProperty("count", i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.commit();
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        for (int i = 0; i < 110; ++i) {
            boolean redelivered;
            ClientMessage message = consumer.receive();
            int count = message.getIntProperty("count");
            boolean bl = redelivered = message.getDeliveryCount() > 1;
            if (count % 2 == 0 && !redelivered) {
                session.rollback();
                continue;
            }
            session.commit();
        }
        session.close();
    }

    @TestTemplate
    public void testMultipleConsumersOnSharedQueue() throws Throwable {
        if (!this.isNetty() || this.durable) {
            return;
        }
        boolean durable = false;
        long TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(1L);
        int forks = 100;
        int queues = 100;
        boolean runs = true;
        boolean messages = true;
        ConnectionFactory factorySend = this.createFactory(1);
        AtomicLongArray receivedMessages = new AtomicLongArray(100);
        Thread[] producersRunners = new Thread[100];
        Thread[] consumersRunners = new Thread[100];
        CyclicBarrier onStartRun = new CyclicBarrier(201);
        CyclicBarrier onFinishRun = new CyclicBarrier(201);
        int messagesSent = 100;
        AtomicInteger messagesRecieved = new AtomicInteger(0);
        int i = 0;
        while (i < 100) {
            int forkIndex = i++;
            String queueName = "q_" + forkIndex % 100;
            Thread producerRunner = new Thread(() -> {
                try (Connection connection = factorySend.createConnection();){
                    connection.start();
                    try (Session session = connection.createSession(false, 1);){
                        jakarta.jms.Queue queue = session.createQueue(queueName);
                        try (MessageProducer producer = session.createProducer((Destination)queue);){
                            producer.setDeliveryMode(1);
                            for (int r = 0; r < 1; ++r) {
                                onStartRun.await();
                                for (int m = 0; m < 1; ++m) {
                                    BytesMessage bytesMessage = session.createBytesMessage();
                                    bytesMessage.writeInt(forkIndex);
                                    producer.send((Message)bytesMessage);
                                }
                                onFinishRun.await();
                            }
                        }
                        catch (InterruptedException | BrokenBarrierException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            });
            producerRunner.setDaemon(true);
            Thread consumerRunner = new Thread(() -> {
                try (Connection connection = factorySend.createConnection();){
                    connection.start();
                    try (Session session = connection.createSession(false, 1);){
                        jakarta.jms.Queue queue = session.createQueue(queueName);
                        try (MessageConsumer consumer = session.createConsumer((Destination)queue);){
                            for (int r = 0; r < 1; ++r) {
                                onStartRun.await();
                                while (messagesRecieved.get() != 100) {
                                    BytesMessage receivedMessage = (BytesMessage)consumer.receive(1000L);
                                    if (receivedMessage == null) continue;
                                    int receivedConsumerIndex = receivedMessage.readInt();
                                    receivedMessages.getAndIncrement(receivedConsumerIndex);
                                    messagesRecieved.incrementAndGet();
                                }
                                onFinishRun.await();
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (BrokenBarrierException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            });
            consumerRunner.setDaemon(true);
            consumersRunners[forkIndex] = consumerRunner;
            producersRunners[forkIndex] = producerRunner;
        }
        Stream.of(consumersRunners).forEach(Thread::start);
        Stream.of(producersRunners).forEach(Thread::start);
        long messagesPerRun = 100L;
        for (int r = 0; r < 1; ++r) {
            onStartRun.await(TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            logger.debug("started run {}", (Object)r);
            long start = System.currentTimeMillis();
            onFinishRun.await(TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            long elapsedMillis = System.currentTimeMillis() - start;
            logger.debug("{} msg/sec", (Object)(100000L / elapsedMillis));
        }
        Stream.of(producersRunners).forEach(runner -> {
            try {
                runner.join(TIMEOUT_MILLIS * 1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        Stream.of(producersRunners).forEach(Thread::interrupt);
        Stream.of(consumersRunners).forEach(runner -> {
            try {
                runner.join(TIMEOUT_MILLIS * 1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        Stream.of(consumersRunners).forEach(Thread::interrupt);
        for (int i2 = 0; i2 < 100; ++i2) {
            Assertions.assertEquals((long)1L, (long)receivedMessages.get(i2), (String)("The consumer " + i2 + " must receive all the messages sent."));
        }
    }

    @TestTemplate
    public void testConsumerXpathSelector() throws Exception {
        SimpleString BODY = SimpleString.of((String)"<root><a key='first' num='1'/><b key='second' num='2'>b</b></root>");
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, false, true);
        ClientProducer producer = session.createProducer(this.QUEUE);
        ClientMessage message = session.createMessage(false);
        message.setType((byte)3);
        message.getBodyBuffer().writeNullableSimpleString(SimpleString.of((String)"wrong"));
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        message = session.createMessage(false);
        message.setType((byte)3);
        message.getBodyBuffer().writeNullableSimpleString(BODY);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        ClientConsumer consumer = session.createConsumer(this.QUEUE.toString(), "XPATH 'root/a'");
        session.start();
        ClientMessage message2 = consumer.receive(5000L);
        Assertions.assertNotNull((Object)message2);
        Assertions.assertEquals((Object)BODY, (Object)message2.getBodyBuffer().readNullableSimpleString());
        Assertions.assertEquals((int)1, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$testReceiveAndResend$12(Set sessions, SimpleString QUEUE_RESPONSE, AtomicInteger errors, CountDownLatch latchReceive, ClientMessage msg) {
        try {
            ServerLocator locatorSendx = this.createFactory(this.isNetty()).setReconnectAttempts(15);
            ClientSessionFactory factoryx = locatorSendx.createSessionFactory();
            ClientSession sessionSend = factoryx.createSession(true, true);
            sessions.add(sessionSend);
            sessions.add(locatorSendx);
            sessions.add(factoryx);
            ClientProducer prod = sessionSend.createProducer(QUEUE_RESPONSE);
            sessionSend.start();
            sessions.add(prod);
            msg.acknowledge();
            prod.send((org.apache.activemq.artemis.api.core.Message)sessionSend.createMessage(true));
            prod.close();
            sessionSend.commit();
            sessionSend.close();
            factoryx.close();
            if (Thread.currentThread().isInterrupted()) {
                System.err.println("Netty has interrupted a thread!!!");
                errors.incrementAndGet();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            errors.incrementAndGet();
        }
        finally {
            latchReceive.countDown();
        }
    }

    public static class MyTest
    implements Serializable {
        int i;

        public int getI() {
            return this.i;
        }

        public MyTest setI(int i) {
            this.i = i;
            return this;
        }
    }
}

