/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSPagingFileDeleteTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Topic topic1;
    Connection connection;
    Session session;
    MessageConsumer subscriber1;
    MessageConsumer subscriber2;
    PagingStore pagingStore;
    private static final int MESSAGE_SIZE = 1024;
    private static final int PAGE_SIZE = 10240;
    private static final int PAGE_MAX = 20480;
    private static final int RECEIVE_TIMEOUT = 500;
    private static final int MESSAGE_NUM = 50;

    @Override
    protected boolean usePersistence() {
        return true;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.topic1 = this.createTopic("topic1");
        AddressSettings setting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)setting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopicsWithNonDurableSubscription() throws Exception {
        this.connection = null;
        try {
            for (int repeat = 0; repeat < 2; ++repeat) {
                this.connection = this.cf.createConnection();
                this.connection.setClientID("cid");
                this.session = this.connection.createSession(false, 1);
                MessageProducer producer = this.session.createProducer((Destination)this.topic1);
                this.subscriber1 = this.session.createConsumer((Destination)this.topic1);
                logger.debug("---------- Send messages. ----------");
                BytesMessage bytesMessage = this.session.createBytesMessage();
                bytesMessage.writeBytes(new byte[1024]);
                for (int i = 0; i < 50; ++i) {
                    producer.send((Message)bytesMessage);
                }
                logger.debug("Sent {} messages.", (Object)50);
                this.pagingStore = this.server.getPagingManager().getPageStore(SimpleString.of((String)"topic1"));
                this.printPageStoreInfo(this.pagingStore);
                Assertions.assertTrue((boolean)this.pagingStore.isPaging());
                this.connection.close();
                Wait.assertFalse(() -> ((PagingStore)this.pagingStore).isPaging());
                this.printPageStoreInfo(this.pagingStore);
            }
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopics() throws Exception {
        this.connection = null;
        try {
            int i;
            this.connection = this.cf.createConnection();
            this.connection.setClientID("cid");
            this.session = this.connection.createSession(false, 1);
            MessageProducer producer = this.session.createProducer((Destination)this.topic1);
            this.subscriber1 = this.session.createDurableSubscriber(this.topic1, "subscriber-1");
            this.subscriber2 = this.session.createDurableSubscriber(this.topic1, "subscriber-2");
            logger.debug("---------- Send messages. ----------");
            BytesMessage bytesMessage = this.session.createBytesMessage();
            bytesMessage.writeBytes(new byte[1024]);
            for (i = 0; i < 50; ++i) {
                producer.send((Message)bytesMessage);
            }
            logger.debug("Sent {} messages.", (Object)50);
            this.pagingStore = this.server.getPagingManager().getPageStore(SimpleString.of((String)"topic1"));
            this.printPageStoreInfo(this.pagingStore);
            Assertions.assertTrue((boolean)this.pagingStore.isPaging());
            this.connection.start();
            this.stopAndStartServer();
            logger.debug("---------- Receive all messages. ----------");
            for (i = 0; i < 50; ++i) {
                Message message1 = this.subscriber1.receive(500L);
                Assertions.assertNotNull((Object)message1);
                Message message2 = this.subscriber2.receive(500L);
                Assertions.assertNotNull((Object)message2);
            }
            this.pagingStore = this.server.getPagingManager().getPageStore(SimpleString.of((String)"topic1"));
            long timeout = System.currentTimeMillis() + 5000L;
            while (timeout > System.currentTimeMillis() && this.pagingStore.isPaging()) {
                Thread.sleep(100L);
            }
            Assertions.assertFalse((boolean)this.pagingStore.isPaging());
            this.printPageStoreInfo(this.pagingStore);
            Assertions.assertEquals((long)0L, (long)this.pagingStore.getAddressSize());
            Assertions.assertFalse((boolean)this.pagingStore.isPaging());
            producer = this.session.createProducer((Destination)this.topic1);
            bytesMessage = this.session.createBytesMessage();
            bytesMessage.writeBytes(new byte[1024]);
            producer.send((Message)bytesMessage);
            this.printPageStoreInfo(this.pagingStore);
            timeout = System.currentTimeMillis() + 10000L;
            Wait.assertEquals((long)1L, () -> ((PagingStore)this.pagingStore).getNumberOfPages());
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    private void stopAndStartServer() throws Exception {
        logger.debug("---------- Restart server. ----------");
        this.connection.close();
        this.jmsServer.stop();
        this.jmsServer.start();
        this.jmsServer.activated();
        this.registerConnectionFactory();
        this.printPageStoreInfo(this.pagingStore);
        this.reconnect();
    }

    private void reconnect() throws Exception {
        this.connection = this.cf.createConnection();
        this.connection.setClientID("cid");
        this.session = this.connection.createSession(false, 1);
        this.subscriber1 = this.session.createDurableSubscriber(this.topic1, "subscriber-1");
        this.subscriber2 = this.session.createDurableSubscriber(this.topic1, "subscriber-2");
        this.connection.start();
    }

    private void printPageStoreInfo(PagingStore pagingStore) throws Exception {
        logger.debug("---------- Paging Store Info ----------");
        logger.debug(" CurrentPage = {}", (Object)pagingStore.getCurrentPage());
        logger.debug(" FirstPage = {}", (Object)pagingStore.getFirstPage());
        logger.debug(" Number of Pages = {}", (Object)pagingStore.getNumberOfPages());
        logger.debug(" Address Size = {}", (Object)pagingStore.getAddressSize());
        logger.debug(" Is Paging = {}", (Object)pagingStore.isPaging());
    }
}

