/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UpdateQueueTest
extends ActiveMQTestBase {
    @Test
    public void testUpdateQueueWithNullUser() throws Exception {
        ActiveMQServer server = this.createServer(true, false);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://0");
        server.start();
        SimpleString ADDRESS = SimpleString.of((String)"queue.0");
        SimpleString user = SimpleString.of((String)"newUser");
        Queue queue = server.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setRoutingType(RoutingType.ANYCAST).setUser(user));
        Long originalID = queue.getID();
        Assertions.assertEquals((Object)user, (Object)queue.getUser());
        Connection conn = factory.createConnection();
        Session session = conn.createSession(false, 1);
        MessageProducer prod = session.createProducer((Destination)session.createQueue(ADDRESS.toString()));
        for (int i = 0; i < 100; ++i) {
            prod.send((Message)session.createTextMessage("message " + i));
        }
        server.updateQueue(QueueConfiguration.of((SimpleString)ADDRESS).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).setExclusive(Boolean.valueOf(false)));
        conn.close();
        factory.close();
        server.stop();
        server.start();
        this.validateBindingRecords(server, (byte)21, 2);
        queue = server.locateQueue(ADDRESS);
        Assertions.assertNotNull((Object)queue, (String)"queue not found");
        Assertions.assertEquals((Object)user, (Object)queue.getUser(), (String)"newUser");
        factory = new ActiveMQConnectionFactory("vm://0");
        conn = factory.createConnection();
        session = conn.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(ADDRESS.toString()));
        conn.start();
        for (int i = 0; i < 100; ++i) {
            Assertions.assertNotNull((Object)consumer.receive(5000L));
        }
        Assertions.assertNull((Object)consumer.receiveNoWait());
        Assertions.assertEquals((int)1, (int)queue.getMaxConsumers());
        conn.close();
        Assertions.assertEquals((Long)originalID, (Long)server.locateQueue(ADDRESS).getID());
        server.stop();
        server.start();
        this.validateBindingRecords(server, (byte)21, 2);
        server.stop();
    }

    @Test
    public void testUpdateQueue() throws Exception {
        ActiveMQServer server = this.createServer(true, false);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://0");
        server.start();
        SimpleString ADDRESS = SimpleString.of((String)"queue.0");
        Queue queue = server.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setRoutingType(RoutingType.ANYCAST));
        Long originalID = queue.getID();
        Assertions.assertNull((Object)queue.getUser());
        Connection conn = factory.createConnection();
        Session session = conn.createSession(false, 1);
        MessageProducer prod = session.createProducer((Destination)session.createQueue(ADDRESS.toString()));
        for (int i = 0; i < 100; ++i) {
            prod.send((Message)session.createTextMessage("message " + i));
        }
        server.updateQueue(QueueConfiguration.of((String)ADDRESS.toString()).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).setPurgeOnNoConsumers(Boolean.valueOf(false)).setExclusive(Boolean.valueOf(true)).setGroupRebalance(Boolean.valueOf(true)).setGroupBuckets(Integer.valueOf(5)).setGroupFirstKey("gfk").setNonDestructive(Boolean.valueOf(true)).setConsumersBeforeDispatch(Integer.valueOf(1)).setDelayBeforeDispatch(Long.valueOf(10L)).setUser("newUser").setRingSize(Long.valueOf(180L)));
        conn.close();
        factory.close();
        server.stop();
        server.start();
        this.validateBindingRecords(server, (byte)21, 2);
        queue = server.locateQueue(ADDRESS);
        Assertions.assertNotNull((Object)queue, (String)"queue not found");
        Assertions.assertEquals((int)1, (int)queue.getMaxConsumers());
        Assertions.assertFalse((boolean)queue.isPurgeOnNoConsumers());
        Assertions.assertTrue((boolean)queue.isExclusive());
        Assertions.assertTrue((boolean)queue.isGroupRebalance());
        Assertions.assertEquals((int)5, (int)queue.getGroupBuckets());
        Assertions.assertEquals((Object)"gfk", (Object)queue.getGroupFirstKey().toString());
        Assertions.assertTrue((boolean)queue.isNonDestructive());
        Assertions.assertEquals((int)1, (int)queue.getConsumersBeforeDispatch());
        Assertions.assertEquals((long)10L, (long)queue.getDelayBeforeDispatch());
        Assertions.assertEquals((Object)"newUser", (Object)queue.getUser().toString());
        Assertions.assertEquals((long)180L, (long)queue.getRingSize());
        Assertions.assertEquals((int)8192, (int)queue.getInitialQueueBufferSize());
        factory = new ActiveMQConnectionFactory("vm://0");
        conn = factory.createConnection();
        session = conn.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(ADDRESS.toString()));
        conn.start();
        for (int i = 0; i < 100; ++i) {
            Assertions.assertNotNull((Object)consumer.receive(5000L));
        }
        Assertions.assertNull((Object)consumer.receiveNoWait());
        conn.close();
        Assertions.assertEquals((Long)originalID, (Long)server.locateQueue(ADDRESS).getID());
        server.stop();
        server.start();
        this.validateBindingRecords(server, (byte)21, 2);
        server.stop();
    }

    private void validateBindingRecords(ActiveMQServer server, byte type, int expected) throws Exception {
        HashMap<Integer, AtomicInteger> counts = this.countBindingJournal(server.getConfiguration());
        Assertions.assertEquals((int)expected, (int)counts.get(type).intValue());
    }

    @Test
    public void testUpdateAddress() throws Exception {
        ActiveMQServer server = this.createServer(true, true);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        server.start();
        SimpleString ADDRESS = SimpleString.of((String)"queue.0");
        AddressInfo infoAdded = new AddressInfo(ADDRESS, RoutingType.ANYCAST);
        server.addAddressInfo(infoAdded);
        server.updateAddressInfo(ADDRESS, infoAdded.getRoutingTypes());
        server.stop();
        server.start();
        AddressInfo infoAfterRestart = server.getPostOffice().getAddressInfo(ADDRESS);
        Assertions.assertEquals((long)infoAdded.getId(), (long)infoAfterRestart.getId());
        EnumSet<RoutingType> completeSet = EnumSet.allOf(RoutingType.class);
        server.updateAddressInfo(ADDRESS, completeSet);
        server.stop();
        server.start();
        infoAfterRestart = server.getPostOffice().getAddressInfo(ADDRESS);
        Assertions.assertNotEquals((long)infoAdded.getId(), (long)infoAfterRestart.getId());
    }
}

