/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedBridgeConfiguration;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class BridgeConfigurationStorageTest
extends StorageManagerTestBase {
    public BridgeConfigurationStorageTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @TestTemplate
    public void testStoreBridgeConfiguration() throws Exception {
        TransformerConfiguration mytransformer = new TransformerConfiguration("mytransformer");
        mytransformer.getProperties().put("key1", "prop1");
        mytransformer.getProperties().put("key2", "prop2");
        mytransformer.getProperties().put("key3", "prop3");
        BridgeConfiguration configuration = new BridgeConfiguration().setName("name").setParentName("name").setQueueName("QueueName").setConcurrency(2).setPendingAckTimeout(9876L).setForwardingAddress("forward").setProducerWindowSize(123123).setConfirmationWindowSize(123123).setStaticConnectors(Arrays.asList("connector1", "connector2")).setTransformerConfiguration(mytransformer);
        this.journal.storeBridgeConfiguration(new PersistedBridgeConfiguration(configuration));
        this.rebootStorage();
        List bridgeConfigurations = this.journal.recoverBridgeConfigurations();
        Assertions.assertEquals((int)1, (int)bridgeConfigurations.size());
        PersistedBridgeConfiguration persistedBridgeConfiguration = (PersistedBridgeConfiguration)bridgeConfigurations.get(0);
        Assertions.assertEquals((Object)configuration.getName(), (Object)persistedBridgeConfiguration.getBridgeConfiguration().getName());
        Assertions.assertEquals((Object)configuration.getQueueName(), (Object)persistedBridgeConfiguration.getBridgeConfiguration().getQueueName());
        Assertions.assertEquals((int)configuration.getConcurrency(), (int)persistedBridgeConfiguration.getBridgeConfiguration().getConcurrency());
        Assertions.assertEquals((long)configuration.getPendingAckTimeout(), (long)persistedBridgeConfiguration.getBridgeConfiguration().getPendingAckTimeout());
        Assertions.assertEquals((Object)configuration.getForwardingAddress(), (Object)persistedBridgeConfiguration.getBridgeConfiguration().getForwardingAddress());
        Assertions.assertEquals((Object)configuration.getStaticConnectors(), (Object)persistedBridgeConfiguration.getBridgeConfiguration().getStaticConnectors());
        Assertions.assertNotNull((Object)persistedBridgeConfiguration.getBridgeConfiguration().getTransformerConfiguration());
        Assertions.assertEquals((Object)"mytransformer", (Object)persistedBridgeConfiguration.getBridgeConfiguration().getTransformerConfiguration().getClassName());
        Map properties = persistedBridgeConfiguration.getBridgeConfiguration().getTransformerConfiguration().getProperties();
        Assertions.assertEquals((int)3, (int)properties.size());
        Assertions.assertEquals((Object)"prop1", properties.get("key1"));
        Assertions.assertEquals((Object)"prop2", properties.get("key2"));
        Assertions.assertEquals((Object)"prop3", properties.get("key3"));
    }

    @TestTemplate
    public void testStoreBridgeConfigurationNoTransformer() throws Exception {
        BridgeConfiguration configuration = new BridgeConfiguration().setName("name").setParentName("name").setQueueName("QueueName").setConcurrency(2).setForwardingAddress("forward").setStaticConnectors(Arrays.asList("connector1", "connector2"));
        this.journal.storeBridgeConfiguration(new PersistedBridgeConfiguration(configuration));
        this.rebootStorage();
        List bridgeConfigurations = this.journal.recoverBridgeConfigurations();
        Assertions.assertEquals((int)1, (int)bridgeConfigurations.size());
        PersistedBridgeConfiguration persistedBridgeConfiguration = (PersistedBridgeConfiguration)bridgeConfigurations.get(0);
        Assertions.assertEquals((Object)configuration.getName(), (Object)persistedBridgeConfiguration.getBridgeConfiguration().getName());
        Assertions.assertEquals((Object)configuration.getQueueName(), (Object)persistedBridgeConfiguration.getBridgeConfiguration().getQueueName());
        Assertions.assertEquals((int)configuration.getConcurrency(), (int)persistedBridgeConfiguration.getBridgeConfiguration().getConcurrency());
        Assertions.assertEquals((Object)configuration.getForwardingAddress(), (Object)persistedBridgeConfiguration.getBridgeConfiguration().getForwardingAddress());
        Assertions.assertEquals((Object)configuration.getStaticConnectors(), (Object)persistedBridgeConfiguration.getBridgeConfiguration().getStaticConnectors());
        Assertions.assertNull((Object)persistedBridgeConfiguration.getBridgeConfiguration().getTransformerConfiguration());
    }
}

