/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.routing;

import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.management.ConnectionRouterControl;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.routing.RoutingTestBase;
import org.apache.activemq.artemis.tests.integration.security.SecurityTest;
import org.apache.activemq.artemis.utils.Wait;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MQTTRedirectTest
extends RoutingTestBase {
    @Test
    public void testSimpleRedirect() throws Exception {
        String topicName = "RedirectTestTopic";
        this.setupPrimaryServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupPrimaryServerWithDiscovery(1, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupRouterServerWithDiscovery(0, KeyType.USER_NAME, "FIRST_ELEMENT", null, false, null, 1);
        this.startServers(0, 1);
        this.getServer(0).createQueue(QueueConfiguration.of((String)"RedirectTestTopic").setRoutingType(RoutingType.ANYCAST));
        this.getServer(1).createQueue(QueueConfiguration.of((String)"RedirectTestTopic").setRoutingType(RoutingType.ANYCAST));
        QueueControl queueControl0 = (QueueControl)this.getServer(0).getManagementService().getResource("queue.RedirectTestTopic");
        QueueControl queueControl1 = (QueueControl)this.getServer(1).getManagementService().getResource("queue.RedirectTestTopic");
        Assertions.assertEquals((long)0L, (long)queueControl0.countMessages());
        Assertions.assertEquals((long)0L, (long)queueControl1.countMessages());
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setCleanSession(true);
        connOpts.setUserName("admin");
        connOpts.setPassword("admin".toCharArray());
        MqttClient client0 = new MqttClient("tcp://localhost:61616", "TEST", (MqttClientPersistence)new MemoryPersistence());
        try {
            client0.connect(connOpts);
            Assertions.fail();
        }
        catch (MqttException e) {
            Assertions.assertEquals((byte)-100, (byte)((byte)e.getReasonCode()));
        }
        client0.close();
        ConnectionRouterControl connectionRouterControl = (ConnectionRouterControl)this.getServer(0).getManagementService().getResource("connectionrouter.bb1");
        CompositeData targetData = connectionRouterControl.getTarget("admin");
        CompositeData targetConnectorData = (CompositeData)targetData.get("connector");
        TabularData targetConnectorParams = (TabularData)targetConnectorData.get("params");
        CompositeData hostData = targetConnectorParams.get(new Object[]{"host"});
        CompositeData portData = targetConnectorParams.get(new Object[]{"port"});
        String host = hostData != null ? (String)hostData.get("value") : "localhost";
        int port = portData != null ? Integer.parseInt((String)portData.get("value")) : 61616;
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList messages = new ArrayList();
        MqttClient client1 = new MqttClient("tcp://" + host + ":" + port, "TEST", (MqttClientPersistence)new MemoryPersistence());
        client1.connect(connOpts);
        Assertions.assertEquals((long)0L, (long)queueControl0.countMessages());
        Assertions.assertEquals((long)0L, (long)queueControl1.countMessages());
        client1.subscribe("RedirectTestTopic", (s, mqttMessage) -> {
            messages.add(mqttMessage);
            latch.countDown();
        });
        client1.publish("RedirectTestTopic", new MqttMessage("TEST".getBytes()));
        Assertions.assertTrue((boolean)latch.await(3000L, TimeUnit.MILLISECONDS));
        Assertions.assertEquals((Object)"TEST", (Object)new String(((MqttMessage)messages.get(0)).getPayload()));
        client1.disconnect();
        client1.close();
        Assertions.assertEquals((long)0L, (long)queueControl0.countMessages());
        Wait.assertEquals((long)0L, () -> ((QueueControl)queueControl1).countMessages());
    }

    @Test
    public void testRoleNameKeyLocalTarget() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        this.servers[0] = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultConfig(true).setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        this.setupRouterServerWithLocalTarget(0, KeyType.ROLE_NAME, "b", "b");
        this.startServers(0);
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setCleanSession(true);
        connOpts.setUserName("a");
        connOpts.setPassword("a".toCharArray());
        MqttClient client0 = new MqttClient("tcp://localhost:61616", "TEST", (MqttClientPersistence)new MemoryPersistence());
        try {
            client0.connect(connOpts);
            Assertions.fail((String)"Expect to be rejected as not in role b");
        }
        catch (MqttException e) {
            Assertions.assertEquals((byte)-100, (byte)((byte)e.getReasonCode()));
        }
        client0.close();
        MqttClient client1 = new MqttClient("tcp://localhost:61616", "TEST", (MqttClientPersistence)new MemoryPersistence());
        connOpts.setUserName("b");
        connOpts.setPassword("b".toCharArray());
        client1.connect(connOpts);
        client1.disconnect();
        client1.close();
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

