/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.security.auth.Subject;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnection;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.impl.SecurityStoreImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager2;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager3;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager4;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager5;
import org.apache.activemq.artemis.spi.core.security.jaas.NoCacheLoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SecurityTest
extends ActiveMQTestBase {
    private static final String addressA = "addressA";
    private static final String queueA = "queueA";
    private ServerLocator locator;
    private Configuration configuration;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testJAASSecurityManagerAuthentication() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            ClientSession session = cf.createSession("first", "secret", false, true, true, false, 0);
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testNoCacheException() throws Exception {
        ActiveMQSecurityManager5 securityManager = new ActiveMQSecurityManager5(){
            boolean flipper = false;

            public Subject authenticate(String user, String password, RemotingConnection remotingConnection, String securityDomain) throws NoCacheLoginException {
                boolean bl = this.flipper = !this.flipper;
                if (this.flipper) {
                    Subject validatedSubject = new Subject();
                    validatedSubject.getPrincipals().add((Principal)new UserPrincipal(user));
                    return validatedSubject;
                }
                throw new NoCacheLoginException();
            }

            public boolean authorize(Subject subject, Set<Role> roles, CheckType checkType, String address) {
                return false;
            }

            public boolean validateUser(String user, String password) {
                return false;
            }

            public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
                return false;
            }
        };
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        cf.createSession("first", "secret", false, true, true, false, 0).close();
        Assertions.assertEquals((long)1L, (long)((SecurityStoreImpl)server.getSecurityStore()).getAuthenticationCacheSize());
        try {
            cf.createSession("first", "secret", false, true, true, false, 0);
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        Assertions.assertEquals((long)1L, (long)((SecurityStoreImpl)server.getSecurityStore()).getAuthenticationCacheSize());
    }

    @Test
    public void testNoCacheNamingException() throws Exception {
        this.internalTestNoCacheException("BrokenLDAPLoginNamingException");
    }

    @Test
    public void testNoCacheNamingExceptionRegex() throws Exception {
        this.internalTestNoCacheException("BrokenLDAPLoginNamingExceptionRegex");
    }

    @Test
    public void testNoCacheConnectException() throws Exception {
        this.internalTestNoCacheException("BrokenLDAPLoginConnectException");
    }

    @Test
    public void testNoCacheConnectExceptionRegex() throws Exception {
        this.internalTestNoCacheException("BrokenLDAPLoginConnectExceptionRegex");
    }

    private void internalTestNoCacheException(String ldapConfigName) throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(ldapConfigName);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            cf.createSession("first", "secret", false, true, true, false, 0);
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        Assertions.assertEquals((long)0L, (long)((SecurityStoreImpl)server.getSecurityStore()).getAuthenticationCacheSize());
    }

    @Test
    public void testJAASSecurityManagerAuthenticationWithPasswordCodec() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLoginWithPasswordCodec");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            ClientSession session = cf.createSession("test", "password", false, true, true, false, 0);
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testJAASSecurityManagerAuthenticationWithValidateUser() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        server.getConfiguration().setPopulateValidatedUser(true);
        server.start();
        Role role = new Role("programmers", true, true, true, true, true, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        server.getSecurityRepository().addMatch("#", roles);
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            ClientSession session = cf.createSession("first", "secret", false, true, true, false, 0);
            server.createQueue(QueueConfiguration.of((String)"queue").setAddress("address").setRoutingType(RoutingType.ANYCAST));
            ClientProducer producer = session.createProducer("address");
            producer.send((Message)session.createMessage(true));
            session.commit();
            producer.close();
            ClientConsumer consumer = session.createConsumer("queue");
            session.start();
            ClientMessage message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)"first", (Object)message.getValidatedUserID());
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testJAASSecurityManagerAuthenticationWithCerts() throws Exception {
        this.testJAASSecurityManagerAuthenticationWithCerts("CertLogin", "needClientAuth");
    }

    @Test
    public void testJAASSecurityManagerAuthenticationWithCertsWantClientAuth() throws Exception {
        this.testJAASSecurityManagerAuthenticationWithCerts("CertLogin", "wantClientAuth");
    }

    @Test
    public void testJAASSecurityManagerAuthenticationWithRegexps() throws Exception {
        this.testJAASSecurityManagerAuthenticationWithCerts("CertLoginWithRegexp", "needClientAuth");
    }

    @Test
    public void testJAASSecurityManagerAuthenticationWithRegexpsWantClientAuth() throws Exception {
        this.testJAASSecurityManagerAuthenticationWithCerts("CertLoginWithRegexp", "wantClientAuth");
    }

    protected void testJAASSecurityManagerAuthenticationWithCerts(String secManager, String clientAuthPropName) throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(secManager);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put(clientAuthPropName, true);
        server.getConfiguration().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        server.start();
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory cf = this.createSessionFactory(locator);
        try {
            ClientSession session = cf.createSession();
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testJAASSecurityManagerAuthenticationWithCertsAndOpenWire() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("CertLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        server.getConfiguration().setResolveProtocols(true).addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", false, true, false, false, true, true, false, false, true, false, false, false));
        server.getConfiguration().putSecurityRoles("ActiveMQ.Advisory.#", roles);
        server.start();
        ActiveMQSslConnectionFactory factory = new ActiveMQSslConnectionFactory("ssl://localhost:61616?verifyHostName=false");
        factory.setTrustStore("server-ca-truststore.jks");
        factory.setTrustStorePassword("securepass");
        factory.setKeyStore("client-keystore.jks");
        factory.setKeyStorePassword("securepass");
        try (ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();){
            Session session = connection.createSession(false, 1);
            session.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testJAASSecurityManagerOpenWireNegative() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("CertLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", false, false, false, false, false, false, false, false, false, false, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        server.getConfiguration().setResolveProtocols(true).addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        server.start();
        ActiveMQSslConnectionFactory factory = new ActiveMQSslConnectionFactory("ssl://localhost:61616?verifyHostName=false");
        factory.setTrustStore("server-ca-truststore.jks");
        factory.setTrustStorePassword("securepass");
        factory.setKeyStore("client-keystore.jks");
        factory.setKeyStorePassword("securepass");
        factory.setWatchTopicAdvisories(false);
        try (ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();){
            Session session = connection.createSession(false, 1);
            SimpleString address = SimpleString.of((String)"test.queue");
            server.addAddressInfo(new AddressInfo(address, RoutingType.ANYCAST));
            SimpleString address2 = SimpleString.of((String)"test.topic");
            server.addAddressInfo(new AddressInfo(address2, RoutingType.MULTICAST));
            try {
                session.createConsumer((Destination)session.createQueue("test.queue"));
                Assertions.fail((String)"should throw exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
                Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='CREATE_DURABLE_QUEUE' for queue test.queue on address test.queue"));
            }
            try {
                session.createConsumer((Destination)session.createTopic("test.topic"));
                Assertions.fail((String)"should throw exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
                Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='CREATE_NON_DURABLE_QUEUE'"));
            }
            server.createQueue(QueueConfiguration.of((SimpleString)address).setRoutingType(RoutingType.ANYCAST));
            try {
                MessageProducer producer = session.createProducer((Destination)session.createQueue("test.queue"));
                producer.send(session.createMessage());
                Assertions.fail((String)"should throw exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
                Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='SEND'"));
            }
            try {
                session.createConsumer((Destination)session.createQueue("test.queue"));
                Assertions.fail((String)"should throw exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
                Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='CONSUME' for queue test.queue on address test.queue"));
            }
            try {
                QueueBrowser browser = session.createBrowser(session.createQueue("test.queue"));
                browser.getEnumeration();
                Assertions.fail((String)"should throw exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
                Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='BROWSE' for queue test.queue on address test.queue"));
            }
            try {
                connection.destroyDestination((ActiveMQDestination)new ActiveMQQueue("test.queue"));
                Assertions.fail((String)"should throw exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
                Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='DELETE_DURABLE_QUEUE' for queue test.queue on address test.queue"));
            }
            try {
                session.createTemporaryQueue();
                Assertions.fail((String)"should throw exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
                Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='CREATE_ADDRESS'"));
            }
            try {
                session.createTemporaryTopic();
                Assertions.fail((String)"should throw exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
                Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='CREATE_ADDRESS'"));
            }
            session.close();
        }
    }

    @Test
    public void testJAASSecurityManagerAuthenticationBadPassword() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            cf.createSession("first", "badpassword", false, true, true, false, 0);
            Assertions.fail((String)"should throw exception here");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testJAASSecurityManagerAuthenticationWithBadClientCert() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("CertLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        server.getConfiguration().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        server.start();
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "unknown-client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory cf = this.createSessionFactory(locator);
        try {
            cf.createSession();
            Assertions.fail((String)"Creating session here should fail due to authentication error.");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((e.getType() == ActiveMQExceptionType.SECURITY_EXCEPTION ? (byte)1 : 0) != 0);
        }
    }

    @Test
    public void testJAASSecurityManagerAuthenticationGuest() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("GuestLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            ClientSession session = cf.createSession("first", "secret", false, true, true, false, 0);
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testJAASSecurityManagerAuthorizationNegative() throws Exception {
        ClientProducer producer;
        SimpleString ADDRESS = SimpleString.of((String)"address");
        SimpleString DURABLE_QUEUE = SimpleString.of((String)"durableQueue");
        SimpleString NON_DURABLE_QUEUE = SimpleString.of((String)"nonDurableQueue");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", false, false, false, false, false, false, false, false, false, false, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((SimpleString)NON_DURABLE_QUEUE).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(cf.createSession("first", "secret", false, true, true, false, 0));
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
            Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='CREATE_DURABLE_QUEUE' for queue durableQueue on address address"));
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
            Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='DELETE_DURABLE_QUEUE' for queue durableQueue on address address"));
        }
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
            Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='CREATE_NON_DURABLE_QUEUE' for queue nonDurableQueue on address address"));
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
            Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='DELETE_NON_DURABLE_QUEUE' for queue nonDurableQueue on address address"));
        }
        try {
            producer = session.createProducer(ADDRESS);
            producer.send((Message)session.createMessage(true));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
            Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='SEND' on address address"));
        }
        try {
            ClientConsumer consumer = session.createConsumer(DURABLE_QUEUE);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
            Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='CONSUME' for queue durableQueue on address address"));
        }
        try {
            producer = session.createProducer(server.getConfiguration().getManagementAddress());
            producer.send((Message)session.createMessage(true));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
            Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='MANAGE' on address activemq.management"));
        }
        try {
            ClientConsumer browser = session.createConsumer(DURABLE_QUEUE, true);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("User: first"));
            Assertions.assertTrue((boolean)e.getMessage().contains("does not have permission='BROWSE' for queue durableQueue on address address"));
        }
    }

    @Test
    public void testJAASSecurityManagerAuthorizationSameAddressDifferentQueuesDotSyntax() throws Exception {
        this.internalJAASSecurityManagerAuthorizationSameAddressDifferentQueues(false);
    }

    @Test
    public void testJAASSecurityManagerAuthorizationSameAddressDifferentQueuesFqqnSyntax() throws Exception {
        this.internalJAASSecurityManagerAuthorizationSameAddressDifferentQueues(true);
    }

    private void internalJAASSecurityManagerAuthorizationSameAddressDifferentQueues(boolean fqqnSyntax) throws Exception {
        ClientConsumer consumer;
        SimpleString ADDRESS = SimpleString.of((String)"address");
        SimpleString QUEUE_A = SimpleString.of((String)"a");
        SimpleString QUEUE_B = SimpleString.of((String)"b");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashSet<Role> aRoles = new HashSet<Role>();
        aRoles.add(new Role(QUEUE_A.toString(), false, true, false, false, false, false, false, false, false, false, false, false));
        if (fqqnSyntax) {
            server.getConfiguration().putSecurityRoles(CompositeAddress.toFullyQualified((SimpleString)ADDRESS, (SimpleString)QUEUE_A).toString(), aRoles);
        } else {
            server.getConfiguration().putSecurityRoles(ADDRESS.concat(".").concat(QUEUE_A).toString(), aRoles);
        }
        HashSet<Role> bRoles = new HashSet<Role>();
        bRoles.add(new Role(QUEUE_B.toString(), false, true, false, false, false, false, false, false, false, false, false, false));
        if (fqqnSyntax) {
            server.getConfiguration().putSecurityRoles(CompositeAddress.toFullyQualified((SimpleString)ADDRESS, (SimpleString)QUEUE_B).toString(), bRoles);
        } else {
            server.getConfiguration().putSecurityRoles(ADDRESS.concat(".").concat(QUEUE_B).toString(), bRoles);
        }
        server.start();
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((SimpleString)QUEUE_A).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((SimpleString)QUEUE_B).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession aSession = this.addClientSession(cf.createSession("a", "a", false, true, true, false, 0));
        ClientSession bSession = this.addClientSession(cf.createSession("b", "b", false, true, true, false, 0));
        try {
            ClientConsumer clientConsumer = aSession.createConsumer(QUEUE_A);
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            consumer = bSession.createConsumer(QUEUE_A);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQSecurityException));
        }
        try {
            ClientConsumer e = bSession.createConsumer(QUEUE_B);
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            consumer = aSession.createConsumer(QUEUE_B);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQSecurityException));
        }
    }

    @Test
    public void testFallbackConsumerAuthorization() throws Exception {
        SimpleString ADDRESS = SimpleString.of((String)"a.c.b");
        SimpleString QUEUE = SimpleString.of((String)"a.c.b");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashSet<Role> aRoles = new HashSet<Role>();
        aRoles.add(new Role("xyz", true, true, true, true, true, true, true, true, true, true, false, false));
        server.getConfiguration().putSecurityRoles("a.*.b", aRoles);
        HashSet<Role> bRoles = new HashSet<Role>();
        bRoles.add(new Role("amq", true, true, true, true, true, true, true, true, true, true, false, false));
        server.getConfiguration().putSecurityRoles("#", bRoles);
        server.start();
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((SimpleString)QUEUE).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(cf.createSession("x", "x", false, true, true, false, 0));
        try {
            session.createConsumer(QUEUE);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQSecurityException));
        }
    }

    @Test
    public void testJAASSecurityManagerFQQNAuthorizationWithJMS() throws Exception {
        SimpleString ADDRESS = SimpleString.of((String)"address");
        SimpleString QUEUE_A = SimpleString.of((String)"a");
        SimpleString QUEUE_B = SimpleString.of((String)"b");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashSet<Role> aRoles = new HashSet<Role>();
        aRoles.add(new Role(QUEUE_A.toString(), false, true, true, false, false, false, false, false, true, false, false, false));
        server.getConfiguration().putSecurityRoles(CompositeAddress.toFullyQualified((SimpleString)ADDRESS, (SimpleString)QUEUE_A).toString(), aRoles);
        HashSet<Role> bRoles = new HashSet<Role>();
        bRoles.add(new Role(QUEUE_B.toString(), false, true, true, false, false, false, false, false, true, false, false, false));
        server.getConfiguration().putSecurityRoles(CompositeAddress.toFullyQualified((SimpleString)ADDRESS, (SimpleString)QUEUE_B).toString(), bRoles);
        server.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://0");
        Connection aConnection = cf.createConnection("a", "a");
        Session aSession = aConnection.createSession();
        Connection bConnection = cf.createConnection("b", "b");
        Session bSession = bConnection.createSession();
        jakarta.jms.Queue queueA = aSession.createQueue(CompositeAddress.toFullyQualified((SimpleString)ADDRESS, (SimpleString)QUEUE_A).toString());
        jakarta.jms.Queue queueB = bSession.createQueue(CompositeAddress.toFullyQualified((SimpleString)ADDRESS, (SimpleString)QUEUE_B).toString());
        try {
            aSession.createConsumer((Destination)queueA);
        }
        catch (JMSException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            bSession.createConsumer((Destination)queueA);
            Assertions.fail((String)"should throw exception here");
        }
        catch (JMSException e) {
            Assertions.assertTrue((boolean)(e instanceof JMSSecurityException));
        }
        try {
            bSession.createConsumer((Destination)queueB);
        }
        catch (JMSException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            aSession.createConsumer((Destination)queueB);
            Assertions.fail((String)"should throw exception here");
        }
        catch (JMSException e) {
            Assertions.assertTrue((boolean)(e instanceof JMSSecurityException));
        }
        aConnection.close();
        bConnection.close();
    }

    @Test
    public void testJAASSecurityManagerAuthorizationNegativeWithCerts() throws Exception {
        ClientProducer producer2;
        SimpleString ADDRESS = SimpleString.of((String)"address");
        SimpleString DURABLE_QUEUE = SimpleString.of((String)"durableQueue");
        SimpleString NON_DURABLE_QUEUE = SimpleString.of((String)"nonDurableQueue");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("CertLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        server.getConfiguration().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", false, false, false, false, false, false, false, false, false, false, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory cf = this.createSessionFactory(locator);
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((SimpleString)NON_DURABLE_QUEUE).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        ClientSession session = this.addClientSession(cf.createSession());
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        try {
            producer2 = session.createProducer(ADDRESS);
            producer2.send((Message)session.createMessage(true));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException producer2) {
            // empty catch block
        }
        try {
            ClientConsumer consumer = session.createConsumer(DURABLE_QUEUE);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException consumer) {
            // empty catch block
        }
        try {
            producer2 = session.createProducer(server.getConfiguration().getManagementAddress());
            producer2.send((Message)session.createMessage(true));
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException producer3) {
            // empty catch block
        }
        try {
            ClientConsumer browser = session.createConsumer(DURABLE_QUEUE, true);
            Assertions.fail((String)"should throw exception here");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
    }

    @Test
    public void testJAASSecurityManagerAuthorizationPositive() throws Exception {
        ClientProducer producer;
        SimpleString ADDRESS = SimpleString.of((String)"address");
        SimpleString DURABLE_QUEUE = SimpleString.of((String)"durableQueue");
        SimpleString NON_DURABLE_QUEUE = SimpleString.of((String)"nonDurableQueue");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", true, true, true, true, true, true, true, true, true, true, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(cf.createSession("first", "secret", false, true, true, false, 0));
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        session.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS));
        try {
            producer = session.createProducer(ADDRESS);
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            producer = session.createProducer(server.getConfiguration().getManagementAddress());
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE, true);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
    }

    @Test
    public void testJAASSecurityManagerAuthorizationPositiveWithCerts() throws Exception {
        this.testJAASSecurityManagerAuthorizationPositiveWithCerts("needClientAuth");
    }

    @Test
    public void testJAASSecurityManagerAuthorizationPositiveWithCertsWantClientAuth() throws Exception {
        this.testJAASSecurityManagerAuthorizationPositiveWithCerts("wantClientAuth");
    }

    protected void testJAASSecurityManagerAuthorizationPositiveWithCerts(String clientAuthPropName) throws Exception {
        ClientProducer producer;
        SimpleString ADDRESS = SimpleString.of((String)"address");
        SimpleString DURABLE_QUEUE = SimpleString.of((String)"durableQueue");
        SimpleString NON_DURABLE_QUEUE = SimpleString.of((String)"nonDurableQueue");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("CertLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put(clientAuthPropName, true);
        server.getConfiguration().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", true, true, true, true, true, true, true, true, true, true, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(cf.createSession());
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        session.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS));
        try {
            producer = session.createProducer(ADDRESS);
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            producer = session.createProducer(server.getConfiguration().getManagementAddress());
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE, true);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
    }

    @Test
    public void testJAASSecurityManagerAuthorizationPositiveGuest() throws Exception {
        ClientProducer producer;
        SimpleString ADDRESS = SimpleString.of((String)"address");
        SimpleString DURABLE_QUEUE = SimpleString.of((String)"durableQueue");
        SimpleString NON_DURABLE_QUEUE = SimpleString.of((String)"nonDurableQueue");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("GuestLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("bar", true, true, true, true, true, true, true, false, true, true, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(cf.createSession("junk", "junk", false, true, true, false, 0));
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS));
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        session.createQueue(QueueConfiguration.of((SimpleString)DURABLE_QUEUE).setAddress(ADDRESS));
        try {
            producer = session.createProducer(ADDRESS);
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
        try {
            producer = session.createProducer(server.getConfiguration().getManagementAddress());
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception here");
        }
    }

    @Test
    public void testCreateSessionWithNullUserPass() throws Exception {
        ActiveMQServer server = this.createServer();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("guest", "guest");
        securityManager.getConfiguration().setDefaultUser("guest");
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            ClientSession session = cf.createSession(false, true, true);
            session.close();
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception");
        }
    }

    private ActiveMQServer createServer() throws Exception {
        this.configuration = this.createDefaultInVMConfig().setSecurityEnabled(true);
        ActiveMQServer server = this.createServer(false, this.configuration);
        return server;
    }

    @Test
    public void testCreateSessionWithNullUserPassNoGuest() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            cf.createSession(false, true, true);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    public void testCreateSessionWithCorrectUserWrongPass() throws Exception {
        ActiveMQServer server = this.createServer();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("newuser", "apass");
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            cf.createSession("newuser", "awrongpass", false, true, true, false, -1);
            Assertions.fail((String)"should not throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    public void testCreateSessionWithCorrectUserCorrectPass() throws Exception {
        ActiveMQServer server = this.createServer();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("newuser", "apass");
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            ClientSession session = cf.createSession("newuser", "apass", false, true, true, false, -1);
            session.close();
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testCreateDurableQueueWithRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, true, false, false, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        session.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        session.close();
    }

    @Test
    public void testCreateDurableQueueWithoutRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, false, false, false, false, false, false, false, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        try {
            session.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
    }

    @Test
    public void testDeleteDurableQueueWithRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, true, true, false, false, false, false, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        session.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        session.deleteQueue(queueA);
        session.close();
    }

    @Test
    public void testDeleteDurableQueueWithoutRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, true, false, false, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        session.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        try {
            session.deleteQueue(queueA);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
    }

    @Test
    public void testCreateTempQueueWithRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, false, false, true, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        session.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA).setDurable(Boolean.valueOf(false)));
        session.close();
    }

    @Test
    public void testCreateTempQueueWithoutRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, false, false, false, false, false, false, false, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        try {
            session.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA).setDurable(Boolean.valueOf(false)));
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
    }

    @Test
    public void testDeleteTempQueueWithRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, false, false, true, true, false, false, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        session.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA).setDurable(Boolean.valueOf(false)));
        session.deleteQueue(queueA);
        session.close();
    }

    @Test
    public void testDeleteTempQueueWithoutRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, false, false, true, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        session.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA).setDurable(Boolean.valueOf(false)));
        try {
            session.deleteQueue(queueA);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
    }

    @Test
    public void testSendWithRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", true, true, true, false, false, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        this.locator.setBlockOnNonDurableSend(true);
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        session.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        ClientProducer cp = session.createProducer(addressA);
        cp.send((Message)session.createMessage(false));
        session.start();
        ClientConsumer cons = session.createConsumer(queueA);
        ClientMessage receivedMessage = cons.receive(5000L);
        Assertions.assertNotNull((Object)receivedMessage);
        receivedMessage.acknowledge();
        role = new Role("arole", false, false, true, false, false, false, false, false, false, false, false, false);
        roles = new HashSet();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        boolean failed = false;
        try {
            cp.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            failed = true;
        }
        Assertions.assertTrue((boolean)failed, (String)"Failure expected on send after removing the match");
    }

    @Test
    public void testSendWithoutRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, true, false, false, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        this.locator.setBlockOnNonDurableSend(true);
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        session.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        ClientProducer cp = session.createProducer(addressA);
        try {
            cp.send((Message)session.createMessage(false));
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
    }

    @Test
    public void testNonBlockSendWithoutRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, true, false, false, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        session.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        ClientProducer cp = session.createProducer(addressA);
        cp.send((Message)session.createMessage(false));
        session.close();
        Queue binding = (Queue)server.getPostOffice().getBinding(SimpleString.of((String)queueA)).getBindable();
        Assertions.assertEquals((int)0, (int)this.getMessageCount(binding));
    }

    @Test
    public void testCreateConsumerWithRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        securityManager.getConfiguration().addUser("guest", "guest");
        securityManager.getConfiguration().addRole("guest", "guest");
        securityManager.getConfiguration().setDefaultUser("guest");
        Role role = new Role("arole", false, true, false, false, false, false, false, false, false, false, false, false);
        Role sendRole = new Role("guest", true, false, true, false, false, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(sendRole);
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession senSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        senSession.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        ClientProducer cp = senSession.createProducer(addressA);
        cp.send((Message)session.createMessage(false));
        session.createConsumer(queueA);
        session.close();
        senSession.close();
    }

    @Test
    public void testCreateConsumerWithoutRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        securityManager.getConfiguration().addUser("guest", "guest");
        securityManager.getConfiguration().addRole("guest", "guest");
        securityManager.getConfiguration().setDefaultUser("guest");
        Role role = new Role("arole", false, false, false, false, false, false, false, false, false, false, false, false);
        Role sendRole = new Role("guest", true, false, true, false, false, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(sendRole);
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession senSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        senSession.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        ClientProducer cp = senSession.createProducer(addressA);
        cp.send((Message)session.createMessage(false));
        try {
            session.createConsumer(queueA);
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
        senSession.close();
    }

    @Test
    public void testSendMessageUpdateRoleCached() throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().setSecurityEnabled(true).setSecurityInvalidationInterval(10000L);
        ActiveMQServer server = this.createServer(false, configuration);
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        securityManager.getConfiguration().addUser("guest", "guest");
        securityManager.getConfiguration().addRole("guest", "guest");
        securityManager.getConfiguration().setDefaultUser("guest");
        Role role = new Role("arole", false, false, false, false, false, false, false, false, false, false, false, false);
        Role sendRole = new Role("guest", true, false, true, false, false, false, false, false, true, false, false, false);
        Role receiveRole = new Role("receiver", false, true, false, false, false, false, false, false, false, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(sendRole);
        roles.add(role);
        roles.add(receiveRole);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession senSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        senSession.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        ClientProducer cp = senSession.createProducer(addressA);
        cp.send((Message)session.createMessage(false));
        try {
            session.createConsumer(queueA);
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        securityManager.getConfiguration().addRole("auser", "receiver");
        ((SecurityStoreImpl)server.getSecurityStore()).invalidateAuthenticationCache();
        session.createConsumer(queueA);
        securityManager.getConfiguration().removeRole("auser", "receiver");
        session.createConsumer(queueA);
        session.close();
        senSession.close();
    }

    @Test
    public void testSendMessageUpdateRoleCached2() throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().setSecurityEnabled(true).setSecurityInvalidationInterval(0L);
        ActiveMQServer server = this.createServer(false, configuration);
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        securityManager.getConfiguration().addUser("guest", "guest");
        securityManager.getConfiguration().addRole("guest", "guest");
        securityManager.getConfiguration().setDefaultUser("guest");
        Role role = new Role("arole", false, false, false, false, false, false, false, false, false, false, false, false);
        Role sendRole = new Role("guest", true, false, true, false, false, false, false, false, true, false, false, false);
        Role receiveRole = new Role("receiver", false, true, false, false, false, false, false, false, false, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(sendRole);
        roles.add(role);
        roles.add(receiveRole);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession senSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        senSession.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        ClientProducer cp = senSession.createProducer(addressA);
        cp.send((Message)session.createMessage(false));
        try {
            session.createConsumer(queueA);
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        securityManager.getConfiguration().addRole("auser", "receiver");
        session.createConsumer(queueA);
        securityManager.getConfiguration().removeRole("auser", "receiver");
        try {
            session.createConsumer(queueA);
        }
        catch (ActiveMQSecurityException e) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
        senSession.close();
    }

    @Test
    public void testSendMessageUpdateSender() throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().setSecurityEnabled(true).setSecurityInvalidationInterval(1000L);
        ActiveMQServer server = this.createServer(false, configuration);
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        securityManager.getConfiguration().addUser("guest", "guest");
        securityManager.getConfiguration().addRole("guest", "guest");
        securityManager.getConfiguration().setDefaultUser("guest");
        Role role = new Role("arole", false, false, false, false, false, false, false, false, false, false, false, false);
        Role sendRole = new Role("guest", true, false, true, false, false, false, false, false, true, false, false, false);
        Role receiveRole = new Role("receiver", false, true, false, false, false, false, false, false, false, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(sendRole);
        roles.add(role);
        roles.add(receiveRole);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession senSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        senSession.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        ClientProducer cp = senSession.createProducer(addressA);
        cp.send((Message)session.createMessage(false));
        try {
            session.createConsumer(queueA);
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        securityManager.getConfiguration().addRole("auser", "receiver");
        Wait.assertTrue(() -> {
            try {
                session.createConsumer(queueA);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)2000L, (long)100L);
        securityManager.getConfiguration().removeRole("auser", "guest");
        ClientSession sendingSession = cf.createSession("auser", "pass", false, false, false, false, 0);
        ClientProducer prod = sendingSession.createProducer(addressA);
        prod.send((Message)SecurityTest.createClientMessage(sendingSession, "Test", true));
        prod.send((Message)SecurityTest.createClientMessage(sendingSession, "Test", true));
        try {
            sendingSession.commit();
            Assertions.fail((String)"Expected exception");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        sendingSession.close();
        XidImpl xid = this.newXID();
        sendingSession = cf.createSession("auser", "pass", true, false, false, false, 0);
        sendingSession.start((Xid)xid, 0);
        prod = sendingSession.createProducer(addressA);
        prod.send((Message)SecurityTest.createClientMessage(sendingSession, "Test", true));
        prod.send((Message)SecurityTest.createClientMessage(sendingSession, "Test", true));
        sendingSession.end((Xid)xid, 0x4000000);
        try {
            sendingSession.prepare((Xid)xid);
            Assertions.fail((String)"Exception was expected");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Xid[] xids = sendingSession.recover(0x1000000);
        Assertions.assertEquals((int)0, (int)xids.length);
        session.close();
        senSession.close();
        sendingSession.close();
    }

    private static ClientMessage createClientMessage(ClientSession session, String s, boolean durable) {
        ClientMessage message = session.createMessage((byte)3, durable, 0L, System.currentTimeMillis(), (byte)1);
        message.getBodyBuffer().writeString(s);
        return message;
    }

    @Test
    public void testSendManagementWithRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, false, false, false, false, true, false, false, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(this.configuration.getManagementAddress().toString(), roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        this.locator.setBlockOnNonDurableSend(true);
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        ClientProducer cp = session.createProducer(this.configuration.getManagementAddress());
        cp.send((Message)session.createMessage(false));
        session.close();
    }

    @Test
    public void testSendManagementWithoutRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, true, false, false, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(this.configuration.getManagementAddress().toString(), roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        session.createQueue(QueueConfiguration.of((String)queueA).setAddress(this.configuration.getManagementAddress().toString()));
        ClientProducer cp = session.createProducer(this.configuration.getManagementAddress());
        cp.send((Message)session.createMessage(false));
        try {
            cp.send((Message)session.createMessage(false));
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
    }

    @Test
    public void testNonBlockSendManagementWithoutRole() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", false, false, true, false, false, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(this.configuration.getManagementAddress().toString(), roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        session.createQueue(QueueConfiguration.of((String)queueA).setAddress(this.configuration.getManagementAddress().toString()));
        ClientProducer cp = session.createProducer(this.configuration.getManagementAddress());
        cp.send((Message)session.createMessage(false));
        session.close();
        Queue binding = (Queue)server.getPostOffice().getBinding(SimpleString.of((String)queueA)).getBindable();
        Assertions.assertEquals((int)0, (int)this.getMessageCount(binding));
    }

    @Test
    public void testComplexRoles() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("all", "all");
        securityManager.getConfiguration().addUser("bill", "activemq");
        securityManager.getConfiguration().addUser("andrew", "activemq1");
        securityManager.getConfiguration().addUser("frank", "activemq2");
        securityManager.getConfiguration().addUser("sam", "activemq3");
        securityManager.getConfiguration().addRole("all", "all");
        securityManager.getConfiguration().addRole("bill", "user");
        securityManager.getConfiguration().addRole("andrew", "europe-user");
        securityManager.getConfiguration().addRole("andrew", "user");
        securityManager.getConfiguration().addRole("frank", "us-user");
        securityManager.getConfiguration().addRole("frank", "news-user");
        securityManager.getConfiguration().addRole("frank", "user");
        securityManager.getConfiguration().addRole("sam", "news-user");
        securityManager.getConfiguration().addRole("sam", "user");
        Role all = new Role("all", true, true, true, true, true, true, true, true, true, true, false, false);
        HierarchicalRepository repository = server.getSecurityRepository();
        HashSet<Role> add = new HashSet<Role>();
        add.add(new Role("user", true, true, true, true, true, true, false, true, true, true, false, false));
        add.add(all);
        repository.addMatch("#", add);
        HashSet<Role> add1 = new HashSet<Role>();
        add1.add(all);
        add1.add(new Role("user", false, false, true, true, true, true, false, true, true, true, false, false));
        add1.add(new Role("europe-user", true, false, false, false, false, false, false, true, true, true, false, false));
        add1.add(new Role("news-user", false, true, false, false, false, false, false, true, true, true, false, false));
        repository.addMatch("news.europe.#", add1);
        HashSet<Role> add2 = new HashSet<Role>();
        add2.add(all);
        add2.add(new Role("user", false, false, true, true, true, true, false, true, true, true, false, false));
        add2.add(new Role("us-user", true, false, false, false, false, false, false, true, true, true, false, false));
        add2.add(new Role("news-user", false, true, false, false, false, false, false, true, true, true, false, false));
        repository.addMatch("news.us.#", add2);
        ClientSession billConnection = null;
        ClientSession andrewConnection = null;
        ClientSession frankConnection = null;
        ClientSession samConnection = null;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        ClientSessionFactory factory = this.createSessionFactory(this.locator);
        ClientSession adminSession = factory.createSession("all", "all", false, true, true, false, -1);
        String genericQueueName = "genericQueue";
        adminSession.createQueue(QueueConfiguration.of((String)genericQueueName).setDurable(Boolean.valueOf(false)));
        String eurQueueName = "news.europe.europeQueue";
        adminSession.createQueue(QueueConfiguration.of((String)eurQueueName).setDurable(Boolean.valueOf(false)));
        String usQueueName = "news.us.usQueue";
        adminSession.createQueue(QueueConfiguration.of((String)usQueueName).setDurable(Boolean.valueOf(false)));
        try {
            factory.createSession(false, true, true);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            billConnection = factory.createSession("bill", "activemq1", false, true, true, false, -1);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException e) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        billConnection = factory.createSession("bill", "activemq", false, true, true, false, -1);
        andrewConnection = factory.createSession("andrew", "activemq1", false, true, true, false, -1);
        frankConnection = factory.createSession("frank", "activemq2", false, true, true, false, -1);
        samConnection = factory.createSession("sam", "activemq3", false, true, true, false, -1);
        this.checkUserSendAndReceive(genericQueueName, billConnection);
        this.checkUserSendAndReceive(genericQueueName, andrewConnection);
        this.checkUserSendAndReceive(genericQueueName, frankConnection);
        this.checkUserSendAndReceive(genericQueueName, samConnection);
        this.checkUserNoSendNoReceive(eurQueueName, billConnection, adminSession);
        this.checkUserSendNoReceive(eurQueueName, andrewConnection);
        this.checkUserReceiveNoSend(eurQueueName, frankConnection, adminSession);
        this.checkUserReceiveNoSend(eurQueueName, samConnection, adminSession);
        this.checkUserNoSendNoReceive(usQueueName, billConnection, adminSession);
        this.checkUserNoSendNoReceive(usQueueName, andrewConnection, adminSession);
        this.checkUserSendAndReceive(usQueueName, frankConnection);
        this.checkUserReceiveNoSend(usQueueName, samConnection, adminSession);
        billConnection.close();
        andrewConnection.close();
        frankConnection.close();
        samConnection.close();
        adminSession.close();
    }

    @Test
    @Disabled
    public void testComplexRoles2() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("all", "all");
        securityManager.getConfiguration().addUser("bill", "activemq");
        securityManager.getConfiguration().addUser("andrew", "activemq1");
        securityManager.getConfiguration().addUser("frank", "activemq2");
        securityManager.getConfiguration().addUser("sam", "activemq3");
        securityManager.getConfiguration().addRole("all", "all");
        securityManager.getConfiguration().addRole("bill", "user");
        securityManager.getConfiguration().addRole("andrew", "europe-user");
        securityManager.getConfiguration().addRole("andrew", "user");
        securityManager.getConfiguration().addRole("frank", "us-user");
        securityManager.getConfiguration().addRole("frank", "news-user");
        securityManager.getConfiguration().addRole("frank", "user");
        securityManager.getConfiguration().addRole("sam", "news-user");
        securityManager.getConfiguration().addRole("sam", "user");
        Role all = new Role("all", true, true, true, true, true, true, true, true, true, true, false, false);
        HierarchicalRepository repository = server.getSecurityRepository();
        HashSet<Role> add = new HashSet<Role>();
        add.add(new Role("user", true, true, true, true, true, true, false, true, true, true, false, false));
        add.add(all);
        repository.addMatch("#", add);
        HashSet<Role> add1 = new HashSet<Role>();
        add1.add(all);
        add1.add(new Role("user", false, false, true, true, true, true, false, true, true, true, false, false));
        add1.add(new Role("europe-user", true, false, false, false, false, false, false, true, true, true, false, false));
        add1.add(new Role("news-user", false, true, false, false, false, false, false, true, true, true, false, false));
        repository.addMatch("news.europe.#", add1);
        HashSet<Role> add2 = new HashSet<Role>();
        add2.add(all);
        add2.add(new Role("user", false, false, true, true, true, true, false, true, true, true, false, false));
        add2.add(new Role("us-user", true, false, false, false, false, false, false, true, true, true, false, false));
        add2.add(new Role("news-user", false, true, false, false, false, false, false, true, true, true, false, false));
        repository.addMatch("news.us.#", add2);
        ClientSession billConnection = null;
        ClientSession andrewConnection = null;
        ClientSession frankConnection = null;
        ClientSession samConnection = null;
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        ClientSessionFactory factory = this.createSessionFactory(this.locator);
        ClientSession adminSession = factory.createSession("all", "all", false, true, true, false, -1);
        String genericQueueName = "genericQueue";
        adminSession.createQueue(QueueConfiguration.of((String)genericQueueName).setDurable(Boolean.valueOf(false)));
        String eurQueueName = "news.europe.europeQueue";
        adminSession.createQueue(QueueConfiguration.of((String)eurQueueName).setDurable(Boolean.valueOf(false)));
        String usQueueName = "news.us.usQueue";
        adminSession.createQueue(QueueConfiguration.of((String)usQueueName).setDurable(Boolean.valueOf(false)));
        try {
            factory.createSession(false, true, true);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            billConnection = factory.createSession("bill", "activemq1", false, true, true, false, -1);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException e) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        billConnection = factory.createSession("bill", "activemq", false, true, true, false, -1);
        andrewConnection = factory.createSession("andrew", "activemq1", false, true, true, false, -1);
        frankConnection = factory.createSession("frank", "activemq2", false, true, true, false, -1);
        samConnection = factory.createSession("sam", "activemq3", false, true, true, false, -1);
        this.checkUserSendAndReceive(genericQueueName, billConnection);
        this.checkUserSendAndReceive(genericQueueName, andrewConnection);
        this.checkUserSendAndReceive(genericQueueName, frankConnection);
        this.checkUserSendAndReceive(genericQueueName, samConnection);
        this.checkUserNoSendNoReceive(eurQueueName, billConnection, adminSession);
        this.checkUserSendNoReceive(eurQueueName, andrewConnection);
        this.checkUserReceiveNoSend(eurQueueName, frankConnection, adminSession);
        this.checkUserReceiveNoSend(eurQueueName, samConnection, adminSession);
        this.checkUserNoSendNoReceive(usQueueName, billConnection, adminSession);
        this.checkUserNoSendNoReceive(usQueueName, andrewConnection, adminSession);
        this.checkUserSendAndReceive(usQueueName, frankConnection);
        this.checkUserReceiveNoSend(usQueueName, samConnection, adminSession);
    }

    @Test
    public void testCustomSecurityManager() throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().setSecurityEnabled(true);
        ActiveMQSecurityManager customSecurityManager = new ActiveMQSecurityManager(){

            public boolean validateUser(String username, String password) {
                return (username.equals("foo") || username.equals("bar") || username.equals("all")) && password.equals("frobnicate");
            }

            public boolean validateUserAndRole(String username, String password, Set<Role> requiredRoles, CheckType checkType) {
                if ((username.equals("foo") || username.equals("bar") || username.equals("all")) && password.equals("frobnicate")) {
                    if (username.equals("all")) {
                        return true;
                    }
                    if (username.equals("foo")) {
                        return checkType == CheckType.CONSUME || checkType == CheckType.CREATE_NON_DURABLE_QUEUE;
                    }
                    if (username.equals("bar")) {
                        return checkType == CheckType.SEND || checkType == CheckType.CREATE_NON_DURABLE_QUEUE;
                    }
                    return false;
                }
                return false;
            }
        };
        ActiveMQServer server = this.addServer((ActiveMQServer)new ActiveMQServerImpl(configuration, customSecurityManager));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession adminSession = factory.createSession("all", "frobnicate", false, true, true, false, -1);
        String queueName = "test.queue";
        adminSession.createQueue(QueueConfiguration.of((String)"test.queue").setDurable(Boolean.valueOf(false)));
        try {
            factory.createSession("baz", "frobnicate", false, true, true, false, -1);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            factory.createSession("foo", "xxx", false, true, true, false, -1);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException e) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        ClientSession session = factory.createSession("foo", "frobnicate", false, true, true, false, -1);
        this.checkUserReceiveNoSend("test.queue", session, adminSession);
        session = factory.createSession("bar", "frobnicate", false, true, true, false, -1);
        this.checkUserSendNoReceive("test.queue", session);
    }

    @Test
    public void testCustomSecurityManager2() throws Exception {
        ClientSession session2;
        Configuration configuration = this.createDefaultInVMConfig().setSecurityEnabled(true);
        ActiveMQSecurityManager2 customSecurityManager = new ActiveMQSecurityManager2(){

            public boolean validateUser(String username, String password) {
                Assertions.fail((String)"Unexpected call to overridden method");
                return false;
            }

            public boolean validateUser(String username, String password, X509Certificate[] certificates) {
                return (username.equals("foo") || username.equals("bar") || username.equals("all")) && password.equals("frobnicate");
            }

            public boolean validateUserAndRole(String username, String password, Set<Role> requiredRoles, CheckType checkType) {
                Assertions.fail((String)"Unexpected call to overridden method");
                return false;
            }

            public boolean validateUserAndRole(String username, String password, Set<Role> requiredRoles, CheckType checkType, String address, RemotingConnection connection) {
                if (!(connection.getTransportConnection() instanceof InVMConnection)) {
                    return false;
                }
                if ((username.equals("foo") || username.equals("bar") || username.equals("all")) && password.equals("frobnicate")) {
                    if (username.equals("all")) {
                        return true;
                    }
                    if (username.equals("foo")) {
                        return address.equals("test.queue") && checkType == CheckType.CONSUME;
                    }
                    if (username.equals("bar")) {
                        return address.equals("test.queue") && checkType == CheckType.SEND;
                    }
                    return false;
                }
                return false;
            }
        };
        ActiveMQServer server = this.addServer((ActiveMQServer)new ActiveMQServerImpl(configuration, (ActiveMQSecurityManager)customSecurityManager));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession adminSession = factory.createSession("all", "frobnicate", false, true, true, false, -1);
        String queueName = "test.queue";
        adminSession.createQueue(QueueConfiguration.of((String)"test.queue").setDurable(Boolean.valueOf(false)));
        String otherQueueName = "other.queue";
        adminSession.createQueue(QueueConfiguration.of((String)"other.queue").setDurable(Boolean.valueOf(false)));
        try {
            factory.createSession("baz", "frobnicate", false, true, true, false, -1);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            factory.createSession("foo", "xxx", false, true, true, false, -1);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException e) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            session2 = factory.createSession("foo", "frobnicate", false, true, true, false, -1);
            this.checkUserReceiveNoSend("other.queue", session2, adminSession);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException session2) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            session2 = factory.createSession("foo", "frobnicate", false, true, true, false, -1);
            this.checkUserReceiveNoSend("other.queue", session2, adminSession);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException session3) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session2 = factory.createSession("foo", "frobnicate", false, true, true, false, -1);
        this.checkUserReceiveNoSend("test.queue", session2, adminSession);
        session2 = factory.createSession("bar", "frobnicate", false, true, true, false, -1);
        this.checkUserSendNoReceive("test.queue", session2);
    }

    @Test
    public void testCustomSecurityManager3() throws Exception {
        ClientSession session2;
        Configuration configuration = this.createDefaultInVMConfig().setSecurityEnabled(true);
        ActiveMQSecurityManager3 customSecurityManager = new ActiveMQSecurityManager3(){

            public boolean validateUser(String username, String password) {
                Assertions.fail((String)"Unexpected call to overridden method");
                return false;
            }

            public String validateUser(String username, String password, RemotingConnection remotingConnection) {
                if ((username.equals("foo") || username.equals("bar") || username.equals("all")) && password.equals("frobnicate")) {
                    return username;
                }
                return null;
            }

            public boolean validateUserAndRole(String username, String password, Set<Role> requiredRoles, CheckType checkType) {
                Assertions.fail((String)"Unexpected call to overridden method");
                return false;
            }

            public String validateUserAndRole(String username, String password, Set<Role> requiredRoles, CheckType checkType, String address, RemotingConnection connection) {
                if (!(connection.getTransportConnection() instanceof InVMConnection)) {
                    return null;
                }
                if ((username.equals("foo") || username.equals("bar") || username.equals("all")) && password.equals("frobnicate")) {
                    if (username.equals("all")) {
                        return username;
                    }
                    if (username.equals("foo")) {
                        if (address.equals("test.queue") && checkType == CheckType.CONSUME) {
                            return username;
                        }
                        return null;
                    }
                    if (username.equals("bar")) {
                        if (address.equals("test.queue") && checkType == CheckType.SEND) {
                            return username;
                        }
                        return null;
                    }
                    return null;
                }
                return null;
            }
        };
        ActiveMQServer server = this.addServer((ActiveMQServer)new ActiveMQServerImpl(configuration, (ActiveMQSecurityManager)customSecurityManager));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession adminSession = factory.createSession("all", "frobnicate", false, true, true, false, -1);
        String queueName = "test.queue";
        adminSession.createQueue(QueueConfiguration.of((String)"test.queue").setDurable(Boolean.valueOf(false)));
        String otherQueueName = "other.queue";
        adminSession.createQueue(QueueConfiguration.of((String)"other.queue").setDurable(Boolean.valueOf(false)));
        try {
            factory.createSession("baz", "frobnicate", false, true, true, false, -1);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            factory.createSession("foo", "xxx", false, true, true, false, -1);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException e) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            session2 = factory.createSession("foo", "frobnicate", false, true, true, false, -1);
            this.checkUserReceiveNoSend("other.queue", session2, adminSession);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException session2) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            session2 = factory.createSession("foo", "frobnicate", false, true, true, false, -1);
            this.checkUserReceiveNoSend("other.queue", session2, adminSession);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException session3) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session2 = factory.createSession("foo", "frobnicate", false, true, true, false, -1);
        this.checkUserReceiveNoSend("test.queue", session2, adminSession);
        session2 = factory.createSession("bar", "frobnicate", false, true, true, false, -1);
        this.checkUserSendNoReceive("test.queue", session2);
    }

    @Test
    public void testCustomSecurityManager4() throws Exception {
        ClientSession session2;
        Configuration configuration = this.createDefaultInVMConfig().setSecurityEnabled(true);
        ActiveMQSecurityManager4 customSecurityManager = new ActiveMQSecurityManager4(){

            public boolean validateUser(String username, String password) {
                Assertions.fail((String)"Unexpected call to overridden method");
                return false;
            }

            public String validateUser(String username, String password, RemotingConnection remotingConnection, String securityDomain) {
                if ((username.equals("foo") || username.equals("bar") || username.equals("all")) && password.equals("frobnicate")) {
                    return username;
                }
                return null;
            }

            public boolean validateUserAndRole(String username, String password, Set<Role> requiredRoles, CheckType checkType) {
                Assertions.fail((String)"Unexpected call to overridden method");
                return false;
            }

            public String validateUserAndRole(String username, String password, Set<Role> requiredRoles, CheckType checkType, String address, RemotingConnection connection, String securityDomain) {
                if (!(connection.getTransportConnection() instanceof InVMConnection)) {
                    return null;
                }
                if ((username.equals("foo") || username.equals("bar") || username.equals("all")) && password.equals("frobnicate")) {
                    if (username.equals("all")) {
                        return username;
                    }
                    if (username.equals("foo")) {
                        if (address.equals("test.queue") && checkType == CheckType.CONSUME) {
                            return username;
                        }
                        return null;
                    }
                    if (username.equals("bar")) {
                        if (address.equals("test.queue") && checkType == CheckType.SEND) {
                            return username;
                        }
                        return null;
                    }
                    return null;
                }
                return null;
            }
        };
        ActiveMQServer server = this.addServer((ActiveMQServer)new ActiveMQServerImpl(configuration, (ActiveMQSecurityManager)customSecurityManager));
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession adminSession = factory.createSession("all", "frobnicate", false, true, true, false, -1);
        String queueName = "test.queue";
        adminSession.createQueue(QueueConfiguration.of((String)"test.queue").setDurable(Boolean.valueOf(false)));
        String otherQueueName = "other.queue";
        adminSession.createQueue(QueueConfiguration.of((String)"other.queue").setDurable(Boolean.valueOf(false)));
        try {
            factory.createSession("baz", "frobnicate", false, true, true, false, -1);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            factory.createSession("foo", "xxx", false, true, true, false, -1);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException e) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            session2 = factory.createSession("foo", "frobnicate", false, true, true, false, -1);
            this.checkUserReceiveNoSend("other.queue", session2, adminSession);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException session2) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            session2 = factory.createSession("foo", "frobnicate", false, true, true, false, -1);
            this.checkUserReceiveNoSend("other.queue", session2, adminSession);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException session3) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session2 = factory.createSession("foo", "frobnicate", false, true, true, false, -1);
        this.checkUserReceiveNoSend("test.queue", session2, adminSession);
        session2 = factory.createSession("bar", "frobnicate", false, true, true, false, -1);
        this.checkUserSendNoReceive("test.queue", session2);
    }

    @Test
    public void testReauthenticationIsCached() throws Exception {
        ActiveMQServer server = this.createServer();
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("auser", "pass");
        Role role = new Role("arole", true, false, false, false, false, false, false, false, true, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        securityRepository.addMatch(addressA, roles);
        securityManager.getConfiguration().addRole("auser", "arole");
        server.createQueue(QueueConfiguration.of((String)queueA).setAddress(addressA));
        ((SecurityStoreImpl)server.getSecurityStore()).invalidateAuthenticationCache();
        ((SecurityStoreImpl)server.getSecurityStore()).invalidateAuthorizationCache();
        this.locator.setBlockOnNonDurableSend(true);
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession("auser", "pass", false, true, true, false, -1);
        ClientProducer cp = session.createProducer(addressA);
        cp.send((Message)session.createMessage(false));
        Assertions.assertEquals((long)1L, (long)((SecurityStoreImpl)server.getSecurityStore()).getAuthenticationCacheSize());
        Assertions.assertEquals((long)1L, (long)((SecurityStoreImpl)server.getSecurityStore()).getAuthorizationCacheSize());
        ((SecurityStoreImpl)server.getSecurityStore()).invalidateAuthenticationCache();
        ((SecurityStoreImpl)server.getSecurityStore()).invalidateAuthorizationCache();
        cp.send((Message)session.createMessage(false));
        Assertions.assertEquals((long)1L, (long)((SecurityStoreImpl)server.getSecurityStore()).getAuthenticationCacheSize());
        Assertions.assertEquals((long)1L, (long)((SecurityStoreImpl)server.getSecurityStore()).getAuthorizationCacheSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUserSendAndReceive(String genericQueueName, ClientSession connection) throws Exception {
        connection.start();
        try {
            ClientProducer prod = connection.createProducer(genericQueueName);
            ClientConsumer con = connection.createConsumer(genericQueueName);
            ClientMessage m = connection.createMessage(false);
            prod.send((Message)m);
            ClientMessage rec = con.receive(1000L);
            Assertions.assertNotNull((Object)rec);
            rec.acknowledge();
        }
        finally {
            connection.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUserReceiveNoSend(String queue, ClientSession connection, ClientSession sendingConn) throws Exception {
        connection.start();
        try {
            ClientProducer prod = connection.createProducer(queue);
            ClientMessage m = connection.createMessage(false);
            try {
                prod.send((Message)m);
                Assertions.fail((String)"should throw exception");
            }
            catch (ActiveMQException activeMQException) {
                // empty catch block
            }
            prod = sendingConn.createProducer(queue);
            prod.send((Message)m);
            ClientConsumer con = connection.createConsumer(queue);
            ClientMessage rec = con.receive(1000L);
            Assertions.assertNotNull((Object)rec);
            rec.acknowledge();
        }
        finally {
            connection.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUserNoSendNoReceive(String queue, ClientSession connection, ClientSession sendingConn) throws Exception {
        connection.start();
        try {
            ClientProducer prod = connection.createProducer(queue);
            ClientMessage m = connection.createMessage(false);
            try {
                prod.send((Message)m);
                Assertions.fail((String)"should throw exception");
            }
            catch (ActiveMQException activeMQException) {
                // empty catch block
            }
            prod = sendingConn.createProducer(queue);
            prod.send((Message)m);
            try {
                connection.createConsumer(queue);
                Assertions.fail((String)"should throw exception");
            }
            catch (ActiveMQException activeMQException) {
                // empty catch block
            }
        }
        finally {
            connection.stop();
        }
    }

    private void checkUserSendNoReceive(String queue, ClientSession connection) throws Exception {
        ClientProducer prod = connection.createProducer(queue);
        ClientMessage m = connection.createMessage(false);
        prod.send((Message)m);
        try {
            connection.createConsumer(queue);
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQSecurityException activeMQSecurityException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }

    public static class DummySensitiveDataCodec
    implements SensitiveDataCodec<String> {
        public String decode(Object encodedValue) throws Exception {
            throw new IllegalStateException("Decoding not supported");
        }

        public String encode(Object value) throws Exception {
            return new StringBuffer((String)value).reverse().toString();
        }

        public boolean verify(char[] value, String encodedValue) {
            return encodedValue.equals(new StringBuffer(String.valueOf(value)).reverse().toString());
        }
    }
}

