/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.xml.VersionedFeature;
import org.wildfly.extension.undertow.AbstractHttpListenerResourceDefinition;
import org.wildfly.extension.undertow.AccessLogDefinition;
import org.wildfly.extension.undertow.AffinityCookieDefinition;
import org.wildfly.extension.undertow.AjpListenerResourceDefinition;
import org.wildfly.extension.undertow.ApplicationSecurityDomainDefinition;
import org.wildfly.extension.undertow.ApplicationSecurityDomainSingleSignOnDefinition;
import org.wildfly.extension.undertow.BufferCacheDefinition;
import org.wildfly.extension.undertow.ByteBufferPoolDefinition;
import org.wildfly.extension.undertow.ConsoleAccessLogDefinition;
import org.wildfly.extension.undertow.CrawlerSessionManagementDefinition;
import org.wildfly.extension.undertow.HostDefinition;
import org.wildfly.extension.undertow.HttpInvokerDefinition;
import org.wildfly.extension.undertow.HttpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.JspDefinition;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.LocationDefinition;
import org.wildfly.extension.undertow.MimeMappingDefinition;
import org.wildfly.extension.undertow.PersistentSessionsDefinition;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.SessionCookieDefinition;
import org.wildfly.extension.undertow.SingleSignOnDefinition;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.UndertowSubsystemSchema;
import org.wildfly.extension.undertow.WebsocketsDefinition;
import org.wildfly.extension.undertow.WelcomeFileDefinition;
import org.wildfly.extension.undertow.filters.CustomFilterDefinition;
import org.wildfly.extension.undertow.filters.ErrorPageDefinition;
import org.wildfly.extension.undertow.filters.ExpressionFilterDefinition;
import org.wildfly.extension.undertow.filters.FilterDefinitions;
import org.wildfly.extension.undertow.filters.FilterRefDefinition;
import org.wildfly.extension.undertow.filters.GzipFilterDefinition;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.wildfly.extension.undertow.filters.NoAffinityResourceDefinition;
import org.wildfly.extension.undertow.filters.RankedAffinityResourceDefinition;
import org.wildfly.extension.undertow.filters.RequestLimitHandlerDefinition;
import org.wildfly.extension.undertow.filters.ResponseHeaderFilterDefinition;
import org.wildfly.extension.undertow.filters.RewriteFilterDefinition;
import org.wildfly.extension.undertow.filters.SingleAffinityResourceDefinition;
import org.wildfly.extension.undertow.handlers.FileHandlerDefinition;
import org.wildfly.extension.undertow.handlers.HandlerDefinitions;
import org.wildfly.extension.undertow.handlers.ReverseProxyHandlerDefinition;
import org.wildfly.extension.undertow.handlers.ReverseProxyHandlerHostDefinition;

public enum UndertowPersistentResourceXMLDescriptionFactory implements Function<UndertowSubsystemSchema, PersistentResourceXMLDescription>
{
    INSTANCE;


    @Override
    public PersistentResourceXMLDescription apply(UndertowSubsystemSchema schema) {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)UndertowRootDefinition.PATH_ELEMENT, schema.getNamespace());
        if (schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_6_0)) {
            builder.addChild(PersistentResourceXMLDescription.builder((PathElement)ByteBufferPoolDefinition.PATH_ELEMENT).addAttributes(ByteBufferPoolDefinition.ATTRIBUTES.stream()));
        }
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)BufferCacheDefinition.PATH_ELEMENT).addAttributes(BufferCacheDefinition.ATTRIBUTES.stream()));
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)ServerDefinition.PATH_ELEMENT).addAttributes(ServerDefinition.ATTRIBUTES.stream()).addChild(UndertowPersistentResourceXMLDescriptionFactory.ajpListenerBuilder(schema)).addChild(UndertowPersistentResourceXMLDescriptionFactory.httpListenerBuilder(schema)).addChild(UndertowPersistentResourceXMLDescriptionFactory.httpsListenerBuilder(schema)).addChild(UndertowPersistentResourceXMLDescriptionFactory.hostBuilder(schema)));
        builder.addChild(UndertowPersistentResourceXMLDescriptionFactory.servletContainerBuilder(schema));
        builder.addChild(UndertowPersistentResourceXMLDescriptionFactory.handlersBuilder(schema));
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)FilterDefinitions.PATH_ELEMENT).setXmlElementName("filters").setNoAddOperation(true).addChild(PersistentResourceXMLDescription.builder((PathElement)RequestLimitHandlerDefinition.PATH_ELEMENT).addAttributes(RequestLimitHandlerDefinition.ATTRIBUTES.stream())).addChild(PersistentResourceXMLDescription.builder((PathElement)ResponseHeaderFilterDefinition.PATH_ELEMENT).addAttributes(ResponseHeaderFilterDefinition.ATTRIBUTES.stream())).addChild(PersistentResourceXMLDescription.builder((PathElement)GzipFilterDefinition.PATH_ELEMENT)).addChild(PersistentResourceXMLDescription.builder((PathElement)ErrorPageDefinition.PATH_ELEMENT).addAttributes(ErrorPageDefinition.ATTRIBUTES.stream())).addChild(UndertowPersistentResourceXMLDescriptionFactory.modClusterBuilder(schema)).addChild(PersistentResourceXMLDescription.builder((PathElement)CustomFilterDefinition.PATH_ELEMENT).addAttributes(CustomFilterDefinition.ATTRIBUTES.stream()).setXmlElementName("filter")).addChild(PersistentResourceXMLDescription.builder((PathElement)ExpressionFilterDefinition.PATH_ELEMENT).addAttributes(ExpressionFilterDefinition.ATTRIBUTES.stream())).addChild(PersistentResourceXMLDescription.builder((PathElement)RewriteFilterDefinition.PATH_ELEMENT).addAttributes(RewriteFilterDefinition.ATTRIBUTES.stream())));
        if (schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_4_0)) {
            builder.addChild(UndertowPersistentResourceXMLDescriptionFactory.applicationSecurityDomainBuilder(schema));
        }
        builder.setAdditionalOperationsGenerator((address, addOperation, operations) -> {
            operations.add(Util.createAddOperation((PathAddress)address.append(new PathElement[]{FilterDefinitions.PATH_ELEMENT})));
            operations.add(Util.createAddOperation((PathAddress)address.append(new PathElement[]{HandlerDefinitions.PATH_ELEMENT})));
        });
        Stream<AttributeDefinition> attributes = UndertowRootDefinition.ATTRIBUTES.stream();
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_12_0)) {
            attributes = attributes.filter(Predicate.isEqual(UndertowRootDefinition.OBFUSCATE_SESSION_ROUTE).negate());
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.PersistentResourceXMLBuilder)builder).addAttribute(arg_0));
        return builder.build();
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder ajpListenerBuilder(UndertowSubsystemSchema schema) {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)AjpListenerResourceDefinition.PATH_ELEMENT);
        Stream attributes = AjpListenerResourceDefinition.ATTRIBUTES.stream();
        Stream.concat(UndertowPersistentResourceXMLDescriptionFactory.listenerAttributes(schema), attributes).forEach(arg_0 -> ((PersistentResourceXMLDescription.PersistentResourceXMLBuilder)builder).addAttribute(arg_0));
        return builder;
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder httpListenerBuilder(UndertowSubsystemSchema schema) {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)HttpListenerResourceDefinition.PATH_ELEMENT);
        Stream attributes = HttpListenerResourceDefinition.ATTRIBUTES.stream();
        Stream.of(UndertowPersistentResourceXMLDescriptionFactory.listenerAttributes(schema), attributes, UndertowPersistentResourceXMLDescriptionFactory.httpListenerAttributes(schema)).flatMap(Function.identity()).forEach(arg_0 -> ((PersistentResourceXMLDescription.PersistentResourceXMLBuilder)builder).addAttribute(arg_0));
        return builder;
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder httpsListenerBuilder(UndertowSubsystemSchema schema) {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)HttpsListenerResourceDefinition.PATH_ELEMENT);
        Stream attributes = HttpsListenerResourceDefinition.ATTRIBUTES.stream();
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_4_0)) {
            attributes = attributes.filter(Predicate.isEqual(HttpsListenerResourceDefinition.SSL_CONTEXT).negate());
        }
        Stream<AttributeDefinition> httpListenerAttributes = UndertowPersistentResourceXMLDescriptionFactory.httpListenerAttributes(schema);
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_4_0)) {
            httpListenerAttributes = httpListenerAttributes.filter(Predicate.not(Set.of(AbstractHttpListenerResourceDefinition.CERTIFICATE_FORWARDING, AbstractHttpListenerResourceDefinition.PROXY_ADDRESS_FORWARDING)::contains));
        }
        Stream.of(UndertowPersistentResourceXMLDescriptionFactory.listenerAttributes(schema), attributes, httpListenerAttributes).flatMap(Function.identity()).forEach(arg_0 -> ((PersistentResourceXMLDescription.PersistentResourceXMLBuilder)builder).addAttribute(arg_0));
        return builder;
    }

    private static Stream<AttributeDefinition> httpListenerAttributes(UndertowSubsystemSchema schema) {
        Stream<AttributeDefinition> attributes = AbstractHttpListenerResourceDefinition.ATTRIBUTES.stream();
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_4_0)) {
            attributes = attributes.filter(Predicate.isEqual(AbstractHttpListenerResourceDefinition.REQUIRE_HOST_HTTP11).negate());
        }
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_6_0)) {
            attributes = attributes.filter(Predicate.isEqual(AbstractHttpListenerResourceDefinition.PROXY_PROTOCOL).negate());
        }
        return attributes;
    }

    private static Stream<AttributeDefinition> listenerAttributes(UndertowSubsystemSchema schema) {
        Stream<AttributeDefinition> attributes = ListenerResourceDefinition.ATTRIBUTES.stream();
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_4_0)) {
            attributes = attributes.filter(Predicate.isEqual(ListenerResourceDefinition.RFC6265_COOKIE_VALIDATION).negate());
        }
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_6_0)) {
            attributes = attributes.filter(Predicate.isEqual(ListenerResourceDefinition.ALLOW_UNESCAPED_CHARACTERS_IN_URL).negate());
        }
        return attributes;
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder hostBuilder(UndertowSubsystemSchema schema) {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)HostDefinition.PATH_ELEMENT);
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)LocationDefinition.PATH_ELEMENT).addAttributes(LocationDefinition.ATTRIBUTES.stream()).addChild(UndertowPersistentResourceXMLDescriptionFactory.filterRefBuilder()));
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)AccessLogDefinition.PATH_ELEMENT).addAttributes(AccessLogDefinition.ATTRIBUTES.stream()));
        if (schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_9_0)) {
            builder.addChild(PersistentResourceXMLDescription.builder((PathElement)ConsoleAccessLogDefinition.PATH_ELEMENT).addAttributes(ConsoleAccessLogDefinition.ATTRIBUTES.stream()));
        }
        builder.addChild(UndertowPersistentResourceXMLDescriptionFactory.filterRefBuilder());
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)SingleSignOnDefinition.PATH_ELEMENT).addAttributes(EnumSet.allOf(SingleSignOnDefinition.Attribute.class).stream().map(Supplier::get)));
        if (schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_4_0)) {
            builder.addChild(PersistentResourceXMLDescription.builder((PathElement)HttpInvokerDefinition.PATH_ELEMENT).addAttributes(HttpInvokerDefinition.ATTRIBUTES.stream()));
        }
        Stream<AttributeDefinition> attributes = HostDefinition.ATTRIBUTES.stream();
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_6_0)) {
            attributes = attributes.filter(Predicate.isEqual(HostDefinition.QUEUE_REQUESTS_ON_START).negate());
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.PersistentResourceXMLBuilder)builder).addAttribute(arg_0));
        return builder;
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder filterRefBuilder() {
        return PersistentResourceXMLDescription.builder((PathElement)FilterRefDefinition.PATH_ELEMENT).addAttributes(FilterRefDefinition.ATTRIBUTES.stream());
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder servletContainerBuilder(UndertowSubsystemSchema schema) {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)ServletContainerDefinition.PATH_ELEMENT);
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)JspDefinition.PATH_ELEMENT).addAttributes(JspDefinition.ATTRIBUTES.stream()).setXmlElementName("jsp-config"));
        if (schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_14_0)) {
            builder.addChild(PersistentResourceXMLDescription.builder((PathElement)AffinityCookieDefinition.PATH_ELEMENT).addAttributes(AffinityCookieDefinition.ATTRIBUTES.stream()));
        }
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)SessionCookieDefinition.PATH_ELEMENT).addAttributes(SessionCookieDefinition.ATTRIBUTES.stream()));
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)PersistentSessionsDefinition.PATH_ELEMENT).addAttributes(PersistentSessionsDefinition.ATTRIBUTES.stream()));
        builder.addChild(UndertowPersistentResourceXMLDescriptionFactory.websocketsBuilder(schema));
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)MimeMappingDefinition.PATH_ELEMENT).addAttributes(MimeMappingDefinition.ATTRIBUTES.stream()).setXmlWrapperElement("mime-mappings"));
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)WelcomeFileDefinition.PATH_ELEMENT).setXmlWrapperElement("welcome-files"));
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)CrawlerSessionManagementDefinition.PATH_ELEMENT).addAttributes(CrawlerSessionManagementDefinition.ATTRIBUTES.stream()));
        Stream<AttributeDefinition> attributes = ServletContainerDefinition.ATTRIBUTES.stream();
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_4_0)) {
            attributes = attributes.filter(Predicate.not(Set.of(ServletContainerDefinition.DISABLE_FILE_WATCH_SERVICE, ServletContainerDefinition.DISABLE_SESSION_ID_REUSE)::contains));
        }
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_5_0)) {
            attributes = attributes.filter(Predicate.not(Set.of(ServletContainerDefinition.FILE_CACHE_MAX_FILE_SIZE, ServletContainerDefinition.FILE_CACHE_METADATA_SIZE, ServletContainerDefinition.FILE_CACHE_TIME_TO_LIVE)::contains));
        }
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_6_0)) {
            attributes = attributes.filter(Predicate.isEqual(ServletContainerDefinition.DEFAULT_COOKIE_VERSION).negate());
        }
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_10_0)) {
            attributes = attributes.filter(Predicate.isEqual(ServletContainerDefinition.PRESERVE_PATH_ON_FORWARD).negate());
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.PersistentResourceXMLBuilder)builder).addAttribute(arg_0));
        return builder;
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder websocketsBuilder(UndertowSubsystemSchema schema) {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)WebsocketsDefinition.PATH_ELEMENT);
        Stream<Object> attributes = WebsocketsDefinition.ATTRIBUTES.stream();
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_4_0)) {
            attributes = attributes.filter(Predicate.not(Set.of(WebsocketsDefinition.PER_MESSAGE_DEFLATE, WebsocketsDefinition.DEFLATER_LEVEL)::contains));
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.PersistentResourceXMLBuilder)builder).addAttribute(arg_0));
        return builder;
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder handlersBuilder(UndertowSubsystemSchema schema) {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)HandlerDefinitions.PATH_ELEMENT).setXmlElementName("handlers").setNoAddOperation(true);
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)FileHandlerDefinition.PATH_ELEMENT).addAttributes(FileHandlerDefinition.ATTRIBUTES.stream()));
        Stream<AttributeDefinition> reverseProxyHandlerAttributes = ReverseProxyHandlerDefinition.ATTRIBUTES.stream();
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_4_0)) {
            reverseProxyHandlerAttributes = reverseProxyHandlerAttributes.filter(Predicate.isEqual(ReverseProxyHandlerDefinition.MAX_RETRIES).negate());
        }
        Stream<AttributeDefinition> reverseProxyHandlerHostAttributes = ReverseProxyHandlerHostDefinition.ATTRIBUTES.stream();
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_4_0)) {
            reverseProxyHandlerHostAttributes = reverseProxyHandlerHostAttributes.filter(Predicate.not(Set.of(ReverseProxyHandlerHostDefinition.SSL_CONTEXT, ReverseProxyHandlerHostDefinition.ENABLE_HTTP2)::contains));
        }
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)ReverseProxyHandlerDefinition.PATH_ELEMENT).addAttributes(reverseProxyHandlerAttributes).addChild(PersistentResourceXMLDescription.builder((PathElement)ReverseProxyHandlerHostDefinition.PATH_ELEMENT).addAttributes(ReverseProxyHandlerHostDefinition.ATTRIBUTES.stream()).setXmlElementName("host")));
        return builder;
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder modClusterBuilder(UndertowSubsystemSchema schema) {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)ModClusterDefinition.PATH_ELEMENT);
        if (schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_10_0)) {
            builder.addChild(PersistentResourceXMLDescription.builder((PathElement)NoAffinityResourceDefinition.PATH).setXmlElementName("no-affinity"));
            builder.addChild(PersistentResourceXMLDescription.builder((PathElement)SingleAffinityResourceDefinition.PATH).setXmlElementName("single-affinity"));
            builder.addChild(PersistentResourceXMLDescription.builder((PathElement)RankedAffinityResourceDefinition.PATH).addAttributes(Attribute.stream(RankedAffinityResourceDefinition.Attribute.class)).setXmlElementName("ranked-affinity"));
        }
        Stream<AttributeDefinition> attributes = ModClusterDefinition.ATTRIBUTES.stream();
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_4_0)) {
            attributes = attributes.filter(Predicate.not(Set.of(ModClusterDefinition.FAILOVER_STRATEGY, ModClusterDefinition.SSL_CONTEXT, ModClusterDefinition.MAX_RETRIES)::contains));
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.PersistentResourceXMLBuilder)builder).addAttribute(arg_0));
        return builder;
    }

    private static PersistentResourceXMLDescription.PersistentResourceXMLBuilder applicationSecurityDomainBuilder(UndertowSubsystemSchema schema) {
        PersistentResourceXMLDescription.PersistentResourceXMLBuilder builder = PersistentResourceXMLDescription.builder((PathElement)ApplicationSecurityDomainDefinition.PATH_ELEMENT).setXmlWrapperElement("application-security-domains");
        Stream<AttributeDefinition> ssoAttributes = Stream.concat(EnumSet.allOf(ApplicationSecurityDomainSingleSignOnDefinition.Attribute.class).stream(), EnumSet.allOf(SingleSignOnDefinition.Attribute.class).stream()).map(rec$ -> (AttributeDefinition)((Supplier)rec$).get());
        builder.addChild(PersistentResourceXMLDescription.builder((PathElement)SingleSignOnDefinition.PATH_ELEMENT).addAttributes(ssoAttributes));
        Stream<AttributeDefinition> attributes = ApplicationSecurityDomainDefinition.ATTRIBUTES.stream();
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_7_0)) {
            attributes = attributes.filter(Predicate.isEqual(ApplicationSecurityDomainDefinition.SECURITY_DOMAIN).negate());
        }
        if (!schema.since((VersionedFeature)UndertowSubsystemSchema.VERSION_8_0)) {
            attributes = attributes.filter(Predicate.not(Set.of(ApplicationSecurityDomainDefinition.ENABLE_JASPI, ApplicationSecurityDomainDefinition.INTEGRATED_JASPI)::contains));
        }
        attributes.forEach(arg_0 -> ((PersistentResourceXMLDescription.PersistentResourceXMLBuilder)builder).addAttribute(arg_0));
        return builder;
    }
}

