/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.federation.internal;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerInternal;

public class FederationAddressEntry {
    private final AddressInfo addressInfo;
    private final Set<Binding> demandBindings = new HashSet<Binding>();
    private FederationConsumerInternal consumer;

    public FederationAddressEntry(AddressInfo addressInfo) {
        this.addressInfo = addressInfo;
    }

    public AddressInfo getAddressInfo() {
        return this.addressInfo;
    }

    public String getAddress() {
        return this.addressInfo.getName().toString();
    }

    public boolean hasConsumer() {
        return this.consumer != null;
    }

    public FederationConsumerInternal getConsumer() {
        return this.consumer;
    }

    public FederationAddressEntry setConsumer(FederationConsumerInternal consumer) {
        Objects.requireNonNull(consumer, "Cannot assign a null consumer to this entry, call clear to unset");
        this.consumer = consumer;
        return this;
    }

    public FederationAddressEntry clearConsumer() {
        this.consumer = null;
        return this;
    }

    public boolean hasDemand() {
        return !this.demandBindings.isEmpty();
    }

    public FederationAddressEntry addDemand(Binding binding) {
        this.demandBindings.add(binding);
        return this;
    }

    public FederationAddressEntry removeDemand(Binding binding) {
        this.demandBindings.remove(binding);
        return this;
    }
}

