/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.io.BufferPoolResourceDefinition;
import org.wildfly.extension.io.WorkerAdd;
import org.wildfly.extension.io.WorkerResourceDefinition;
import org.wildfly.io.IOServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;
import org.xnio.XnioWorker;

class IOSubsystemRegistrar
implements SubsystemResourceDefinitionRegistrar,
ResourceServiceConfigurator {
    static final String NAME = "io";
    static final PathElement PATH = SubsystemResourceDefinitionRegistrar.pathElement((String)"io");
    static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver("io", IOSubsystemRegistrar.class);
    static final RuntimeCapability<Void> MAX_THREADS_CAPABILITY = RuntimeCapability.Builder.of((NullaryServiceDescriptor)IOServiceDescriptor.MAX_THREADS).build();
    static final RuntimeCapability<Void> DEFAULT_WORKER_CAPABILITY = RuntimeCapability.Builder.of((NullaryServiceDescriptor)IOServiceDescriptor.DEFAULT_WORKER).build();
    static final ModelNode LEGACY_DEFAULT_WORKER = new ModelNode("default");
    static final CapabilityReferenceAttributeDefinition<XnioWorker> DEFAULT_WORKER = ((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder("default-worker", CapabilityReference.builder(DEFAULT_WORKER_CAPABILITY, (UnaryServiceDescriptor)IOServiceDescriptor.NAMED_WORKER).build()).setRequired(false)).build();
    private final AtomicInteger maxThreads = new AtomicInteger();

    IOSubsystemRegistrar() {
    }

    public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = parent.registerSubsystemModel(ResourceDefinition.builder((ResourceRegistration)ResourceRegistration.of((PathElement)PATH), (ResourceDescriptionResolver)RESOLVER).build());
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)RESOLVER).addAttributes(List.of(DEFAULT_WORKER))).addCapabilities(List.of(DEFAULT_WORKER_CAPABILITY, MAX_THREADS_CAPABILITY))).withRuntimeHandler(ResourceOperationRuntimeHandler.configureParentService((ResourceServiceConfigurator)this))).build();
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        registration.registerSubModel((ResourceDefinition)new WorkerResourceDefinition(this.maxThreads));
        registration.registerSubModel((ResourceDefinition)new BufferPoolResourceDefinition());
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode workers = model.get(WorkerResourceDefinition.PATH.getKey());
        WorkerAdd.checkWorkerConfiguration(context, workers);
        ArrayList<ResourceServiceInstaller> installers = new ArrayList<ResourceServiceInstaller>(2);
        installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(MAX_THREADS_CAPABILITY, AtomicInteger::intValue, (Supplier)Functions.constantSupplier((Object)this.maxThreads)).build());
        ServiceDependency defaultWorker = DEFAULT_WORKER.resolve(context, model);
        if (defaultWorker.isPresent()) {
            installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_WORKER_CAPABILITY, (ServiceDependency)defaultWorker).build());
        }
        return ResourceServiceInstaller.combine(installers);
    }
}

