/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.deployment;

import java.util.HashSet;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class ApplicationClientDependencyProcessor
implements DeploymentUnitProcessor {
    public static final String CORBA_ID = "org.omg.api";
    public static final String XNIO = "org.jboss.xnio";

    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader loader = (ModuleLoader)deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)loader, (String)CORBA_ID).setExport(true).setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)loader, (String)XNIO).setExport(true).setImportServices(true).build());
        HashSet<String> moduleIdentifiers = new HashSet<String>();
        DeploymentUnit top = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        moduleIdentifiers.add(((ModuleIdentifier)top.getAttachment(Attachments.MODULE_IDENTIFIER)).toString());
        for (DeploymentUnit module : top.getAttachmentList(Attachments.SUB_DEPLOYMENTS)) {
            moduleIdentifiers.add(((ModuleIdentifier)module.getAttachment(Attachments.MODULE_IDENTIFIER)).toString());
        }
        moduleSpecification.removeUserDependencies(dep -> {
            String identifier = dep.getIdentifier().toString();
            return identifier.startsWith("deployment.") && !identifier.startsWith("deployment.extension.") && !moduleIdentifiers.contains(identifier);
        });
    }
}

