/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax.parser;

import java.util.List;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.ql.QueryRendererDelegate;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.parser.ExpressionBuilder;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.parser.QueryRendererDelegateImpl;
import org.infinispan.objectfilter.impl.syntax.parser.TypeDescriptor;
import org.jboss.logging.Logger;

public class VirtualExpressionBuilder<TypeMetadata> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)VirtualExpressionBuilder.class.getName());
    private final QueryRendererDelegateImpl<TypeMetadata> owner;
    private final ExpressionBuilder<TypeMetadata> whereBuilder;
    private final ExpressionBuilder<TypeMetadata> havingBuilder;
    private final ExpressionBuilder<TypeMetadata> filteringBuilder;

    public VirtualExpressionBuilder(QueryRendererDelegateImpl<TypeMetadata> owner, ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        this.owner = owner;
        this.whereBuilder = new ExpressionBuilder<TypeMetadata>(propertyHelper);
        this.havingBuilder = new ExpressionBuilder<TypeMetadata>(propertyHelper);
        this.filteringBuilder = new ExpressionBuilder<TypeMetadata>(propertyHelper);
    }

    public void setEntityType(TypeMetadata targetEntityMetadata) {
        this.whereBuilder.setEntityType(targetEntityMetadata);
        this.havingBuilder.setEntityType(targetEntityMetadata);
        this.filteringBuilder.setEntityType(targetEntityMetadata);
    }

    public ExpressionBuilder<TypeMetadata> whereBuilder() {
        return this.whereBuilder;
    }

    public ExpressionBuilder<TypeMetadata> havingBuilder() {
        return this.havingBuilder;
    }

    public ExpressionBuilder<TypeMetadata> filteringBuilder() {
        return this.filteringBuilder;
    }

    public void pushOr() {
        this.builder().pushOr();
    }

    public void pushAnd() {
        this.builder().pushAnd();
    }

    public void pushNot() {
        this.builder().pushNot();
    }

    public void addComparison(PropertyPath<TypeDescriptor<TypeMetadata>> property, ComparisonExpr.Type comparisonType, Object comparisonValue) {
        this.builder().addComparison(property, comparisonType, comparisonValue);
    }

    public void addIn(PropertyPath<TypeDescriptor<TypeMetadata>> property, List<Object> values) {
        this.builder().addIn(property, values);
    }

    public void addRange(PropertyPath<TypeDescriptor<TypeMetadata>> property, Object lowerComparisonValue, Object upperComparisonValue) {
        this.builder().addRange(property, lowerComparisonValue, upperComparisonValue);
    }

    public void addLike(PropertyPath<TypeDescriptor<TypeMetadata>> property, Object pattern, Character escapeCharacter) {
        this.builder().addLike(property, pattern, escapeCharacter);
    }

    public void addIsNull(PropertyPath<TypeDescriptor<TypeMetadata>> property) {
        this.builder().addIsNull(property);
    }

    public void addConstantBoolean(boolean booleanConstant) {
        this.builder().addConstantBoolean(booleanConstant);
    }

    public void popBoolean() {
        this.builder().pop();
    }

    public void addFullTextTerm(PropertyPath<TypeDescriptor<TypeMetadata>> property, Object comparisonObject, Integer fuzzy) {
        this.fullTextBuilder().addFullTextTerm(property, comparisonObject, fuzzy);
    }

    public void addFullTextRegexp(PropertyPath<TypeDescriptor<TypeMetadata>> property, String term) {
        this.fullTextBuilder().addFullTextRegexp(property, term);
    }

    public void addFullTextRange(PropertyPath<TypeDescriptor<TypeMetadata>> property, boolean includeLower, Object from, Object to, boolean includeUpper) {
        this.fullTextBuilder().addFullTextRange(property, includeLower, from, to, includeUpper);
    }

    public void pushFullTextBoost(float boost) {
        this.fullTextBuilder().pushFullTextBoost(boost);
    }

    public void popFullTextBoost() {
        this.fullTextBuilder().pop();
    }

    public void pushFullTextOccur(QueryRendererDelegate.Occur occur) {
        this.fullTextBuilder().pushFullTextOccur(occur);
    }

    public void popFullTextOccur() {
        this.fullTextBuilder().pop();
    }

    public void addKnnPredicate(PropertyPath<TypeDescriptor<TypeMetadata>> property, Class<?> expectedType, List<Object> vector, Object knn) {
        this.knnBuilder().addKnnPredicate(property, expectedType, vector, knn);
    }

    public void addKnnPredicate(PropertyPath<TypeDescriptor<TypeMetadata>> property, Class<?> expectedType, ConstantValueExpr.ParamPlaceholder vectorParam, Object knn) {
        this.knnBuilder().addKnnPredicate(property, expectedType, vectorParam, knn);
    }

    private ExpressionBuilder<TypeMetadata> builder() {
        if (this.phase() == QueryRendererDelegateImpl.Phase.WHERE) {
            return this.filtering() ? this.filteringBuilder : this.whereBuilder;
        }
        if (this.phase() == QueryRendererDelegateImpl.Phase.HAVING) {
            return this.havingBuilder;
        }
        throw new IllegalStateException();
    }

    private ExpressionBuilder<TypeMetadata> fullTextBuilder() {
        if (this.phase() == QueryRendererDelegateImpl.Phase.WHERE) {
            return this.filtering() ? this.filteringBuilder : this.whereBuilder;
        }
        if (this.phase() == QueryRendererDelegateImpl.Phase.HAVING) {
            throw log.getFullTextQueriesNotAllowedInHavingClauseException();
        }
        throw new IllegalStateException();
    }

    private ExpressionBuilder<TypeMetadata> knnBuilder() {
        if (this.phase() == QueryRendererDelegateImpl.Phase.WHERE) {
            if (this.filtering()) {
                throw log.knnPredicateOnFilteringClause();
            }
            return this.whereBuilder;
        }
        if (this.phase() == QueryRendererDelegateImpl.Phase.HAVING) {
            throw log.knnPredicateOnHavingClause();
        }
        throw new IllegalStateException();
    }

    private QueryRendererDelegateImpl.Phase phase() {
        return this.owner.phase;
    }

    private boolean filtering() {
        return this.owner.filtering;
    }
}

