/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.ModulesServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceDefinitionProvider;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidatorBuilder;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetric;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.CacheRuntimeResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.GlobalConfigurationServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanMarshallerFactory;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.NoTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScatteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.cache.infinispan.embedded.lifecycle.WildFlyClusteringModuleLifecycle;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.DefaultCacheServiceInstallerProvider;
import org.wildfly.clustering.server.service.LegacyClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.ProvidedBinaryServiceInstallerProvider;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceConfiguratorFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceTargetFactory;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueRegistry;

public class CacheContainerResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator {
    static final PathElement WILDCARD_PATH = CacheContainerResourceDefinition.pathElement("*");
    static final UnaryServiceDescriptor<List<Module>> CACHE_CONTAINER_MODULES = UnaryServiceDescriptor.of((String)"org.wildfly.clustering.infinispan.cache-container-modules", List.class);
    private static final RuntimeCapability<Void> CACHE_CONTAINER_CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER).build();
    private static final RuntimeCapability<Void> CACHE_CONTAINER_CONFIGURATION_CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER_CONFIGURATION).build();
    private static final RuntimeCapability<Void> CACHE_CONTAINER_MODULES_CAPABILITY = RuntimeCapability.Builder.of(CACHE_CONTAINER_MODULES).build();
    private static final RuntimeCapability<Void> DEFAULT_CACHE_CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)InfinispanServiceDescriptor.DEFAULT_CACHE).build();
    private static final RuntimeCapability<Void> DEFAULT_CACHE_CONFIGURATION_CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)InfinispanServiceDescriptor.DEFAULT_CACHE_CONFIGURATION).build();
    static final Set<PathElement> REQUIRED_CHILDREN = Stream.concat(EnumSet.allOf(ThreadPoolResourceDefinition.class).stream(), EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class).stream()).map(rec$ -> ((ResourceDefinitionProvider)rec$).getPathElement()).collect(Collectors.toSet());
    static final Set<PathElement> REQUIRED_SINGLETON_CHILDREN = Set.of(NoTransportResourceDefinition.PATH);
    private final ServiceValueExecutorRegistry<EmbeddedCacheManager> containerRegistry = ServiceValueExecutorRegistry.newInstance();
    private final ServiceValueExecutorRegistry<Cache<?, ?>> cacheRegistry = ServiceValueExecutorRegistry.newInstance();

    static PathElement pathElement(String containerName) {
        return PathElement.pathElement((String)"cache-container", (String)containerName);
    }

    CacheContainerResourceDefinition() {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(WILDCARD_PATH));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        RuntimeCapability defaultRegistryFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.DEFAULT_REGISTRY_FACTORY).build();
        RuntimeCapability defaultLegacyRegistryFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)LegacyClusteringServiceDescriptor.DEFAULT_REGISTRY_FACTORY).build();
        RuntimeCapability defaultServiceProviderRegistrar = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.DEFAULT_SERVICE_PROVIDER_REGISTRAR).build();
        RuntimeCapability defaultLegacyServiceProviderRegistry = RuntimeCapability.Builder.of((UnaryServiceDescriptor)LegacyClusteringServiceDescriptor.DEFAULT_SERVICE_PROVIDER_REGISTRY).build();
        RuntimeCapability defaultSingletonServiceTargetFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)SingletonServiceTargetFactory.DEFAULT_SERVICE_DESCRIPTOR).build();
        RuntimeCapability defaultSingletonServiceConfiguratorFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)SingletonServiceConfiguratorFactory.DEFAULT_SERVICE_DESCRIPTOR).build();
        RuntimeCapability defaultSingletonServiceBuilderFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)SingletonServiceBuilderFactory.DEFAULT_SERVICE_DESCRIPTOR).build();
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addAttributes(ListAttribute.class).addCapabilities(List.of(CACHE_CONTAINER_CAPABILITY, CACHE_CONTAINER_CONFIGURATION_CAPABILITY, CACHE_CONTAINER_MODULES_CAPABILITY)).addCapabilities(model -> model.hasDefined(Attribute.DEFAULT_CACHE.getName()), List.of(DEFAULT_CACHE_CAPABILITY, DEFAULT_CACHE_CONFIGURATION_CAPABILITY, defaultRegistryFactory, defaultLegacyRegistryFactory, defaultServiceProviderRegistrar, defaultLegacyServiceProviderRegistry, defaultSingletonServiceTargetFactory, defaultSingletonServiceConfiguratorFactory, defaultSingletonServiceBuilderFactory)).addRequiredChildren(REQUIRED_CHILDREN).addRequiredSingletonChildren(REQUIRED_SINGLETON_CHILDREN).setResourceTransformation(CacheContainerResource::new);
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new MetricHandler((MetricExecutor)new CacheContainerMetricExecutor((FunctionExecutorRegistry<EmbeddedCacheManager>)this.containerRegistry), CacheContainerMetric.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
            new CacheRuntimeResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)this.cacheRegistry).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        new JGroupsTransportResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new NoTransportResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        for (ThreadPoolResourceDefinition threadPoolResourceDefinition : EnumSet.allOf(ThreadPoolResourceDefinition.class)) {
            threadPoolResourceDefinition.register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        for (ScheduledThreadPoolResourceDefinition scheduledThreadPoolResourceDefinition : EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class)) {
            scheduledThreadPoolResourceDefinition.register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        new LocalCacheResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)this.cacheRegistry).register(registration);
        new InvalidationCacheResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)this.cacheRegistry).register(registration);
        new ReplicatedCacheResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)this.cacheRegistry).register(registration);
        new DistributedCacheResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)this.cacheRegistry).register(registration);
        new ScatteredCacheResourceDefinition((FunctionExecutorRegistry<Cache<?, ?>>)this.cacheRegistry).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        LinkedList<Object> installers = new LinkedList<Object>();
        installers.add(new ModulesServiceConfigurator(CACHE_CONTAINER_MODULES_CAPABILITY, ListAttribute.MODULES.getDefinition(), List.of(Module.forClass(WildFlyClusteringModuleLifecycle.class))).configure(context, model));
        installers.add(new GlobalConfigurationServiceConfigurator(CACHE_CONTAINER_CONFIGURATION_CAPABILITY).configure(context, model));
        installers.add(this.containerRegistry.capture(ServiceDependency.on((UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER, (String)name)));
        installers.add(new CacheContainerServiceConfigurator(CACHE_CONTAINER_CAPABILITY, (ServiceValueRegistry<Cache<?, ?>>)this.cacheRegistry).configure(context, model));
        installers.add(new BinderServiceInstaller(InfinispanBindingFactory.createCacheContainerBinding(name), context.getCapabilityServiceName(InfinispanServiceDescriptor.CACHE_CONTAINER, name)));
        String defaultCache = Attribute.DEFAULT_CACHE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        if (defaultCache != null) {
            BinaryServiceConfiguration configuration = BinaryServiceConfiguration.of((String)name, (String)defaultCache);
            installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_CACHE_CONFIGURATION_CAPABILITY, (ServiceDependency)configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONFIGURATION)).build());
            installers.add((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_CACHE_CAPABILITY, (ServiceDependency)configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE)).build());
            if (!defaultCache.equals("default")) {
                ServiceName lazyCacheServiceName = configuration.resolveServiceName(InfinispanServiceDescriptor.CACHE).append(new String[]{"lazy"});
                BinaryServiceConfiguration defaultConfiguration = configuration.withChildName("default");
                installers.add(new BinderServiceInstaller(InfinispanBindingFactory.createCacheBinding(defaultConfiguration), lazyCacheServiceName));
                installers.add(new BinderServiceInstaller(InfinispanBindingFactory.createCacheConfigurationBinding(defaultConfiguration), DEFAULT_CACHE_CONFIGURATION_CAPABILITY.getCapabilityServiceName(address)));
            }
            new ProvidedBinaryServiceInstallerProvider(DefaultCacheServiceInstallerProvider.class, DefaultCacheServiceInstallerProvider.class.getClassLoader()).apply(context.getCapabilityServiceSupport(), configuration).forEach(installers::add);
        }
        return ResourceServiceInstaller.combine(installers);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        DEFAULT_CACHE("default-cache", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(false)).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(DEFAULT_CACHE_CONFIGURATION_CAPABILITY, (BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONFIGURATION).withParentPath(WILDCARD_PATH).build());
            }
        }
        ,
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDefaultValue(ModelNode.FALSE);
            }
        }
        ,
        MARSHALLER("marshaller", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode(InfinispanMarshallerFactory.LEGACY.name()))).setValidator(new ParameterValidator(){
                    private final ParameterValidator validator = EnumValidator.create(InfinispanMarshallerFactory.class);

                    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                        this.validator.validateParameter(parameterName, value);
                        if (!value.isDefined() || value.equals(MARSHALLER.getDefinition().getDefaultValue())) {
                            InfinispanLogger.ROOT_LOGGER.marshallerEnumValueDeprecated(parameterName, InfinispanMarshallerFactory.LEGACY, EnumSet.complementOf(EnumSet.of(InfinispanMarshallerFactory.LEGACY)));
                        }
                    }
                });
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum ListAttribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<StringListAttributeDefinition.Builder>
    {
        ALIASES("aliases"),
        MODULES("modules"){

            @Override
            public StringListAttributeDefinition.Builder apply(StringListAttributeDefinition.Builder builder) {
                return (StringListAttributeDefinition.Builder)builder.setElementValidator(new ModuleIdentifierValidatorBuilder().configure((AbstractAttributeDefinitionBuilder)builder).build());
            }
        };

        private final AttributeDefinition definition;

        private ListAttribute(String name) {
            this.definition = this.apply((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(name).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public StringListAttributeDefinition.Builder apply(StringListAttributeDefinition.Builder builder) {
            return builder;
        }
    }
}

