/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;

public final class PolicyUtil {
    static final Boolean SM_SUPPORTED = Runtime.version().feature() < 24;
    private static final ThreadLocal<Policy> CURRENT_POLICY = new ThreadLocal();
    private final Policy policy;

    public static void setPolicy(Policy policy) {
        if (SM_SUPPORTED.booleanValue()) {
            Policy.setPolicy(policy);
        } else {
            CURRENT_POLICY.set(policy);
        }
    }

    public static Policy getPolicy() {
        if (SM_SUPPORTED.booleanValue()) {
            return Policy.getPolicy();
        }
        return CURRENT_POLICY.get();
    }

    public static PolicyUtil getPolicyUtil() {
        return new PolicyUtil(PolicyUtil.getPolicy());
    }

    PolicyUtil(Policy policy) {
        this.policy = policy;
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        return this.policy != null && this.policy.implies(domain, permission);
    }

    public void refresh() {
        if (this.policy != null) {
            this.policy.refresh();
        }
    }
}

