/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.config.impl;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.config.impl.AnnotationConfigurationImpl;
import org.infinispan.protostream.descriptors.AnnotationElement;

public final class ConfigurationImpl
implements Configuration {
    private final boolean logOutOfSequenceReads;
    private final boolean logOutOfSequenceWrites;
    private final boolean lenient;
    private final AnnotationsConfigImpl annotationsConfig;
    private final int maxNestedMessageDepth;
    private final Configuration.SchemaValidation schemaValidation;
    private final boolean wrapCollectionElements;

    private ConfigurationImpl(BuilderImpl builder, Map<String, AnnotationConfigurationImpl> annotations) {
        this.logOutOfSequenceReads = builder.logOutOfSequenceReads;
        this.logOutOfSequenceWrites = builder.logOutOfSequenceWrites;
        this.lenient = builder.lenient;
        this.maxNestedMessageDepth = builder.maxNestedMessageDepth;
        this.schemaValidation = builder.schemaValidation;
        this.wrapCollectionElements = builder.wrapCollectionElements;
        this.annotationsConfig = new AnnotationsConfigImpl(annotations, builder.logUndefinedAnnotations);
    }

    @Override
    public boolean logOutOfSequenceReads() {
        return this.logOutOfSequenceReads;
    }

    @Override
    public boolean logOutOfSequenceWrites() {
        return this.logOutOfSequenceWrites;
    }

    @Override
    public int maxNestedMessageDepth() {
        return this.maxNestedMessageDepth;
    }

    @Override
    public Configuration.SchemaValidation schemaValidation() {
        return this.schemaValidation;
    }

    @Override
    public boolean wrapCollectionElements() {
        return this.wrapCollectionElements;
    }

    @Override
    public Configuration.AnnotationsConfig annotationsConfig() {
        return this.annotationsConfig;
    }

    public String toString() {
        return "ConfigurationImpl{logOutOfSequenceReads=" + this.logOutOfSequenceReads + ", logOutOfSequenceWrites=" + this.logOutOfSequenceWrites + ", lenient=" + this.lenient + ", annotationsConfig=" + this.annotationsConfig + ", maxNestedMessageDepth=" + this.maxNestedMessageDepth + ", schemaValidation=" + this.schemaValidation + "}";
    }

    public static final class BuilderImpl
    implements Configuration.Builder {
        private boolean logOutOfSequenceReads = true;
        private boolean logOutOfSequenceWrites = true;
        private boolean lenient = true;
        private int maxNestedMessageDepth = 100;
        private AnnotationsConfigBuilderImpl annotationsConfigBuilder = null;
        private Boolean logUndefinedAnnotations;
        private Configuration.SchemaValidation schemaValidation = Configuration.SchemaValidation.DEFAULT;
        private boolean wrapCollectionElements;

        @Override
        public Configuration.Builder setLogOutOfSequenceReads(boolean logOutOfSequenceReads) {
            this.logOutOfSequenceReads = logOutOfSequenceReads;
            return this;
        }

        @Override
        public Configuration.Builder setLogOutOfSequenceWrites(boolean logOutOfSequenceWrites) {
            this.logOutOfSequenceWrites = logOutOfSequenceWrites;
            return this;
        }

        @Override
        public Configuration.Builder setLenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        @Override
        public Configuration.Builder maxNestedMessageDepth(int maxNestedMessageDepth) {
            this.maxNestedMessageDepth = maxNestedMessageDepth;
            return this;
        }

        @Override
        public Configuration.Builder schemaValidation(Configuration.SchemaValidation schemaValidation) {
            this.schemaValidation = schemaValidation;
            return this;
        }

        @Override
        public Configuration.Builder wrapCollectionElements(boolean wrapCollectionElements) {
            this.wrapCollectionElements = wrapCollectionElements;
            return this;
        }

        @Override
        public Configuration.AnnotationsConfig.Builder annotationsConfig() {
            if (this.annotationsConfigBuilder == null) {
                this.annotationsConfigBuilder = new AnnotationsConfigBuilderImpl();
            }
            return this.annotationsConfigBuilder;
        }

        @Override
        public Configuration build() {
            this.annotationsConfig().annotation("TypeId", AnnotationElement.AnnotationTarget.MESSAGE, AnnotationElement.AnnotationTarget.ENUM).attribute("value").type(AnnotationElement.AttributeType.INT).metadataCreator((annotatedDescriptor, annotation) -> annotation.getDefaultAttributeValue().getValue());
            AnnotationsConfigBuilderImpl annotationsConfig = (AnnotationsConfigBuilderImpl)this.annotationsConfig();
            HashMap<String, AnnotationConfigurationImpl> annotations = new HashMap<String, AnnotationConfigurationImpl>(annotationsConfig.annotationBuilders.size());
            for (AnnotationConfigurationImpl.BuilderImpl annotationBuilder : annotationsConfig.annotationBuilders.values()) {
                AnnotationConfigurationImpl annotationConfig = annotationBuilder.buildAnnotationConfiguration();
                annotations.put(annotationConfig.name(), annotationConfig);
            }
            for (AnnotationConfigurationImpl a : annotations.values()) {
                String repeatable = a.repeatable();
                if (repeatable == null) continue;
                AnnotationConfigurationImpl container = (AnnotationConfigurationImpl)annotations.get(repeatable);
                if (container == null) {
                    throw new IllegalStateException("Containing annotation '" + repeatable + "' of repeatable annotation '" + a.name() + "' was not found in configuration.");
                }
                a.container = container;
            }
            this.logUndefinedAnnotations = ((AnnotationsConfigBuilderImpl)this.annotationsConfig()).logUndefinedAnnotations;
            if (this.logUndefinedAnnotations == null) {
                this.logUndefinedAnnotations = annotations.size() > 1;
            }
            return new ConfigurationImpl(this, annotations);
        }

        final class AnnotationsConfigBuilderImpl
        implements Configuration.AnnotationsConfig.Builder {
            private Boolean logUndefinedAnnotations = null;
            final Map<String, AnnotationConfigurationImpl.BuilderImpl> annotationBuilders = new HashMap<String, AnnotationConfigurationImpl.BuilderImpl>();

            AnnotationsConfigBuilderImpl() {
            }

            @Override
            public Configuration.AnnotationsConfig.Builder setLogUndefinedAnnotations(boolean logUndefinedAnnotations) {
                this.logUndefinedAnnotations = logUndefinedAnnotations;
                return this;
            }

            @Override
            public AnnotationConfiguration.Builder annotation(String annotationName, AnnotationElement.AnnotationTarget ... target) {
                if (this.annotationBuilders.containsKey(annotationName)) {
                    throw new IllegalArgumentException("Duplicate annotation name definition: " + annotationName);
                }
                if (target == null || target.length == 0) {
                    throw new IllegalArgumentException("At least one target must be specified for annotation: " + annotationName);
                }
                AnnotationConfigurationImpl.BuilderImpl builder = new AnnotationConfigurationImpl.BuilderImpl(this, annotationName, target);
                this.annotationBuilders.put(annotationName, builder);
                return builder;
            }

            @Override
            public Configuration build() {
                return BuilderImpl.this.build();
            }
        }
    }

    private static final class AnnotationsConfigImpl
    implements Configuration.AnnotationsConfig {
        private final Map<String, AnnotationConfiguration> annotations;
        private final boolean logUndefinedAnnotations;

        AnnotationsConfigImpl(Map<String, AnnotationConfigurationImpl> annotations, boolean logUndefinedAnnotations) {
            this.annotations = Map.copyOf(annotations);
            this.logUndefinedAnnotations = logUndefinedAnnotations;
        }

        @Override
        public boolean logUndefinedAnnotations() {
            return this.logUndefinedAnnotations;
        }

        @Override
        public Map<String, AnnotationConfiguration> annotations() {
            return this.annotations;
        }

        public String toString() {
            return "AnnotationsConfig{annotations=" + this.annotations + ", logUndefinedAnnotations=" + this.logUndefinedAnnotations + "}";
        }
    }
}

