/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.injection.deployment;

import jakarta.jms.JMSContext;
import jakarta.transaction.Synchronization;
import jakarta.transaction.TransactionScoped;
import jakarta.transaction.TransactionSynchronizationRegistry;
import org.wildfly.extension.messaging.activemq.injection._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.injection.deployment.AbstractJMSContext;

@TransactionScoped
class TransactedJMSContext
extends AbstractJMSContext {
    TransactedJMSContext() {
    }

    void registerCleanUpListener(TransactionSynchronizationRegistry transactionSynchronizationRegistry, JMSContext contextInstance) {
        Object alreadyRegistered = transactionSynchronizationRegistry.getResource((Object)contextInstance);
        if (alreadyRegistered == null) {
            transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)new AfterCompletionSynchronization(contextInstance));
            transactionSynchronizationRegistry.putResource((Object)contextInstance, (Object)AfterCompletionSynchronization.class.getName());
        }
    }

    private class AfterCompletionSynchronization
    implements Synchronization {
        final JMSContext context;

        public AfterCompletionSynchronization(JMSContext context) {
            this.context = context;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            MessagingLogger.ROOT_LOGGER.debugf("Clean up JMSContext created from %s", TransactedJMSContext.this);
            this.context.close();
        }
    }
}

