/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.util.Map;
import org.infinispan.util.function.SerializablePredicate;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataEntry;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataKey;

public class InfinispanBeanMetaDataFilter<K, V>
implements SerializablePredicate<Map.Entry<? super K, ? super V>> {
    private static final long serialVersionUID = -1079989480899595045L;
    private final String beanName;

    public InfinispanBeanMetaDataFilter(String beanName) {
        this.beanName = beanName;
    }

    public boolean test(Map.Entry<? super K, ? super V> entry) {
        V value;
        if (entry.getKey() instanceof BeanMetaDataKey && (value = entry.getValue()) instanceof BeanMetaDataEntry) {
            BeanMetaDataEntry metaData = (BeanMetaDataEntry)value;
            return this.beanName.equals(metaData.getName());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InfinispanBeanMetaDataFilter)) {
            return false;
        }
        InfinispanBeanMetaDataFilter filter = (InfinispanBeanMetaDataFilter)object;
        return this.beanName.equals(filter.beanName);
    }

    public int hashCode() {
        return this.beanName.hashCode();
    }

    public String toString() {
        return this.beanName;
    }
}

