/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.util.StringHelper;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.jboss.logging.Logger;

public final class ProtobufPropertyHelper
extends ObjectPropertyHelper<Descriptor> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)ProtobufPropertyHelper.class.getName());
    public static final String BIG_INTEGER_COMMON_TYPE = "org.infinispan.protostream.commons.BigInteger";
    public static final String BIG_DECIMAL_COMMON_TYPE = "org.infinispan.protostream.commons.BigDecimal";
    public static final String VERSION = "__ISPN_Version";
    public static final int VERSION_FIELD_ATTRIBUTE_ID = 150000;
    public static final int MIN_METADATA_FIELD_ATTRIBUTE_ID = 150000;
    public static final String VALUE = "__HSearch_This";
    public static final int VALUE_FIELD_ATTRIBUTE_ID = 150001;
    public static final String SCORE = "__ISPN_Score";
    public static final int SCORE_FIELD_ATTRIBUTE_ID = 150002;
    public static final int KEY_FIELD_ATTRIBUTE_ID = 150003;
    private static final IndexedFieldProvider.FieldIndexingMetadata<Descriptor> PROTO_NO_INDEXING = IndexedFieldProvider.noIndexing();
    private final EntityNameResolver<Descriptor> entityNameResolver;
    private final IndexedFieldProvider<Descriptor> indexedFieldProvider;

    public ProtobufPropertyHelper(SerializationContext serializationContext, IndexedFieldProvider<Descriptor> indexedFieldProvider) {
        this(arg_0 -> ((SerializationContext)serializationContext).getMessageDescriptor(arg_0), indexedFieldProvider);
    }

    public ProtobufPropertyHelper(EntityNameResolver<Descriptor> entityNameResolver, IndexedFieldProvider<Descriptor> indexedFieldProvider) {
        this.entityNameResolver = entityNameResolver;
        this.indexedFieldProvider = indexedFieldProvider != null ? indexedFieldProvider : typeMetadata -> PROTO_NO_INDEXING;
    }

    @Override
    public IndexedFieldProvider<Descriptor> getIndexedFieldProvider() {
        return this.indexedFieldProvider;
    }

    @Override
    public Descriptor getEntityMetadata(String typeName) {
        return this.entityNameResolver.resolve(typeName);
    }

    @Override
    public List<?> mapPropertyNamePathToFieldIdPath(Descriptor messageDescriptor, String[] propertyPath) {
        if (propertyPath.length == 1) {
            if (propertyPath[0].equals(VERSION)) {
                return Arrays.asList(150000);
            }
            if (propertyPath[0].equals(VALUE)) {
                return Arrays.asList(150001);
            }
            if (propertyPath[0].equals(SCORE)) {
                return Arrays.asList(150002);
            }
        }
        return this.translatePropertyPath(messageDescriptor, propertyPath);
    }

    @Override
    public Class<?> getPrimitivePropertyType(Descriptor entityType, String[] propertyPath) {
        FieldDescriptor field;
        if (propertyPath.length == 1) {
            if (propertyPath[0].equals(VERSION)) {
                return Long.class;
            }
            if (propertyPath[0].equals(VALUE)) {
                return Object.class;
            }
            if (propertyPath[0].equals(SCORE)) {
                return Float.class;
            }
        }
        if ((field = this.getField(entityType, propertyPath)) == null) {
            throw log.getNoSuchPropertyException(entityType.getFullName(), StringHelper.join(propertyPath));
        }
        switch (field.getJavaType()) {
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case STRING: {
                return String.class;
            }
            case BYTE_STRING: {
                return byte[].class;
            }
            case ENUM: {
                return Integer.class;
            }
            case MESSAGE: {
                switch (field.getTypeName()) {
                    case "org.infinispan.protostream.commons.BigInteger": {
                        return BigInteger.class;
                    }
                    case "org.infinispan.protostream.commons.BigDecimal": {
                        return BigDecimal.class;
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public Class<?> getIndexedPropertyType(Descriptor entityType, String[] propertyPath) {
        return this.getPrimitivePropertyType(entityType, propertyPath);
    }

    private FieldDescriptor getField(Descriptor entityType, String[] propertyPath) {
        Descriptor messageDescriptor = entityType;
        FieldDescriptor field = null;
        for (int i = 0; i < propertyPath.length; ++i) {
            String property = propertyPath[i];
            field = messageDescriptor.findFieldByName(property);
            if (field != null) {
                if (field.getJavaType() != JavaType.MESSAGE) continue;
                messageDescriptor = field.getMessageType();
                continue;
            }
            if (i == 0 && (messageDescriptor = this.indexedFieldProvider.get(messageDescriptor).keyType(property)) != null) {
                field = ProtobufPropertyHelper.syntheticKeyField(property, messageDescriptor.getFullName());
                continue;
            }
            return null;
        }
        return field;
    }

    private List<Integer> translatePropertyPath(Descriptor entityType, String[] propertyPath) {
        ArrayList<Integer> translatedPath = new ArrayList<Integer>(propertyPath.length);
        Descriptor messageDescriptor = entityType;
        for (int i = 0; i < propertyPath.length; ++i) {
            String property = propertyPath[i];
            FieldDescriptor field = messageDescriptor.findFieldByName(property);
            if (field != null) {
                translatedPath.add(field.getNumber());
                if (field.getJavaType() != JavaType.MESSAGE) continue;
                messageDescriptor = field.getMessageType();
                continue;
            }
            if (i == 0 && (messageDescriptor = this.indexedFieldProvider.get(messageDescriptor).keyType(property)) != null) {
                field = ProtobufPropertyHelper.syntheticKeyField(property, messageDescriptor.getFullName());
                translatedPath.add(field.getNumber());
                continue;
            }
            return null;
        }
        return translatedPath;
    }

    @Override
    public boolean isRepeatedProperty(Descriptor entityType, String[] propertyPath) {
        Descriptor messageDescriptor = entityType;
        for (int i = 0; i < propertyPath.length; ++i) {
            String property = propertyPath[i];
            FieldDescriptor field = messageDescriptor.findFieldByName(property);
            if (field != null) {
                if (field.isRepeated()) {
                    return true;
                }
                if (field.getJavaType() != JavaType.MESSAGE) continue;
                messageDescriptor = field.getMessageType();
                continue;
            }
            if (i == 0 && (messageDescriptor = this.indexedFieldProvider.get(messageDescriptor).keyType(property)) != null) continue;
            return false;
        }
        return false;
    }

    @Override
    public boolean hasProperty(Descriptor entityType, String[] propertyPath) {
        if (propertyPath.length == 1 && (propertyPath[0].equals(VERSION) || propertyPath[0].equals(VALUE) || propertyPath[0].equals(SCORE))) {
            return true;
        }
        return this.getField(entityType, propertyPath) != null;
    }

    @Override
    public boolean hasEmbeddedProperty(Descriptor entityType, String[] propertyPath) {
        FieldDescriptor field = this.getField(entityType, propertyPath);
        if (field == null) {
            return false;
        }
        return field.getJavaType() == JavaType.MESSAGE;
    }

    @Override
    public Object convertToPropertyType(Descriptor entityType, String[] propertyPath, String value) {
        FieldDescriptor field = this.getField(entityType, propertyPath);
        if (field == null) {
            throw log.getNoSuchPropertyException(entityType.getFullName(), StringHelper.join(propertyPath));
        }
        if (field.getJavaType() == JavaType.BOOLEAN) {
            try {
                return Integer.parseInt(value) != 0;
            }
            catch (NumberFormatException e) {
                return super.convertToPropertyType(entityType, propertyPath, value);
            }
        }
        if (field.getJavaType() == JavaType.ENUM) {
            EnumValueDescriptor enumValue;
            EnumDescriptor enumType = field.getEnumType();
            try {
                enumValue = enumType.findValueByNumber(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                enumValue = enumType.findValueByName(value);
            }
            if (enumValue == null) {
                throw log.getInvalidEnumLiteralException(value, enumType.getFullName());
            }
            return enumValue.getNumber();
        }
        if (field.getJavaType() == JavaType.MESSAGE) {
            if (field.getTypeName().equals(BIG_INTEGER_COMMON_TYPE)) {
                return new BigInteger(value);
            }
            if (field.getTypeName().equals(BIG_DECIMAL_COMMON_TYPE)) {
                return new BigDecimal(value);
            }
        }
        return super.convertToPropertyType(entityType, propertyPath, value);
    }

    public static FieldDescriptor syntheticKeyField(String name, String type) {
        return new FieldDescriptor.Builder().withName(name).withNumber(150003).withTypeName(type).build();
    }
}

