/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JMSDurableConsumerTest
extends JMSClientTestSupport {
    @Parameter(index=0)
    public boolean amqpUseCoreSubscriptionNaming;

    @Parameters(name="{index}: amqpUseCoreSubscriptionNaming={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setAmqpUseCoreSubscriptionNaming(this.amqpUseCoreSubscriptionNaming);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=30L)
    public void testDurableConsumerAsync() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference received = new AtomicReference();
        String durableClientId = this.getTopicName() + "-ClientId";
        try (Connection connection = this.createConnection(durableClientId);){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer = session.createDurableSubscriber(topic, "DurbaleTopic");
            consumer.setMessageListener(message -> {
                received.set(message);
                latch.countDown();
            });
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.setDeliveryMode(2);
            connection.start();
            TextMessage message2 = session.createTextMessage();
            message2.setText("hello");
            producer.send((Message)message2);
            Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            Assertions.assertNotNull(received.get(), (String)"Should have received a message by now.");
            Assertions.assertTrue((boolean)(received.get() instanceof TextMessage), (String)"Should be an instance of TextMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=30L)
    public void testDurableConsumerSync() throws Exception {
        String durableClientId = this.getTopicName() + "-ClientId";
        try (Connection connection = this.createConnection(durableClientId);){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer = session.createDurableSubscriber(topic, "DurbaleTopic");
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.setDeliveryMode(2);
            connection.start();
            TextMessage message = session.createTextMessage();
            message.setText("hello");
            producer.send((Message)message);
            AtomicReference msg = new AtomicReference();
            Assertions.assertTrue((boolean)Wait.waitFor(() -> JMSDurableConsumerTest.lambda$testDurableConsumerSync$1(msg, (MessageConsumer)consumer), (long)TimeUnit.SECONDS.toMillis(25L), (long)TimeUnit.MILLISECONDS.toMillis(200L)));
            Assertions.assertNotNull(msg.get(), (String)"Should have received a message by now.");
            Assertions.assertTrue((boolean)(msg.get() instanceof TextMessage), (String)"Should be an instance of TextMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=30L)
    public void testDurableConsumerUnsubscribe() throws Exception {
        String durableClientId = this.getTopicName() + "-ClientId";
        try (Connection connection = this.createConnection(durableClientId);){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer = session.createDurableSubscriber(topic, "DurbaleTopic");
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.getTotalConsumerCount() == 1L, (long)TimeUnit.SECONDS.toMillis(20L), (long)TimeUnit.MILLISECONDS.toMillis(250L)));
            consumer.close();
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.getTotalConsumerCount() == 0L, (long)TimeUnit.SECONDS.toMillis(20L), (long)TimeUnit.MILLISECONDS.toMillis(250L)));
            session.unsubscribe("DurbaleTopic");
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.getTotalConsumerCount() == 0L, (long)TimeUnit.SECONDS.toMillis(20L), (long)TimeUnit.MILLISECONDS.toMillis(250L)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=30L)
    public void testDurableConsumerUnsubscribeWhileNoSubscription() throws Exception {
        try (Connection connection = this.createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.getTotalConsumerCount() == 0L, (long)TimeUnit.SECONDS.toMillis(20L), (long)TimeUnit.MILLISECONDS.toMillis(250L)));
            try {
                session.unsubscribe("DurbaleTopic");
                Assertions.fail((String)"Should have thrown as subscription is in use.");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=30L)
    public void testDurableConsumerUnsubscribeWhileActive() throws Exception {
        String durableClientId = this.getTopicName() + "-ClientId";
        try (Connection connection = this.createConnection(durableClientId);){
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer = session.createDurableSubscriber(topic, "DurbaleTopic");
            Assertions.assertNotNull((Object)consumer);
            Assertions.assertNull((Object)consumer.receive(10L));
            try {
                session.unsubscribe("DurbaleTopic");
                Assertions.fail((String)"Should have thrown as subscription is in use.");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=30L)
    public void testDurableConsumerLarge() throws Exception {
        String durableClientId = this.getTopicName() + "-ClientId";
        try (Connection connection = this.createConnection(durableClientId);){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            TopicSubscriber consumer1 = session.createDurableSubscriber(topic, "DurbaleSub1");
            TopicSubscriber consumer2 = session.createDurableSubscriber(topic, "DurbaleSub2");
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.setDeliveryMode(2);
            connection.start();
            ObjectMessage objMessage = session.createObjectMessage();
            BigObject bigObject = new BigObject(102400);
            objMessage.setObject((Serializable)bigObject);
            producer.send((Message)objMessage);
            ObjectMessage msg1 = (ObjectMessage)consumer1.receive(5000L);
            Assertions.assertNotNull((Object)msg1);
            Assertions.assertTrue((boolean)(msg1 instanceof ObjectMessage), (String)"Should be an instance of TextMessage");
            ObjectMessage msg2 = (ObjectMessage)consumer2.receive(5000L);
            Assertions.assertNotNull((Object)msg2, (String)"Should have received a message by now.");
            Assertions.assertTrue((boolean)(msg2 instanceof ObjectMessage), (String)"Should be an instance of TextMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    @Timeout(value=30L)
    public void testDurableConsumerWithSelectorChange() throws Exception {
        SimpleString qName = SimpleString.of((String)"foo.SharedConsumer");
        try (Connection connection = this.createConnection("foo", true);){
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            MessageConsumer consumer = session.createDurableConsumer(topic, "SharedConsumer", "a=b", false);
            MessageProducer producer = session.createProducer((Destination)session.createTopic(this.getTopicName()));
            Message message = session.createMessage();
            message.setStringProperty("a", "1");
            message.setStringProperty("b", "1");
            producer.send(message);
            QueueImpl queue = (QueueImpl)this.server.getPostOffice().getBinding(qName).getBindable();
            Assertions.assertEquals((int)1, (int)queue.getMaxConsumers());
            Wait.assertEquals((long)1L, () -> ((QueueImpl)queue).getMessageCount());
            consumer.close();
            MessageConsumer consumer2 = session.createDurableConsumer(topic, "SharedConsumer", "a=b and b=c", false);
            queue = (QueueImpl)this.server.getPostOffice().getBinding(qName).getBindable();
            Assertions.assertEquals((int)1, (int)queue.getMaxConsumers());
            Wait.assertEquals((long)0L, () -> ((QueueImpl)queue).getMessageCount());
            message = session.createMessage();
            message.setStringProperty("a", "2");
            message.setStringProperty("b", "2");
            message.setStringProperty("c", "2");
            producer.send(message);
            Wait.assertEquals((long)1L, () -> ((QueueImpl)queue).getMessageCount());
            connection.start();
            Assertions.assertNotNull((Object)consumer2.receive(5000L));
        }
    }

    private static /* synthetic */ boolean lambda$testDurableConsumerSync$1(AtomicReference msg, MessageConsumer consumer) throws Exception {
        msg.set(consumer.receiveNoWait());
        return msg.get() != null;
    }

    public static class BigObject
    implements Serializable {
        private char[] contents;

        public BigObject(int size) {
            this.contents = new char[size];
            for (int i = 0; i < size; ++i) {
                this.contents[i] = 88;
            }
        }
    }
}

