/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullQualifiedQueueTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SimpleString anycastAddress = SimpleString.of((String)"address.anycast");
    private SimpleString multicastAddress = SimpleString.of((String)"address.multicast");
    private SimpleString mixedAddress = SimpleString.of((String)"address.mixed");
    private SimpleString anycastQ1 = SimpleString.of((String)"q1");
    private SimpleString anycastQ2 = SimpleString.of((String)"q2");
    private SimpleString anycastQ3 = SimpleString.of((String)"q3");
    private SimpleString multicastQ1 = SimpleString.of((String)"q4");
    private SimpleString multicastQ2 = SimpleString.of((String)"q5");
    private SimpleString multicastQ3 = SimpleString.of((String)"q6");
    private ActiveMQServer server;
    private ServerLocator locator;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, true);
        this.server.start();
        this.locator = this.createNettyNonHALocator();
    }

    @Test
    public void testMixedQueues() throws Exception {
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.multicastQ1).setAddress(this.mixedAddress));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.multicastQ2).setAddress(this.mixedAddress));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.multicastQ3).setAddress(this.mixedAddress));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.anycastQ1).setAddress(this.mixedAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.anycastQ2).setAddress(this.mixedAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.anycastQ3).setAddress(this.mixedAddress).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession();
        session.start();
        ClientProducer producer = session.createProducer(this.mixedAddress);
        int num = 3;
        this.sendMessages(session, producer, 3);
        ClientConsumer consumer1 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.anycastQ1));
        ClientConsumer consumer2 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.anycastQ2));
        ClientConsumer consumer3 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.anycastQ3));
        ClientConsumer consumer4 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.multicastQ1));
        ClientConsumer consumer5 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.multicastQ2));
        ClientConsumer consumer6 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)this.multicastQ3));
        session.start();
        ClientMessage m = consumer1.receive(2000L);
        Assertions.assertNotNull((Object)m);
        logger.debug("consumer1 : {}", (Object)m);
        m.acknowledge();
        m = consumer2.receive(2000L);
        Assertions.assertNotNull((Object)m);
        logger.debug("consumer2 : {}", (Object)m);
        m.acknowledge();
        m = consumer3.receive(2000L);
        Assertions.assertNotNull((Object)m);
        logger.debug("consumer3 : {}", (Object)m);
        m.acknowledge();
        for (int i = 0; i < 3; ++i) {
            m = consumer4.receive(2000L);
            Assertions.assertNotNull((Object)m);
            logger.debug("consumer4 : {}", (Object)m);
            m.acknowledge();
            m = consumer5.receive(2000L);
            Assertions.assertNotNull((Object)m);
            logger.debug("consumer5 : {}", (Object)m);
            m.acknowledge();
            m = consumer6.receive(2000L);
            Assertions.assertNotNull((Object)m);
            logger.debug("consumer6 : {}", (Object)m);
            m.acknowledge();
        }
        session.commit();
        for (SimpleString q : new SimpleString[]{this.anycastQ1, this.anycastQ2, this.anycastQ3, this.multicastQ1, this.multicastQ2, this.multicastQ3}) {
            QueueQueryResult query = this.server.queueQuery(CompositeAddress.toFullyQualified((SimpleString)this.mixedAddress, (SimpleString)q));
            Assertions.assertTrue((boolean)query.isExists());
            Assertions.assertEquals((Object)this.mixedAddress, (Object)query.getAddress());
            Assertions.assertEquals((Object)q, (Object)query.getName());
            Assertions.assertEquals((long)0L, (long)query.getMessageCount());
        }
    }

    @Test
    public void testMulticastQueues() throws Exception {
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.multicastQ1).setAddress(this.multicastAddress));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.multicastQ2).setAddress(this.multicastAddress));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.multicastQ3).setAddress(this.multicastAddress));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession();
        session.start();
        ClientProducer producer = session.createProducer(this.multicastAddress);
        this.sendMessages(session, producer, 1);
        ClientConsumer consumer1 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)this.multicastQ1));
        ClientConsumer consumer2 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)this.multicastQ2));
        ClientConsumer consumer3 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)this.multicastQ3));
        session.start();
        ClientMessage m = consumer1.receive(2000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        m = consumer2.receive(2000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        m = consumer3.receive(2000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        session.commit();
        for (SimpleString q : new SimpleString[]{this.multicastQ1, this.multicastQ2, this.multicastQ3}) {
            QueueQueryResult query = this.server.queueQuery(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)q));
            Assertions.assertTrue((boolean)query.isExists());
            Assertions.assertEquals((Object)this.multicastAddress, (Object)query.getAddress());
            Assertions.assertEquals((Object)q, (Object)query.getName());
            Assertions.assertEquals((long)0L, (long)query.getMessageCount());
        }
    }

    @Test
    public void testAnycastQueues() throws Exception {
        int i;
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.anycastQ1).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.anycastQ2).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.anycastQ3).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession();
        session.start();
        ClientProducer producer1 = session.createProducer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ1).toString());
        for (int i2 = 0; i2 < 2; ++i2) {
            producer1.send((Message)session.createMessage(false));
        }
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> this.server.locateQueue(this.anycastQ1).getMessageCount() == 2L, (long)2000L, (long)200L));
        ClientProducer producer2 = session.createProducer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ2).toString());
        for (int i3 = 0; i3 < 3; ++i3) {
            producer2.send((Message)session.createMessage(false));
        }
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> this.server.locateQueue(this.anycastQ2).getMessageCount() == 3L, (long)2000L, (long)200L));
        ClientProducer producer3 = session.createProducer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ3).toString());
        for (int i4 = 0; i4 < 5; ++i4) {
            producer3.send((Message)session.createMessage(false));
        }
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> this.server.locateQueue(this.anycastQ3).getMessageCount() == 5L, (long)2000L, (long)200L));
        ClientConsumer consumer1 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ1));
        ClientConsumer consumer2 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ2));
        ClientConsumer consumer3 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ3));
        ClientMessage m = null;
        for (i = 0; i < 2; ++i) {
            m = consumer1.receive(2000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
        }
        for (i = 0; i < 3; ++i) {
            m = consumer2.receive(2000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
        }
        for (i = 0; i < 5; ++i) {
            m = consumer3.receive(2000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
        }
        session.commit();
        for (SimpleString q : new SimpleString[]{this.anycastQ1, this.anycastQ2, this.anycastQ3}) {
            QueueQueryResult query = this.server.queueQuery(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)q));
            Assertions.assertTrue((boolean)query.isExists());
            Assertions.assertEquals((Object)this.anycastAddress, (Object)query.getAddress());
            Assertions.assertEquals((Object)q, (Object)query.getName());
            Assertions.assertEquals((long)0L, (long)query.getMessageCount());
        }
    }

    @Test
    public void testSpecialCase() throws Exception {
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.anycastQ1).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession();
        session.start();
        ClientProducer producer = session.createProducer(this.anycastAddress);
        this.sendMessages(session, producer, 1);
        ClientConsumer consumer1 = session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)SimpleString.of((String)""), (SimpleString)this.anycastQ1));
        session.start();
        ClientMessage m = consumer1.receive(2000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        session.commit();
        consumer1.close();
        try {
            session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)this.anycastQ1, (SimpleString)SimpleString.of((String)"")));
            Assertions.fail((String)"should get exception");
        }
        catch (ActiveMQNonExistentQueueException activeMQNonExistentQueueException) {
            // empty catch block
        }
        try {
            session.createConsumer(CompositeAddress.toFullyQualified((SimpleString)SimpleString.of((String)""), (SimpleString)SimpleString.of((String)"")));
            Assertions.fail((String)"should get exception");
        }
        catch (ActiveMQNonExistentQueueException activeMQNonExistentQueueException) {
            // empty catch block
        }
    }

    @Test
    public void testFilteredQueue() throws Exception {
        this.testFilteredQueue(true);
    }

    @Test
    public void testFilteredQueueNegative() throws Exception {
        this.testFilteredQueue(false);
    }

    private void testFilteredQueue(boolean useProperty) throws Exception {
        String key = "myKey";
        String value = RandomUtil.randomString();
        this.server.createQueue(new QueueConfiguration(this.anycastQ1).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST).setFilterString("myKey='" + value + "'"));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession();
        session.start();
        ClientProducer producer = session.createProducer(this.anycastAddress);
        ClientMessage m = session.createMessage(true);
        if (useProperty) {
            m.putStringProperty("myKey", value);
        }
        producer.send((Message)m);
        Wait.assertEquals((Long)1L, () -> this.server.getAddressInfo(this.anycastAddress).getRoutedMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)(useProperty ? 1L : 0L), () -> this.server.locateQueue(this.anycastQ1).getMessageCount(), (long)2000L, (long)100L);
    }
}

