/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.List;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ScheduledMessageRestartTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, false);
        this.server.start();
    }

    @Test
    public void testSchedulePropertyExistsAfterRestart() throws Exception {
        String queueName = RandomUtil.randomString();
        long scheduledTime = System.currentTimeMillis() * 2L;
        this.server.createQueue(QueueConfiguration.of((String)queueName).setAddress(queueName));
        ServerLocator locator = this.createInVMLocator(0);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession();
        ClientProducer producer = session.createProducer(queueName);
        ClientMessage m = session.createMessage(true);
        m.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, scheduledTime);
        producer.send((Message)m);
        locator.close();
        this.server.stop();
        this.server.start();
        List scheduledMessages = this.server.locateQueue(queueName).getScheduledMessages();
        Assertions.assertEquals((int)1, (int)scheduledMessages.size());
        Message serverMessage = ((MessageReference)scheduledMessages.get(0)).getMessage();
        Assertions.assertTrue((boolean)serverMessage.containsProperty(Message.HDR_SCHEDULED_DELIVERY_TIME));
        Assertions.assertEquals((long)scheduledTime, (long)serverMessage.getLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME));
    }
}

