/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.SingleServerTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransientQueueTest
extends SingleServerTestBase {
    @Override
    protected ActiveMQServer createServer() throws Exception {
        ActiveMQServer server = super.createServer();
        server.getConfiguration().setAddressQueueScanPeriod(100L);
        return server;
    }

    @Test
    public void testSimpleTransientQueue() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createSharedQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        Assertions.assertEquals((int)1, (int)this.server.getConnectionCount());
        ClientSession session2 = this.sf.createSession(false, true, true);
        this.session.close();
        session2.start();
        session2.createConsumer(queue);
        session2.close();
    }

    @Test
    public void testMultipleConsumers() throws Exception {
        int i;
        SimpleString queue = SimpleString.of((String)"queue");
        SimpleString address = SimpleString.of((String)"address");
        this.session.createSharedQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        Assertions.assertEquals((int)1, (int)this.server.getConnectionCount());
        Assertions.assertNotNull((Object)this.server.locateQueue(queue));
        ServerLocator locator2 = this.createLocator();
        ClientSessionFactory sf2 = locator2.createSessionFactory();
        ClientSession session2 = sf2.createSession(false, false);
        session2.createSharedQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientConsumer consumer1 = this.session.createConsumer(queue);
        ClientConsumer consumer2 = session2.createConsumer(queue);
        this.session.start();
        session2.start();
        ClientProducer producer = this.session.createProducer(address);
        for (int i2 = 0; i2 < 1000; ++i2) {
            ClientMessage msg = this.session.createMessage(false);
            producer.send((Message)msg);
        }
        for (i = 0; i < 500; ++i) {
            ClientMessage msg = consumer1.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
            msg = consumer2.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        Assertions.assertNull((Object)consumer1.receiveImmediate());
        Assertions.assertNull((Object)consumer2.receiveImmediate());
        for (i = 0; i < 1000; ++i) {
            ClientMessage msg = this.session.createMessage(false);
            producer.send((Message)msg);
        }
        ClientMessage msg = consumer1.receiveImmediate();
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        msg = consumer2.receiveImmediate();
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        consumer1.close();
        consumer2.close();
        Wait.assertTrue(() -> this.server.locateQueue(queue) == null && this.server.getAddressInfo(address) == null, (long)2000L, (long)100L);
        this.session.createSharedQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        Wait.assertTrue(() -> this.server.locateQueue(queue) != null && this.server.getAddressInfo(address) != null, (long)2000L, (long)100L);
        consumer1 = this.session.createConsumer(queue);
        Wait.assertTrue(() -> this.server.locateQueue(queue) != null, (long)2000L, (long)100L);
        Assertions.assertNull((Object)consumer1.receiveImmediate());
        consumer1.close();
        Wait.assertTrue(() -> this.server.locateQueue(queue) == null, (long)2000L, (long)100L);
    }

    @Test
    public void testQueueDifferentConfigs() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.server.locateQueue(queue);
        SimpleString address2 = RandomUtil.randomSimpleString();
        this.session.createSharedQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        Assertions.assertEquals((int)1, (int)this.server.getConnectionCount());
        ServerLocator locator2 = this.createLocator();
        ClientSessionFactory sf2 = locator2.createSessionFactory();
        ClientSession session2 = sf2.createSession(false, false);
        this.addClientSession(session2);
        boolean exHappened = false;
        try {
            session2.createSharedQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address2).setDurable(Boolean.valueOf(false)));
        }
        catch (ActiveMQInvalidTransientQueueUseException e) {
            exHappened = true;
        }
        Assertions.assertTrue((boolean)exHappened);
        exHappened = false;
        try {
            session2.createSharedQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setFilterString("a=1").setDurable(Boolean.valueOf(false)));
        }
        catch (ActiveMQInvalidTransientQueueUseException e) {
            exHappened = true;
        }
        Assertions.assertTrue((boolean)exHappened);
        this.session.createConsumer(queue).close();
        Wait.assertTrue(() -> this.server.locateQueue(queue) == null, (long)2000L, (long)100L);
        Wait.assertTrue(() -> this.server.getAddressInfo(queue) == null, (long)2000L, (long)100L);
        this.session.createSharedQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setFilterString("q=1").setDurable(Boolean.valueOf(false)));
        exHappened = false;
        try {
            session2.createSharedQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setFilterString("q=2").setDurable(Boolean.valueOf(false)));
        }
        catch (ActiveMQInvalidTransientQueueUseException e) {
            exHappened = true;
        }
        Assertions.assertTrue((boolean)exHappened);
        exHappened = false;
        try {
            session2.createSharedQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        }
        catch (ActiveMQInvalidTransientQueueUseException e) {
            exHappened = true;
        }
        Assertions.assertTrue((boolean)exHappened);
    }

    @Override
    protected ServerLocator createLocator() {
        return super.createLocator().setConsumerWindowSize(0).setBlockOnAcknowledge(true).setBlockOnDurableSend(false).setBlockOnNonDurableSend(false);
    }
}

