/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.bridge;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCounterOnBridgeFailoverTest
extends FailoverTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<String, Object> dc2Primary1Conf;
    private TransportConfiguration dc2Primary1tc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCounterAfterBridgeFailover() throws Exception {
        ActiveMQServer dc1Primary1 = this.primaryServer.getServer();
        ActiveMQServer dc1Backup1 = this.backupServer.getServer();
        ActiveMQServer dc2Primary1 = this.createClusteredServerWithParams(true, 3, true, this.dc2Primary1Conf);
        String bridgeName = "bridge1";
        String queueName0 = "queue0";
        logger.info("Starting remote cluster node  dc2Primary1");
        dc2Primary1.start();
        this.waitForServerToStart(dc2Primary1);
        try {
            Queue queue = dc2Primary1.createQueue(QueueConfiguration.of((String)"queue0").setDurable(Boolean.valueOf(true)));
            int messageSent = 2000;
            logger.info("Producing {} messages ", (Object)messageSent);
            try (ClientSessionFactory sessionFactory = this.createSessionFactory((ServerLocator)this.getServerLocator());){
                ClientSession session1 = sessionFactory.createSession(false, false);
                QueueConfiguration queueConfiguration = QueueConfiguration.of((String)"queue0").setDurable(Boolean.valueOf(true));
                session1.createQueue(queueConfiguration);
                ClientProducer producerServer1 = session1.createProducer("queue0");
                for (int i = 0; i < messageSent; ++i) {
                    ClientMessage msg = session1.createMessage(true);
                    if (i % 2 == 0) {
                        PageCounterOnBridgeFailoverTest.setLargeMessageBody(0, msg);
                    } else {
                        this.setBody(i, msg);
                    }
                    producerServer1.send((Message)msg);
                }
                session1.commit();
                producerServer1.close();
                session1.close();
            }
            BridgeConfiguration bridgeConfiguration = new BridgeConfiguration().setName("bridge1").setQueueName("queue0").setRetryInterval(1000L).setUseDuplicateDetection(true).setStaticConnectors(List.of(this.dc2Primary1tc.getName()));
            logger.info("Starting bridge: " + bridgeConfiguration.getName());
            dc1Primary1.getClusterManager().deployBridge(bridgeConfiguration);
            Wait.waitFor(() -> messageSent - this.getMessageCount(dc1Primary1, "queue0") > 100);
            logger.info("Stopping dc1Primary1");
            dc1Primary1.stop();
            logger.info("Waiting for dc1Backup1 to be alive");
            Wait.waitFor(() -> ((ActiveMQServer)dc1Backup1).isActive(), (long)15000L);
            logger.info("dc1Backup1 isAlive");
            long messageCountNodeDC2 = this.getMessageCount(dc2Primary1, "queue0");
            dc1Backup1.getClusterManager().deployBridge(bridgeConfiguration);
            Wait.assertEquals((int)messageSent, () -> this.getMessageCount(dc2Primary1, "queue0"));
            Wait.assertEquals((int)0, () -> this.getMessageCount(dc1Backup1, "queue0"));
        }
        finally {
            dc2Primary1.stop();
        }
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean primary) {
        return TransportConfigurationUtils.getInVMAcceptor(primary);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean primary) {
        return TransportConfigurationUtils.getInVMConnector(primary);
    }

    @Override
    protected void createConfigs() throws Exception {
        this.dc2Primary1Conf = new HashMap<String, Object>();
        this.dc2Primary1Conf.put("host", "localhost");
        this.dc2Primary1Conf.put("port", 61619);
        this.dc2Primary1tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY, this.dc2Primary1Conf);
        this.nodeManager = new InVMNodeManager(false);
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultConfig(true).setPersistenceEnabled(true).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration().setScaleDownConfiguration(new ScaleDownConfiguration().setEnabled(false)).setRestartBackup(false)).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addConnectorConfiguration(this.dc2Primary1tc.getName(), this.dc2Primary1tc).addClusterConfiguration(PageCounterOnBridgeFailoverTest.basicClusterConnectionConfig(backupConnector.getName(), primaryConnector.getName())).addAddressSetting("#", new AddressSettings().setMaxSizeBytes(1L).setMaxReadPageBytes(-1).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.primaryConfig = super.createDefaultConfig(true).setPersistenceEnabled(true).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration().setFailoverOnServerShutdown(true)).addClusterConfiguration(PageCounterOnBridgeFailoverTest.basicClusterConnectionConfig(primaryConnector.getName(), new String[0])).addConnectorConfiguration(this.dc2Primary1tc.getName(), this.dc2Primary1tc).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addAddressSetting("#", new AddressSettings().setMaxSizeBytes(1L).setMaxReadPageMessages(-1).setMaxReadPageBytes(-1).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE));
        this.primaryServer = this.createTestableServer(this.primaryConfig);
    }
}

