/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.util;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.BeforeEach;

public class MultiServerTestBase
extends ActiveMQTestBase {
    protected ActiveMQServer[] servers;
    protected ActiveMQServer[] backupServers;
    protected NodeManager[] nodeManagers;

    protected int getNumberOfServers() {
        return 5;
    }

    protected boolean useBackups() {
        return true;
    }

    protected boolean useRealFiles() {
        return true;
    }

    protected boolean useNetty() {
        return false;
    }

    protected boolean useSharedStorage() {
        return true;
    }

    protected final ServerLocator createLocator(boolean ha, int serverID) {
        TransportConfiguration targetConfig = MultiServerTestBase.createTransportConfiguration(this.useNetty(), false, MultiServerTestBase.generateParams(serverID, this.useNetty()));
        if (ha) {
            ServerLocator locator = ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{targetConfig});
            return this.addServerLocator(locator);
        }
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{targetConfig});
        return this.addServerLocator(locator);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.servers = new ActiveMQServer[this.getNumberOfServers()];
        if (this.useBackups()) {
            this.backupServers = new ActiveMQServer[this.getNumberOfServers()];
        }
        if (this.useBackups()) {
            this.nodeManagers = new NodeManager[this.getNumberOfServers()];
        }
        for (int i = 0; i < this.getNumberOfServers(); ++i) {
            Pair<ActiveMQServer, NodeManager> nodeServer = this.setupPrimaryServer(i, this.useRealFiles(), this.useSharedStorage());
            this.servers[i] = (ActiveMQServer)nodeServer.getA();
            if (!this.useBackups()) continue;
            this.nodeManagers[i] = (NodeManager)nodeServer.getB();
            this.backupServers[i] = this.setupBackupServer(i + this.getNumberOfServers(), i, (NodeManager)nodeServer.getB());
        }
    }

    protected void startServers() throws Exception {
        for (ActiveMQServer server : this.servers) {
            server.start();
        }
        for (ActiveMQServer server : this.servers) {
            this.waitForServerToStart(server);
        }
        if (this.backupServers != null) {
            for (ActiveMQServer server : this.backupServers) {
                server.start();
            }
            for (ActiveMQServer server : this.backupServers) {
                this.waitForServerToStart(server);
            }
        }
        for (ActiveMQServer server : this.servers) {
            MultiServerTestBase.waitForTopology(server, this.getNumberOfServers(), this.useBackups() ? this.getNumberOfServers() : 0);
        }
    }

    public void startServers(int ... serverID) throws Exception {
        for (int s : serverID) {
            this.servers[s].start();
            this.waitForServerToStart(this.servers[s]);
        }
    }

    public void startBackups(int ... serverID) throws Exception {
        for (int s : serverID) {
            this.backupServers[s].start();
            this.waitForServerToStart(this.backupServers[s]);
        }
    }

    protected Pair<ActiveMQServer, NodeManager> setupPrimaryServer(int node, boolean realFiles, boolean sharedStorage) throws Exception {
        InVMNodeManager nodeManager = null;
        TransportConfiguration serverConfigAcceptor = MultiServerTestBase.createTransportConfiguration(this.useNetty(), true, MultiServerTestBase.generateParams(node, this.useNetty()));
        TransportConfiguration thisConnector = MultiServerTestBase.createTransportConfiguration(this.useNetty(), false, MultiServerTestBase.generateParams(node, this.useNetty()));
        if (sharedStorage) {
            nodeManager = new InVMNodeManager(false);
        }
        ConfigurationImpl configuration = this.createBasicConfig(node).setJournalMaxIO_AIO(1000).setThreadPoolMaxSize(10).clearAcceptorConfigurations().addAcceptorConfiguration(serverConfigAcceptor).addConnectorConfiguration("thisConnector", thisConnector).setHAPolicyConfiguration((HAPolicyConfiguration)(sharedStorage ? new SharedStorePrimaryPolicyConfiguration() : new ReplicatedPolicyConfiguration()));
        ArrayList<CallSite> targetServersOnConnection = new ArrayList<CallSite>();
        for (int targetNode = 0; targetNode < this.getNumberOfServers(); ++targetNode) {
            if (targetNode == node) continue;
            String targetConnectorName = "target-" + targetNode;
            TransportConfiguration targetServer = MultiServerTestBase.createTransportConfiguration(this.useNetty(), false, MultiServerTestBase.generateParams(targetNode, this.useNetty()));
            configuration.getConnectorConfigurations().put(targetConnectorName, targetServer);
            targetServersOnConnection.add((CallSite)((Object)targetConnectorName));
            String backupConnectorName = "backup-" + targetNode;
            TransportConfiguration backupConnector = MultiServerTestBase.createTransportConfiguration(this.useNetty(), false, MultiServerTestBase.generateParams(targetNode + this.getNumberOfServers(), this.useNetty()));
            configuration.getConnectorConfigurations().put(backupConnectorName, backupConnector);
        }
        ClusterConnectionConfiguration clusterConf = new ClusterConnectionConfiguration().setName("localCluster" + node).setAddress("cluster-queues").setConnectorName("thisConnector").setRetryInterval(100L).setConfirmationWindowSize(1024).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(targetServersOnConnection);
        configuration.getClusterConfigurations().add(clusterConf);
        ActiveMQServer server = sharedStorage ? this.createInVMFailoverServer(realFiles, (Configuration)configuration, (NodeManager)nodeManager, node) : this.createServer(realFiles, (Configuration)configuration);
        server.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/Primary(" + node + ")");
        this.addServer(server);
        return new Pair((Object)server, (Object)nodeManager);
    }

    protected ActiveMQServer setupBackupServer(int node, int primaryNode, NodeManager nodeManager) throws Exception {
        TransportConfiguration serverConfigAcceptor = MultiServerTestBase.createTransportConfiguration(this.useNetty(), true, MultiServerTestBase.generateParams(node, this.useNetty()));
        TransportConfiguration thisConnector = MultiServerTestBase.createTransportConfiguration(this.useNetty(), false, MultiServerTestBase.generateParams(node, this.useNetty()));
        ConfigurationImpl configuration = this.createBasicConfig(this.useSharedStorage() ? primaryNode : node).clearAcceptorConfigurations().addAcceptorConfiguration(serverConfigAcceptor).addConnectorConfiguration("thisConnector", thisConnector).setHAPolicyConfiguration((HAPolicyConfiguration)(this.useSharedStorage() ? new SharedStoreBackupPolicyConfiguration() : new ReplicaPolicyConfiguration()));
        ArrayList<CallSite> targetServersOnConnection = new ArrayList<CallSite>();
        for (int targetNode = 0; targetNode < this.getNumberOfServers(); ++targetNode) {
            String targetConnectorName = "targetConnector-" + targetNode;
            TransportConfiguration targetServer = MultiServerTestBase.createTransportConfiguration(this.useNetty(), false, MultiServerTestBase.generateParams(targetNode, this.useNetty()));
            configuration.addConnectorConfiguration(targetConnectorName, targetServer);
            targetServersOnConnection.add((CallSite)((Object)targetConnectorName));
        }
        ClusterConnectionConfiguration clusterConf = new ClusterConnectionConfiguration().setName("localCluster" + node).setAddress("cluster-queues").setConnectorName("thisConnector").setRetryInterval(100L).setConfirmationWindowSize(1024).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(targetServersOnConnection);
        configuration.getClusterConfigurations().add(clusterConf);
        ActiveMQServer server = this.useSharedStorage() ? this.createInVMFailoverServer(true, (Configuration)configuration, nodeManager, primaryNode) : this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)this.useRealFiles()));
        server.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/Backup(" + node + " of primary " + primaryNode + ")");
        return server;
    }
}

