/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueRequestor;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JMSMismatchedRoutingTypeTest
extends MultiprotocolJMSClientTestSupport {
    protected final String ANYCAST_ADDRESS = RandomUtil.randomString();
    protected final String MULTICAST_ADDRESS = RandomUtil.randomString();

    @Override
    protected boolean isAutoCreateAddresses() {
        return false;
    }

    @Override
    protected boolean isAutoCreateQueues() {
        return false;
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)this.ANYCAST_ADDRESS), RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((String)RandomUtil.randomString()).setAddress(this.ANYCAST_ADDRESS).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)this.MULTICAST_ADDRESS), RoutingType.MULTICAST));
        server.createQueue(QueueConfiguration.of((String)RandomUtil.randomString()).setAddress(this.MULTICAST_ADDRESS).setRoutingType(RoutingType.MULTICAST));
    }

    @Test
    public void testSendingMulticastToAnycastAMQP() throws Exception {
        this.internalTestSendingMulticastToAnycast(this.AMQPConnection);
    }

    @Test
    public void testSendingMulticastToAnycastCore() throws Exception {
        this.internalTestSendingMulticastToAnycast(this.CoreConnection);
    }

    @Test
    public void testSendingMulticastToAnycastOpenWire() throws Exception {
        this.internalTestSendingMulticastToAnycast(this.OpenWireConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTestSendingMulticastToAnycast(MultiprotocolJMSClientTestSupport.ConnectionSupplier connectionSupplier) throws Exception {
        try (Connection connection = null;){
            connection = connectionSupplier.createConnection();
            Session s = connection.createSession(false, 1);
            Topic topic = s.createTopic(this.ANYCAST_ADDRESS);
            MessageProducer producer = s.createProducer((Destination)topic);
            producer.send(s.createMessage());
            Assertions.fail((String)"Sending message here should fail!");
        }
    }

    @Test
    public void testSendingAnycastToMulticastAMQP() throws Exception {
        this.internalTestSendingAnycastToMulticast(this.AMQPConnection);
    }

    @Test
    public void testSendingAnycastToMulticastCore() throws Exception {
        this.internalTestSendingAnycastToMulticast(this.CoreConnection);
    }

    @Test
    public void testSendingAnycastToMulticastOpenWire() throws Exception {
        this.internalTestSendingAnycastToMulticast(this.OpenWireConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void internalTestSendingAnycastToMulticast(MultiprotocolJMSClientTestSupport.ConnectionSupplier connectionSupplier) throws Exception {
        block11: {
            connection = null;
            connection = connectionSupplier.createConnection();
            s = connection.createSession(false, 1);
            try {
                q = s.createQueue(this.MULTICAST_ADDRESS);
            }
            catch (JMSException e) {
                if (connection instanceof ActiveMQConnection) {
                    if (connection != null) {
                        connection.close();
                    }
                    return;
                }
                throw e;
            }
            ** try [egrp 3[TRYBLOCK] [1 : 56->88)] { 
lbl-1000:
            // 1 sources

            {
                producer = s.createProducer((Destination)q);
                producer.send(s.createMessage());
                Assertions.fail((String)"Sending message here should fail!");
            }
lbl20:
            // 1 sources

            catch (InvalidDestinationException var5_7) {
                // empty catch block
            }
            {
                break block11;
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    @Test
    public void testManagementQueueRequestorAMQP() throws Exception {
        this.internalTestManagementQueueRequestor(this.AMQPConnection);
    }

    @Test
    public void testManagementQueueRequestorCore() throws Exception {
        this.internalTestManagementQueueRequestor(this.CoreConnection);
    }

    @Test
    public void testManagementQueueRequestorOpenWire() throws Exception {
        this.internalTestManagementQueueRequestor(this.OpenWireConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTestManagementQueueRequestor(MultiprotocolJMSClientTestSupport.ConnectionSupplier connectionSupplier) throws Exception {
        try (Connection connection = null;){
            connection = connectionSupplier.createConnection();
            Session session = connection.createSession(false, 1);
            Queue managementQueue = session.createQueue(this.server.getConfiguration().getManagementAddress().toString());
            QueueRequestor requestor = new QueueRequestor((QueueSession)session, managementQueue);
            connection.start();
            Message m = session.createMessage();
            Message response = requestor.request(m);
            Assertions.assertNotNull((Object)response);
        }
    }
}

