/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.management.ClusterConnectionControl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClusterConnectionControl2Test
extends ManagementTestBase {
    private ActiveMQServer server0;
    private ActiveMQServer server1;
    private MBeanServer mbeanServer_1;
    private final int port_1 = 62616;
    private ClusterConnectionConfiguration clusterConnectionConfig_0;
    private final String clusterName = "cluster";

    @Test
    public void testNodes() throws Exception {
        ClusterConnectionControl clusterConnectionControl_0 = this.createManagementControl(this.clusterConnectionConfig_0.getName());
        Assertions.assertTrue((boolean)clusterConnectionControl_0.isStarted());
        Map nodes = clusterConnectionControl_0.getNodes();
        Assertions.assertEquals((int)0, (int)nodes.size());
        this.server1.start();
        this.waitForServerToStart(this.server1);
        long start = System.currentTimeMillis();
        while ((nodes = clusterConnectionControl_0.getNodes()).size() != 1 && System.currentTimeMillis() - start <= 30000L) {
            Thread.sleep(50L);
        }
        Assertions.assertEquals((int)1, (int)nodes.size());
        String remoteAddress = (String)nodes.values().iterator().next();
        Assertions.assertTrue((boolean)remoteAddress.endsWith(":62616"));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        String discoveryName = RandomUtil.randomString();
        String groupAddress = ClusterConnectionControl2Test.getUDPDiscoveryAddress();
        int groupPort = ClusterConnectionControl2Test.getUDPDiscoveryPort();
        HashMap<String, Integer> acceptorParams_1 = new HashMap<String, Integer>();
        acceptorParams_1.put("port", 62616);
        TransportConfiguration acceptorConfig_0 = new TransportConfiguration(ActiveMQTestBase.NETTY_ACCEPTOR_FACTORY);
        TransportConfiguration acceptorConfig_1 = new TransportConfiguration(ActiveMQTestBase.NETTY_ACCEPTOR_FACTORY, acceptorParams_1);
        TransportConfiguration connectorConfig_1 = new TransportConfiguration(ActiveMQTestBase.NETTY_CONNECTOR_FACTORY, acceptorParams_1);
        TransportConfiguration connectorConfig_0 = new TransportConfiguration(ActiveMQTestBase.NETTY_CONNECTOR_FACTORY);
        QueueConfiguration queueConfig = QueueConfiguration.of((String)RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        ArrayList<String> connectorInfos = new ArrayList<String>();
        connectorInfos.add("netty");
        BroadcastGroupConfiguration broadcastGroupConfig = new BroadcastGroupConfiguration().setName(discoveryName).setBroadcastPeriod(250L).setConnectorInfos(connectorInfos).setEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(groupPort));
        DiscoveryGroupConfiguration discoveryGroupConfig = new DiscoveryGroupConfiguration().setName(discoveryName).setRefreshTimeout(0L).setDiscoveryInitialWaitTimeout(0L).setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(groupPort));
        this.clusterConnectionConfig_0 = new ClusterConnectionConfiguration().setName("cluster").setAddress(queueConfig.getAddress().toString()).setConnectorName("netty").setRetryInterval(1000L).setDuplicateDetection(false).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setMaxHops(1).setConfirmationWindowSize(1024).setDiscoveryGroupName(discoveryName);
        ConfigurationImpl conf_1 = this.createBasicConfig().addClusterConfiguration(this.clusterConnectionConfig_0).addAcceptorConfiguration(acceptorConfig_1).addConnectorConfiguration("netty", connectorConfig_1).addQueueConfiguration(queueConfig).addDiscoveryGroupConfiguration(discoveryName, discoveryGroupConfig).addBroadcastGroupConfiguration(broadcastGroupConfig);
        ConfigurationImpl conf_0 = this.createBasicConfig(1).addClusterConfiguration(this.clusterConnectionConfig_0).addAcceptorConfiguration(acceptorConfig_0).addConnectorConfiguration("netty", connectorConfig_0).addDiscoveryGroupConfiguration(discoveryName, discoveryGroupConfig).addBroadcastGroupConfiguration(broadcastGroupConfig);
        this.mbeanServer_1 = this.createMBeanServer();
        this.server1 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_1, (MBeanServer)this.mbeanServer_1, (boolean)false));
        this.server0 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_0, (MBeanServer)this.mbeanServer, (boolean)false));
        this.server0.start();
        this.waitForServerToStart(this.server0);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected ClusterConnectionControl createManagementControl(String name) throws Exception {
        return ManagementControlHelper.createClusterConnectionControl(name, this.mbeanServer);
    }
}

