/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class BasicOpenWireTest
extends OpenWireTestBase {
    protected ActiveMQConnectionFactory factory;
    protected ActiveMQConnectionFactory looseFactory;
    protected ActiveMQXAConnectionFactory xaFactory;
    protected ActiveMQConnection connection;
    protected String topicName = "amqTestTopic1";
    protected String queueName = "amqTestQueue1";
    protected String topicName2 = "amqTestTopic2";
    protected String queueName2 = "amqTestQueue2";
    protected String durableQueueName = "durableQueueName";
    protected String messageTextPrefix = "";
    protected boolean topic = true;
    protected Map<String, SimpleString> testQueues = new HashMap<String, SimpleString>();

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("org.apache.activemq.transport.AbstractInactivityMonitor.keepAliveTime", "5");
        this.createFactories();
        SimpleString coreQueue = SimpleString.of((String)this.queueName);
        this.server.createQueue(QueueConfiguration.of((SimpleString)coreQueue).setRoutingType(RoutingType.ANYCAST));
        this.testQueues.put(this.queueName, coreQueue);
        SimpleString coreQueue2 = SimpleString.of((String)this.queueName2);
        this.server.createQueue(QueueConfiguration.of((SimpleString)coreQueue2).setRoutingType(RoutingType.ANYCAST));
        this.testQueues.put(this.queueName2, coreQueue2);
        SimpleString durableQueue = SimpleString.of((String)this.durableQueueName);
        this.server.createQueue(QueueConfiguration.of((SimpleString)durableQueue).setRoutingType(RoutingType.ANYCAST));
        this.testQueues.put(this.durableQueueName, durableQueue);
        if (!this.enableSecurity) {
            this.connection = (ActiveMQConnection)this.factory.createConnection();
        }
    }

    protected void createFactories() {
        this.factory = new ActiveMQConnectionFactory(this.getConnectionUrl());
        this.looseFactory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.tightEncodingEnabled=false");
        this.xaFactory = new ActiveMQXAConnectionFactory(this.getConnectionUrl());
    }

    protected String getConnectionUrl() {
        return "tcp://localhost:61616?wireFormat.cacheEnabled=true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("org.apache.activemq.transport.AbstractInactivityMonitor.keepAliveTime");
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            for (SimpleString coreQ : this.testQueues.values()) {
                try {
                    this.server.destroyQueue(coreQ, null, false, true);
                }
                catch (ActiveMQNonExistentQueueException activeMQNonExistentQueueException) {
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            this.testQueues.clear();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            super.tearDown();
        }
    }

    public ActiveMQDestination createDestination(Session session, byte type, String name) throws Exception {
        if (name == null) {
            return this.createDestination(session, type);
        }
        switch (type) {
            case 1: {
                this.makeSureCoreQueueExist(name);
                return (ActiveMQDestination)session.createQueue(name);
            }
            case 2: {
                return (ActiveMQDestination)session.createTopic(name);
            }
            case 5: {
                return (ActiveMQDestination)session.createTemporaryQueue();
            }
            case 6: {
                return (ActiveMQDestination)session.createTemporaryTopic();
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    public void makeSureCoreQueueExist(String qname) throws Exception {
        SimpleString coreQ = this.testQueues.get(qname);
        if (coreQ == null) {
            coreQ = SimpleString.of((String)qname);
            this.server.createQueue(QueueConfiguration.of((SimpleString)coreQ).setRoutingType(RoutingType.ANYCAST));
            this.testQueues.put(qname, coreQ);
        }
    }

    public ActiveMQDestination createDestination(Session session, byte type) throws JMSException {
        switch (type) {
            case 1: {
                return (ActiveMQDestination)session.createQueue(this.queueName);
            }
            case 2: {
                return (ActiveMQDestination)session.createTopic(this.topicName);
            }
            case 5: {
                return (ActiveMQDestination)session.createTemporaryQueue();
            }
            case 6: {
                return (ActiveMQDestination)session.createTemporaryTopic();
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    protected ActiveMQDestination createDestination2(Session session, byte type) throws JMSException {
        switch (type) {
            case 1: {
                return (ActiveMQDestination)session.createQueue(this.queueName2);
            }
            case 2: {
                return (ActiveMQDestination)session.createTopic(this.topicName2);
            }
            case 5: {
                return (ActiveMQDestination)session.createTemporaryQueue();
            }
            case 6: {
                return (ActiveMQDestination)session.createTemporaryTopic();
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    protected void sendMessages(Session session, Destination destination, int count) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        this.sendMessages(session, producer, count);
        producer.close();
    }

    protected void sendMessages(Session session, MessageProducer producer, int count) throws JMSException {
        for (int i = 0; i < count; ++i) {
            producer.send((Message)session.createTextMessage(this.messageTextPrefix + i));
        }
    }

    protected void sendMessages(Connection connection, Destination destination, int count) throws JMSException {
        Session session = connection.createSession(false, 1);
        this.sendMessages(session, destination, count);
        session.close();
    }

    protected void assertTextMessagesEqual(String messsage, Message[] firstSet, Message[] secondSet) throws JMSException {
        Assertions.assertEquals((int)firstSet.length, (int)secondSet.length, (String)("Message count does not match: " + messsage));
        for (int i = 0; i < secondSet.length; ++i) {
            TextMessage m1 = (TextMessage)firstSet[i];
            TextMessage m2 = (TextMessage)secondSet[i];
            Assertions.assertFalse((boolean)(m1 == null ^ m2 == null), (String)("Message " + (i + 1) + " did not match : " + messsage + ": expected {" + m1 + "}, but was {" + m2 + "}"));
            Assertions.assertEquals((Object)m1.getText(), (Object)m2.getText(), (String)("Message " + (i + 1) + " did not match: " + messsage + ": expected {" + m1 + "}, but was {" + m2 + "}"));
        }
    }

    protected Connection createConnection() throws JMSException {
        return this.factory.createConnection();
    }

    protected void safeClose(Session s) {
        try {
            s.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

