/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import jakarta.jms.XAJMSContext;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ResourceAdapter;
import java.util.HashSet;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactoryImpl;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.apache.activemq.artemis.tests.integration.ra.DummyTransactionSynchronizationRegistry;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JMSContextTest
extends ActiveMQRATestBase {
    private ActiveMQResourceAdapter resourceAdapter;
    private DummyTransactionSynchronizationRegistry tsr;
    ActiveMQRAConnectionManager qraConnectionManager = new ActiveMQRAConnectionManager();
    private ActiveMQRAConnectionFactory qraConnectionFactory;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("testuser", "testpassword");
        securityManager.getConfiguration().addUser("guest", "guest");
        securityManager.getConfiguration().setDefaultUser("guest");
        securityManager.getConfiguration().addRole("testuser", "arole");
        securityManager.getConfiguration().addRole("guest", "arole");
        Role role = new Role("arole", true, true, true, true, true, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("mdbQueue", roles);
        this.resourceAdapter = new ActiveMQResourceAdapter();
        this.resourceAdapter.setConnectorClassName(InVMConnectorFactory.class.getName());
        this.tsr = new DummyTransactionSynchronizationRegistry();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext().setTransactionSynchronizationRegistry(this.tsr);
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        this.qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
    }

    private void initRA(int status) throws ResourceException {
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
        this.qraConnectionManager.stop();
        super.tearDown();
    }

    @Test
    public void testCreateContextThrowsException() throws Exception {
        JMSContext jmsctx = this.qraConnectionFactory.createContext();
        try {
            jmsctx.createContext(1);
            Assertions.fail((String)"expected JMSRuntimeException");
        }
        catch (JMSRuntimeException jMSRuntimeException) {
        }
        catch (Exception e) {
            Assertions.fail((String)("wrong exception thrown: " + e));
        }
    }

    @Test
    public void testCreateXAContextThrowsException() throws Exception {
        XAJMSContext jmsctx = this.qraConnectionFactory.createXAContext();
        try {
            jmsctx.createContext(1);
            Assertions.fail((String)"expected JMSRuntimeException");
        }
        catch (JMSRuntimeException jMSRuntimeException) {
        }
        catch (Exception e) {
            Assertions.fail((String)("wrong exception thrown: " + e));
        }
    }

    @Test
    public void sessionTransactedTestActiveJTATx() throws Exception {
        try {
            this.qraConnectionFactory.createContext(0);
            Assertions.fail();
        }
        catch (JMSRuntimeException jMSRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void sessionTransactedTestNoActiveJTATx() throws Exception {
        this.tsr.setStatus(0);
        JMSContext context = this.qraConnectionFactory.createContext(0);
        Assertions.assertEquals((int)context.getSessionMode(), (int)1);
    }

    @Test
    public void clientAckTestActiveJTATx() throws Exception {
        try {
            this.qraConnectionFactory.createContext(2);
            Assertions.fail();
        }
        catch (JMSRuntimeException jMSRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void clientAckTestNoActiveJTATx() throws Exception {
        this.tsr.setStatus(0);
        JMSContext context = this.qraConnectionFactory.createContext(2);
        Assertions.assertEquals((int)context.getSessionMode(), (int)1);
    }

    @Test
    public void testJMSContextConsumerThrowsMessageFormatExceptionOnMalformedBody() throws Exception {
        Queue queue = this.createQueue(true, "ContextMalformedBodyTestQueue");
        JMSContext context = this.qraConnectionFactory.createContext();
        JMSProducer producer = context.createProducer();
        TextMessage message = context.createTextMessage("TestMessage");
        producer.send((Destination)queue, (Message)message);
        JMSConsumer consumer = context.createConsumer((Destination)queue);
        try {
            consumer.receiveBody(Boolean.class);
            Assertions.fail((String)"Should thrown MessageFormatException");
        }
        catch (MessageFormatRuntimeException messageFormatRuntimeException) {
        }
        catch (Exception e) {
            Assertions.fail((String)("Threw wrong exception, should be MessageFormatRuntimeException, instead got: " + e.getClass().getCanonicalName()));
        }
    }
}

