/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.paging.impl;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.HierarchicalObjectRepository;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.collections.LinkedList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PagingManagerImplTest
extends ActiveMQTestBase {
    private final ReentrantReadWriteLock.ReadLock lock = new ReentrantReadWriteLock().readLock();

    @Test
    public void testPagingManager() throws Exception {
        HierarchicalObjectRepository addressSettings = new HierarchicalObjectRepository();
        addressSettings.setDefault((Object)new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE));
        NullStorageManager storageManager = new NullStorageManager();
        PagingStoreFactoryNIO storeFactory = new PagingStoreFactoryNIO((StorageManager)storageManager, this.getPageDirFile(), 100L, null, (ExecutorFactory)this.getOrderedExecutor(), (ExecutorFactory)this.getOrderedExecutor(), true, null);
        PagingManagerImpl managerImpl = new PagingManagerImpl((PagingStoreFactory)storeFactory, (HierarchicalRepository)addressSettings);
        managerImpl.start();
        this.runAfter(() -> ((PagingManagerImpl)managerImpl).stop());
        PagingStore store = managerImpl.getPageStore(SimpleString.of((String)"simple-test"));
        ICoreMessage msg = this.createMessage(1L, SimpleString.of((String)"simple-test"), this.createRandomBuffer(10));
        RoutingContextImpl ctx = new RoutingContextImpl(null);
        Assertions.assertFalse((boolean)store.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(store.getStoreName())));
        store.startPaging();
        Assertions.assertTrue((boolean)store.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(store.getStoreName())));
        Page page = store.depage();
        page.open(true);
        LinkedList msgs = page.read((StorageManager)new NullStorageManager());
        page.close(false, false);
        Assertions.assertEquals((int)1, (int)msgs.size());
        ActiveMQTestBase.assertEqualsByteArrays(msg.getBodyBuffer().writerIndex(), msg.getBodyBuffer().toByteBuffer().array(), ((PagedMessage)msgs.get(0)).getMessage().toCore().getBodyBuffer().toByteBuffer().array());
        Assertions.assertTrue((boolean)store.isPaging());
        Assertions.assertNull((Object)store.depage());
        RoutingContextImpl ctx2 = new RoutingContextImpl(null);
        Assertions.assertFalse((boolean)store.page((Message)msg, ctx2.getTransaction(), ctx2.getContextListing(store.getStoreName())));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        File fileJournalDir = new File(this.getJournalDir());
        fileJournalDir.mkdirs();
        File pageDirDir = new File(this.getPageDir());
        pageDirDir.mkdirs();
    }

    protected ICoreMessage createMessage(long messageId, SimpleString destination, ByteBuffer buffer) {
        CoreMessage msg = new CoreMessage(messageId, 200);
        msg.setAddress(destination);
        msg.getBodyBuffer().writeBytes(buffer);
        return msg;
    }

    protected ByteBuffer createRandomBuffer(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (int j = 0; j < buffer.limit(); ++j) {
            buffer.put(RandomUtil.randomByte());
        }
        return buffer;
    }
}

