/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.jms.client;

import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.SelectorTranslator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SelectorTranslatorTest
extends ActiveMQTestBase {
    @Test
    public void testParseNull() {
        Assertions.assertNull((Object)SelectorTranslator.convertToActiveMQFilterString(null));
    }

    @Test
    public void testParseSimple() {
        String selector = "color = 'red'";
        Assertions.assertEquals((Object)"color = 'red'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)"color = 'red'"));
    }

    @Test
    public void testParseMoreComplex() {
        String selector = "color = 'red' OR cheese = 'stilton' OR (age = 3 AND shoesize = 12)";
        Assertions.assertEquals((Object)"color = 'red' OR cheese = 'stilton' OR (age = 3 AND shoesize = 12)", (Object)SelectorTranslator.convertToActiveMQFilterString((String)"color = 'red' OR cheese = 'stilton' OR (age = 3 AND shoesize = 12)"));
    }

    @Test
    public void testParseJMSDeliveryMode() {
        String selector = "JMSDeliveryMode='NON_PERSISTENT'";
        Assertions.assertEquals((Object)"AMQDurable='NON_DURABLE'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "JMSDeliveryMode='PERSISTENT'";
        Assertions.assertEquals((Object)"AMQDurable='DURABLE'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "color = 'red' AND 'NON_PERSISTENT' = JMSDeliveryMode";
        Assertions.assertEquals((Object)"color = 'red' AND 'NON_DURABLE' = AMQDurable", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "color = 'red' AND 'PERSISTENT' = JMSDeliveryMode";
        Assertions.assertEquals((Object)"color = 'red' AND 'DURABLE' = AMQDurable", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSDeliveryMode");
    }

    @Test
    public void testParseJMSPriority() {
        String selector = "JMSPriority=5";
        Assertions.assertEquals((Object)"AMQPriority=5", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSPriority = 7";
        Assertions.assertEquals((Object)" AMQPriority = 7", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSPriority = 7 OR 1 = JMSPriority AND (JMSPriority= 1 + 4)";
        Assertions.assertEquals((Object)" AMQPriority = 7 OR 1 = AMQPriority AND (AMQPriority= 1 + 4)", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSPriority");
        selector = "animal = 'lion' JMSPriority = 321 OR animal_name = 'xyzJMSPriorityxyz'";
        Assertions.assertEquals((Object)"animal = 'lion' AMQPriority = 321 OR animal_name = 'xyzJMSPriorityxyz'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
    }

    @Test
    public void testParseJMSMessageID() {
        String selector = "JMSMessageID='ID:AMQ-12435678";
        Assertions.assertEquals((Object)"AMQUserID='ID:AMQ-12435678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSMessageID='ID:AMQ-12435678";
        Assertions.assertEquals((Object)" AMQUserID='ID:AMQ-12435678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSMessageID = 'ID:AMQ-12435678";
        Assertions.assertEquals((Object)" AMQUserID = 'ID:AMQ-12435678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSMessageID";
        Assertions.assertEquals((Object)" myHeader = AMQUserID", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSMessageID OR (JMSMessageID = 'ID-AMQ' + '12345')";
        Assertions.assertEquals((Object)" myHeader = AMQUserID OR (AMQUserID = 'ID-AMQ' + '12345')", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSMessageID");
    }

    @Test
    public void testParseJMSTimestamp() {
        String selector = "JMSTimestamp=12345678";
        Assertions.assertEquals((Object)"AMQTimestamp=12345678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSTimestamp=12345678";
        Assertions.assertEquals((Object)" AMQTimestamp=12345678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSTimestamp=12345678 OR 78766 = JMSTimestamp AND (JMSTimestamp= 1 + 4878787)";
        Assertions.assertEquals((Object)" AMQTimestamp=12345678 OR 78766 = AMQTimestamp AND (AMQTimestamp= 1 + 4878787)", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSTimestamp");
        selector = "animal = 'lion' JMSTimestamp = 321 OR animal_name = 'xyzJMSTimestampxyz'";
        Assertions.assertEquals((Object)"animal = 'lion' AMQTimestamp = 321 OR animal_name = 'xyzJMSTimestampxyz'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
    }

    @Test
    public void testParseJMSExpiration() {
        String selector = "JMSExpiration=12345678";
        Assertions.assertEquals((Object)"AMQExpiration=12345678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSExpiration=12345678";
        Assertions.assertEquals((Object)" AMQExpiration=12345678", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSExpiration=12345678 OR 78766 = JMSExpiration AND (JMSExpiration= 1 + 4878787)";
        Assertions.assertEquals((Object)" AMQExpiration=12345678 OR 78766 = AMQExpiration AND (AMQExpiration= 1 + 4878787)", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSExpiration");
        selector = "animal = 'lion' JMSExpiration = 321 OR animal_name = 'xyzJMSExpirationxyz'";
        Assertions.assertEquals((Object)"animal = 'lion' AMQExpiration = 321 OR animal_name = 'xyzJMSExpirationxyz'", (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
    }

    @Test
    public void testParseJMSCorrelationID() {
        String selector = "JMSCorrelationID='ID:AMQ-12435678";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSCorrelationID='ID:AMQ-12435678";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSCorrelationID = 'ID:AMQ-12435678";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSCorrelationID";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSCorrelationID OR (JMSCorrelationID = 'ID-AMQ' + '12345')";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSCorrelationID");
    }

    @Test
    public void testParseJMSType() {
        String selector = "JMSType='aardvark'";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSType='aardvark'";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " JMSType = 'aardvark'";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSType";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = " myHeader = JMSType OR (JMSType = 'aardvark' + 'sandwich')";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        this.checkNoSubstitute("JMSType");
    }

    private void checkNoSubstitute(String fieldName) {
        String selector = "Other" + fieldName + " = 767868";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "cheese = 'cheddar' AND Wrong" + fieldName + " = 54";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "fruit = 'pomegranate' AND " + fieldName + "NotThisOne = 'tuesday'";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = '" + fieldName + "'";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = ' " + fieldName + "'";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = ' " + fieldName + " '";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = 'xyz " + fieldName + "'";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = 'xyz" + fieldName + "'";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = '" + fieldName + "xyz'";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
        selector = "animal = 'lion' AND animal_name = 'xyz" + fieldName + "xyz'";
        Assertions.assertEquals((Object)selector, (Object)SelectorTranslator.convertToActiveMQFilterString((String)selector));
    }
}

