/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.UTF8Util;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UTF8Test
extends ActiveMQTestBase {
    @Test
    public void testValidateUTFWithENDChars() {
        this.testValidateUTFWithChars(1024, '\u0000');
    }

    @Test
    public void testValidateUTFWithLastAsciiChars() {
        this.testValidateUTFWithChars(1024, '\u007f');
    }

    private void testValidateUTFWithChars(int size, char c) {
        char[] chars = new char[size];
        Arrays.fill(chars, c);
        String expectedUtf8String = new String(chars);
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)(4 * chars.length));
        UTF8Util.saveUTF((ByteBuf)buffer.byteBuf(), (String)expectedUtf8String);
        byte[] expectedBytes = expectedUtf8String.getBytes(StandardCharsets.UTF_8);
        int encodedSize = buffer.readUnsignedShort();
        byte[] realEncodedBytes = new byte[encodedSize];
        buffer.getBytes(buffer.readerIndex(), realEncodedBytes);
        Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])realEncodedBytes);
    }

    @Test
    public void testValidateUTF() throws Exception {
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)61440);
        byte[] bytes = new byte[20000];
        RandomUtil.getRandom().nextBytes(bytes);
        String str = new String(bytes);
        UTF8Util.saveUTF((ByteBuf)buffer.byteBuf(), (String)str);
        String newStr = UTF8Util.readUTF((ActiveMQBuffer)buffer);
        Assertions.assertEquals((Object)str, (Object)newStr);
    }

    @Test
    public void testValidateUTFOnDataInput() throws Exception {
        for (int i = 0; i < 100; ++i) {
            byte[] bytes = new byte[15000 + RandomUtil.randomPositiveInt() % 5000];
            RandomUtil.getRandom().nextBytes(bytes);
            String str = new String(bytes);
            this.testValidateUTFOnDataInputStream(str, ActiveMQBuffers.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(str.length() * 3 + 2)));
            this.testValidateUTFOnDataInputStream(str, ActiveMQBuffers.dynamicBuffer((int)100));
            this.testValidateUTFOnDataInputStream(str, ActiveMQBuffers.fixedBuffer((int)102400));
        }
    }

    private void testValidateUTFOnDataInputStream(String str, ActiveMQBuffer wrap) throws Exception {
        UTF8Util.saveUTF((ByteBuf)wrap.byteBuf(), (String)str);
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(wrap.toByteBuffer().array()));
        String newStr = data.readUTF();
        Assertions.assertEquals((Object)str, (Object)newStr);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream outData = new DataOutputStream(byteOut);
        outData.writeUTF(str);
        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])byteOut.toByteArray());
        newStr = UTF8Util.readUTF((ActiveMQBuffer)buffer);
        Assertions.assertEquals((Object)str, (Object)newStr);
    }

    @Test
    public void testBigSize() throws Exception {
        char[] chars = new char[65536];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = 32;
        }
        String str = new String(chars);
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)65539);
        try {
            UTF8Util.saveUTF((ByteBuf)buffer.byteBuf(), (String)str);
            Assertions.fail((String)"String is too big, supposed to throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)buffer.writerIndex(), (String)"A buffer was supposed to be untouched since the string was too big");
        chars = new char[25000];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = 2064;
        }
        str = new String(chars);
        try {
            UTF8Util.saveUTF((ByteBuf)buffer.byteBuf(), (String)str);
            Assertions.fail((String)"Encoded String is too big, supposed to throw an exception");
        }
        catch (Exception i) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)buffer.writerIndex(), (String)"A buffer was supposed to be untouched since the string was too big");
        chars = new char[65535];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(i % 100 + 1);
        }
        str = new String(chars);
        UTF8Util.saveUTF((ByteBuf)buffer.byteBuf(), (String)str);
        Assertions.assertEquals((int)65537, (int)buffer.writerIndex());
        String newStr = UTF8Util.readUTF((ActiveMQBuffer)buffer);
        Assertions.assertEquals((Object)str, (Object)newStr);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        UTF8Util.clearBuffer();
        super.tearDown();
    }
}

