/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.loading.impl.AbstractHibernateOrmSelectionEntityLoader;
import org.hibernate.search.mapper.orm.loading.impl.EntityLoadingCacheLookupStrategyImplementor;
import org.hibernate.search.mapper.orm.loading.impl.PersistenceContextLookupStrategy;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmLoadingSessionContext;
import org.hibernate.search.mapper.orm.loading.spi.MutableEntityLoadingOptions;
import org.hibernate.search.util.common.annotation.impl.SuppressForbiddenApis;

class HibernateOrmSelectionEntityByIdLoader<E>
extends AbstractHibernateOrmSelectionEntityLoader<E> {
    private final PersistenceContextLookupStrategy persistenceContextLookup;
    private final EntityLoadingCacheLookupStrategyImplementor cacheLookupStrategyImplementor;

    HibernateOrmSelectionEntityByIdLoader(EntityMappingType rootEntityMappingType, TypeQueryFactory<E, ?> queryFactory, HibernateOrmLoadingSessionContext sessionContext, PersistenceContextLookupStrategy persistenceContextLookup, EntityLoadingCacheLookupStrategyImplementor cacheLookupStrategyImplementor, MutableEntityLoadingOptions loadingOptions) {
        super(rootEntityMappingType, queryFactory, sessionContext, loadingOptions);
        this.persistenceContextLookup = persistenceContextLookup;
        this.cacheLookupStrategyImplementor = cacheLookupStrategyImplementor;
    }

    @Override
    protected List<E> doLoadEntities(List<?> allIds, Long timeout) {
        EntityKey key;
        int i;
        EntityKey[] keys = this.toEntityKeys(allIds);
        List loadedEntities = HibernateOrmSelectionEntityByIdLoader.createListContainingNulls(allIds.size());
        int fetchSize = this.loadingOptions.fetchSize();
        Query query = this.createQuery(fetchSize, timeout);
        ArrayList<Object> ids = new ArrayList<Object>(fetchSize);
        for (i = 0; i < keys.length; ++i) {
            Object cacheHit;
            key = keys[i];
            if (this.cacheLookupStrategyImplementor != null && (cacheHit = this.cacheLookupStrategyImplementor.lookup(key)) != null) {
                loadedEntities.set(i, cacheHit);
                keys[i] = null;
                continue;
            }
            ids.add(key.getIdentifier());
            if (ids.size() < fetchSize) continue;
            query.setParameterList("ids", ids);
            query.getResultList();
            ids.clear();
        }
        if (!ids.isEmpty()) {
            query.setParameterList("ids", ids);
            query.getResultList();
        }
        for (i = 0; i < keys.length; ++i) {
            key = keys[i];
            if (key == null) continue;
            Object loaded = this.persistenceContextLookup.lookup(key);
            loadedEntities.set(i, loaded);
        }
        return loadedEntities;
    }

    @SuppressForbiddenApis(reason="generateEntityKey requires passing an EntityPersister")
    private EntityKey[] toEntityKeys(List<?> ids) {
        EntityKey[] entityKeys = new EntityKey[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            EntityKey entityKey;
            Object id = ids.get(i);
            entityKeys[i] = entityKey = this.sessionContext.session().generateEntityKey(id, this.entityMappingType.getEntityPersister());
        }
        return entityKeys;
    }

    private static <T> List<T> createListContainingNulls(int size) {
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
        return list;
    }
}

