/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.ListenerRegistry;
import io.undertow.server.OpenListener;
import io.undertow.server.protocol.http.AlpnOpenListener;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.server.protocol.http2.Http2OpenListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.NetworkUtils;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.ssl.SslConnection;

public class HttpsListenerService
extends HttpListenerService {
    private Supplier<SSLContext> sslContextSupplier;
    private volatile AcceptingChannel<SslConnection> sslServer;
    static final String PROTOCOL = "https";
    private final String cipherSuites;
    private final boolean proxyProtocol;

    public HttpsListenerService(Consumer<ListenerService> serviceConsumer, PathAddress address, String serverName, OptionMap listenerOptions, String cipherSuites, OptionMap socketOptions, boolean proxyProtocol) {
        this(serviceConsumer, address, serverName, listenerOptions, cipherSuites, socketOptions, false, false, proxyProtocol);
    }

    HttpsListenerService(Consumer<ListenerService> serviceConsumer, PathAddress address, String serverName, OptionMap listenerOptions, String cipherSuites, OptionMap socketOptions, boolean certificateForwarding, boolean proxyAddressForwarding, boolean proxyProtocol) {
        super(serviceConsumer, address, serverName, listenerOptions, socketOptions, certificateForwarding, proxyAddressForwarding, proxyProtocol);
        this.cipherSuites = cipherSuites;
        this.proxyProtocol = proxyProtocol;
    }

    void setSSLContextSupplier(Supplier<SSLContext> sslContextSupplier) {
        this.sslContextSupplier = sslContextSupplier;
    }

    @Override
    protected UndertowXnioSsl getSsl() {
        SSLContext sslContext = this.sslContextSupplier.get();
        OptionMap combined = this.getSSLOptions(sslContext);
        return new UndertowXnioSsl(((XnioWorker)this.worker.get()).getXnio(), combined, sslContext);
    }

    @Override
    protected OptionMap getSSLOptions(SSLContext sslContext) {
        OptionMap.Builder builder = OptionMap.builder().addAll(commonOptions);
        builder.addAll(this.socketOptions);
        builder.set(Options.USE_DIRECT_BUFFERS, true);
        if (this.cipherSuites != null) {
            Object[] cipherList = CipherSuiteSelector.fromString((String)this.cipherSuites).evaluate(sslContext.getSupportedSSLParameters().getCipherSuites());
            builder.setSequence(HttpsListenerResourceDefinition.ENABLED_CIPHER_SUITES.getOption(), cipherList);
        }
        return builder.getMap();
    }

    @Override
    protected OpenListener createOpenListener() {
        if (this.listenerOptions.get(UndertowOptions.ENABLE_HTTP2, false)) {
            try {
                return this.createAlpnOpenListener();
            }
            catch (Throwable e) {
                UndertowLogger.ROOT_LOGGER.alpnNotFound(this.getName());
                UndertowLogger.ROOT_LOGGER.debug("Exception creating ALPN listener", e);
                return super.createOpenListener();
            }
        }
        return super.createOpenListener();
    }

    private OpenListener createAlpnOpenListener() {
        OptionMap undertowOptions = OptionMap.builder().addAll(commonOptions).addAll(this.listenerOptions).set(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, this.getUndertowService().isStatisticsEnabled()).getMap();
        ByteBufferPool bufferPool = (ByteBufferPool)this.getBufferPool().get();
        HttpOpenListener http = new HttpOpenListener(bufferPool, undertowOptions);
        AlpnOpenListener alpn = new AlpnOpenListener(bufferPool, undertowOptions, (DelegateOpenListener)http);
        if (this.listenerOptions.get(UndertowOptions.ENABLE_HTTP2, false)) {
            Http2OpenListener http2 = new Http2OpenListener(bufferPool, undertowOptions, "h2");
            alpn.addProtocol("h2", (DelegateOpenListener)http2, 10);
            Http2OpenListener http2_14 = new Http2OpenListener(bufferPool, undertowOptions, "h2-14");
            alpn.addProtocol("h2-14", (DelegateOpenListener)http2_14, 9);
        }
        return alpn;
    }

    @Override
    protected void startListening(XnioWorker worker, InetSocketAddress socketAddress, ChannelListener<AcceptingChannel<StreamConnection>> acceptListener) throws IOException {
        if (this.proxyProtocol) {
            this.sslServer = worker.createStreamConnectionServer((SocketAddress)socketAddress, acceptListener, this.getSSLOptions(this.sslContextSupplier.get()));
        } else {
            UndertowXnioSsl ssl = this.getSsl();
            this.sslServer = ssl.createSslConnectionServer(worker, socketAddress, acceptListener, this.getSSLOptions(this.sslContextSupplier.get()));
        }
        this.sslServer.resumeAccepts();
        InetSocketAddress boundAddress = (InetSocketAddress)this.sslServer.getLocalAddress(InetSocketAddress.class);
        UndertowLogger.ROOT_LOGGER.listenerStarted("HTTPS", this.getName(), NetworkUtils.formatIPAddressForURI((InetAddress)boundAddress.getAddress()), boundAddress.getPort());
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    protected void stopListening() {
        InetSocketAddress boundAddress = (InetSocketAddress)this.sslServer.getLocalAddress(InetSocketAddress.class);
        this.sslServer.suspendAccepts();
        UndertowLogger.ROOT_LOGGER.listenerSuspend("HTTPS", this.getName());
        IoUtils.safeClose(this.sslServer);
        this.sslServer = null;
        UndertowLogger.ROOT_LOGGER.listenerStopped("HTTPS", this.getName(), NetworkUtils.formatIPAddressForURI((InetAddress)boundAddress.getAddress()), boundAddress.getPort());
        ((ListenerRegistry)this.httpListenerRegistry.get()).removeListener(this.getName());
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }
}

